/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.time.Instant;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.teamapps.model.controlcenter.Appointment;
import org.teamapps.model.controlcenter.AppointmentSeries;
import org.teamapps.model.controlcenter.AppointmentSeriesType;
import org.teamapps.model.controlcenter.Message;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.bool.BooleanIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.numeric.ShortIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.EntityBitSetList;

public class UdbAppointmentSeries
extends AbstractUdbEntity<AppointmentSeries>
implements AppointmentSeries {
    protected static TableIndex table;
    protected static IntegerIndex metaCreationDate;
    protected static IntegerIndex metaCreatedBy;
    protected static IntegerIndex metaModificationDate;
    protected static IntegerIndex metaModifiedBy;
    protected static IntegerIndex metaDeletionDate;
    protected static IntegerIndex metaDeletedBy;
    protected static IntegerIndex metaRestoreDate;
    protected static IntegerIndex metaRestoredBy;
    protected static SingleReferenceIndex message;
    protected static MultiReferenceIndex appointments;
    protected static ShortIndex appointmentSeriesType;
    protected static IntegerIndex repeatEvery;
    protected static LongIndex startDateTime;
    protected static LongIndex endDateTime;
    protected static BooleanIndex fullDayEvent;
    protected static LongIndex seriesEndDate;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
        metaCreationDate = (IntegerIndex)tableIndex.getColumnIndex("metaCreationDate");
        metaCreatedBy = (IntegerIndex)tableIndex.getColumnIndex("metaCreatedBy");
        metaModificationDate = (IntegerIndex)tableIndex.getColumnIndex("metaModificationDate");
        metaModifiedBy = (IntegerIndex)tableIndex.getColumnIndex("metaModifiedBy");
        metaDeletionDate = (IntegerIndex)tableIndex.getColumnIndex("metaDeletionDate");
        metaDeletedBy = (IntegerIndex)tableIndex.getColumnIndex("metaDeletedBy");
        metaRestoreDate = (IntegerIndex)tableIndex.getColumnIndex("metaRestoreDate");
        metaRestoredBy = (IntegerIndex)tableIndex.getColumnIndex("metaRestoredBy");
        message = (SingleReferenceIndex)tableIndex.getColumnIndex("message");
        appointments = (MultiReferenceIndex)tableIndex.getColumnIndex("appointments");
        appointmentSeriesType = (ShortIndex)tableIndex.getColumnIndex("appointmentSeriesType");
        repeatEvery = (IntegerIndex)tableIndex.getColumnIndex("repeatEvery");
        startDateTime = (LongIndex)tableIndex.getColumnIndex("startDateTime");
        endDateTime = (LongIndex)tableIndex.getColumnIndex("endDateTime");
        fullDayEvent = (BooleanIndex)tableIndex.getColumnIndex("fullDayEvent");
        seriesEndDate = (LongIndex)tableIndex.getColumnIndex("seriesEndDate");
    }

    public static List<AppointmentSeries> getAll() {
        return new EntityBitSetList(AppointmentSeries.getBuilder(), table.getRecordBitSet());
    }

    public static List<AppointmentSeries> getDeletedRecords() {
        return new EntityBitSetList(AppointmentSeries.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<AppointmentSeries> sort(List<AppointmentSeries> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbAppointmentSeries.sort((TableIndex)table, list, (String)sortFieldName, (boolean)ascending, (UserContext)userContext, (String[])path);
    }

    public static List<AppointmentSeries> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbAppointmentSeries.sort((TableIndex)table, AppointmentSeries.getBuilder(), (BitSet)recordIds, (String)sortFieldName, (boolean)ascending, (UserContext)userContext, (String[])path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbAppointmentSeries() {
        super(table);
    }

    public UdbAppointmentSeries(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    public AppointmentSeries build() {
        return new UdbAppointmentSeries();
    }

    public AppointmentSeries build(int id) {
        return new UdbAppointmentSeries(id, false);
    }

    @Override
    public Instant getMetaCreationDate() {
        return this.getTimestampValue(metaCreationDate);
    }

    @Override
    public AppointmentSeries setMetaCreationDate(Instant value) {
        this.setTimestampValue(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaCreationDate);
    }

    @Override
    public AppointmentSeries setMetaCreationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaCreationDate);
        return this;
    }

    @Override
    public long getMetaCreationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaCreationDate);
    }

    @Override
    public AppointmentSeries setMetaCreationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreatedBy() {
        return this.getIntValue(metaCreatedBy);
    }

    @Override
    public AppointmentSeries setMetaCreatedBy(int value) {
        this.setIntValue(value, metaCreatedBy);
        return this;
    }

    @Override
    public Instant getMetaModificationDate() {
        return this.getTimestampValue(metaModificationDate);
    }

    @Override
    public AppointmentSeries setMetaModificationDate(Instant value) {
        this.setTimestampValue(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModificationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaModificationDate);
    }

    @Override
    public AppointmentSeries setMetaModificationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaModificationDate);
        return this;
    }

    @Override
    public long getMetaModificationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaModificationDate);
    }

    @Override
    public AppointmentSeries setMetaModificationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModifiedBy() {
        return this.getIntValue(metaModifiedBy);
    }

    @Override
    public AppointmentSeries setMetaModifiedBy(int value) {
        this.setIntValue(value, metaModifiedBy);
        return this;
    }

    @Override
    public Instant getMetaDeletionDate() {
        return this.getTimestampValue(metaDeletionDate);
    }

    @Override
    public AppointmentSeries setMetaDeletionDate(Instant value) {
        this.setTimestampValue(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletionDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaDeletionDate);
    }

    @Override
    public AppointmentSeries setMetaDeletionDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaDeletionDate);
        return this;
    }

    @Override
    public long getMetaDeletionDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaDeletionDate);
    }

    @Override
    public AppointmentSeries setMetaDeletionDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletedBy() {
        return this.getIntValue(metaDeletedBy);
    }

    @Override
    public AppointmentSeries setMetaDeletedBy(int value) {
        this.setIntValue(value, metaDeletedBy);
        return this;
    }

    @Override
    public Instant getMetaRestoreDate() {
        return this.getTimestampValue(metaRestoreDate);
    }

    @Override
    public AppointmentSeries setMetaRestoreDate(Instant value) {
        this.setTimestampValue(value, metaRestoreDate);
        return this;
    }

    @Override
    public int getMetaRestoreDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaRestoreDate);
    }

    @Override
    public AppointmentSeries setMetaRestoreDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaRestoreDate);
        return this;
    }

    @Override
    public long getMetaRestoreDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaRestoreDate);
    }

    @Override
    public AppointmentSeries setMetaRestoreDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaRestoreDate);
        return this;
    }

    @Override
    public int getMetaRestoredBy() {
        return this.getIntValue(metaRestoredBy);
    }

    @Override
    public AppointmentSeries setMetaRestoredBy(int value) {
        this.setIntValue(value, metaRestoredBy);
        return this;
    }

    @Override
    public Message getMessage() {
        if (this.isChanged((ColumnIndex)message)) {
            return (Message)this.getReferenceChangeValue((ColumnIndex)message);
        }
        int id = message.getValue(this.getId());
        if (id > 0) {
            return Message.getById(id);
        }
        return null;
    }

    @Override
    public AppointmentSeries setMessage(Message value) {
        this.setSingleReferenceValue(message, value, table);
        return this;
    }

    @Override
    public List<Appointment> getAppointments() {
        return this.getMultiReferenceValue(appointments, Appointment.getBuilder());
    }

    @Override
    public AppointmentSeries setAppointments(List<Appointment> value) {
        this.setMultiReferenceValue(value, appointments);
        return this;
    }

    @Override
    public int getAppointmentsCount() {
        return this.getMultiReferenceValueCount(appointments, Appointment.getBuilder());
    }

    @Override
    public AppointmentSeries setAppointments(Appointment ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), appointments);
        return this;
    }

    @Override
    public BitSet getAppointmentsAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(appointments, Appointment.getBuilder());
    }

    @Override
    public AppointmentSeries addAppointments(List<Appointment> value) {
        this.addMultiReferenceValue(value, appointments);
        return this;
    }

    @Override
    public AppointmentSeries addAppointments(Appointment ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), appointments);
        return this;
    }

    @Override
    public AppointmentSeries removeAppointments(List<Appointment> value) {
        this.removeMultiReferenceValue(value, appointments);
        return this;
    }

    @Override
    public AppointmentSeries removeAppointments(Appointment ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), appointments);
        return this;
    }

    @Override
    public AppointmentSeries removeAllAppointments() {
        this.removeAllMultiReferenceValue(appointments);
        return this;
    }

    @Override
    public AppointmentSeriesType getAppointmentSeriesType() {
        return (AppointmentSeriesType)this.getEnumValue(appointmentSeriesType, AppointmentSeriesType.values());
    }

    @Override
    public AppointmentSeries setAppointmentSeriesType(AppointmentSeriesType value) {
        this.setEnumValue(appointmentSeriesType, value);
        return this;
    }

    @Override
    public int getRepeatEvery() {
        return this.getIntValue(repeatEvery);
    }

    @Override
    public AppointmentSeries setRepeatEvery(int value) {
        this.setIntValue(value, repeatEvery);
        return this;
    }

    @Override
    public Instant getStartDateTime() {
        return this.getDateTimeValue(startDateTime);
    }

    @Override
    public AppointmentSeries setStartDateTime(Instant value) {
        this.setDateTimeValue(value, startDateTime);
        return this;
    }

    @Override
    public long getStartDateTimeAsEpochMilli() {
        return this.getDateTimeAsEpochMilli(startDateTime);
    }

    @Override
    public AppointmentSeries setStartDateTimeAsEpochMilli(long value) {
        this.setDateTimeAsEpochMilli(value, startDateTime);
        return this;
    }

    @Override
    public Instant getEndDateTime() {
        return this.getDateTimeValue(endDateTime);
    }

    @Override
    public AppointmentSeries setEndDateTime(Instant value) {
        this.setDateTimeValue(value, endDateTime);
        return this;
    }

    @Override
    public long getEndDateTimeAsEpochMilli() {
        return this.getDateTimeAsEpochMilli(endDateTime);
    }

    @Override
    public AppointmentSeries setEndDateTimeAsEpochMilli(long value) {
        this.setDateTimeAsEpochMilli(value, endDateTime);
        return this;
    }

    @Override
    public boolean getFullDayEvent() {
        return this.getBooleanValue(fullDayEvent);
    }

    @Override
    public AppointmentSeries setFullDayEvent(boolean value) {
        this.setBooleanValue(value, fullDayEvent);
        return this;
    }

    @Override
    public boolean isFullDayEvent() {
        return this.getBooleanValue(fullDayEvent);
    }

    @Override
    public LocalDate getSeriesEndDate() {
        return this.getLocalDateValue(seriesEndDate);
    }

    @Override
    public AppointmentSeries setSeriesEndDate(LocalDate value) {
        this.setLocalDateValue(value, seriesEndDate);
        return this;
    }

    @Override
    public long getSeriesEndDateAsEpochMilli() {
        if (this.isChanged((ColumnIndex)seriesEndDate)) {
            return (Long)this.getChangedValue((ColumnIndex)seriesEndDate);
        }
        return seriesEndDate.getValue(this.getId());
    }

    @Override
    public AppointmentSeries setSeriesEndDateAsEpochMilli(long value) {
        this.setLocalDateAsEpochMilli(value, seriesEndDate);
        this.setChangeValue((ColumnIndex)seriesEndDate, value, table);
        return this;
    }

    public UdbAppointmentSeries save() {
        this.saveRecord();
        return this;
    }

    public void delete() {
        this.deleteRecord();
    }

    public void restoreDeleted() {
        this.restoreDeletedRecord();
    }
}

