package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface Login extends Entity<Login> {

	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_USER = "user";
	final static String FIELD_IP = "ip";
	final static String FIELD_USER_AGENT = "userAgent";
	final static String FIELD_MOBILE_DEVICE = "mobileDevice";
	final static String FIELD_SCREEN_SIZE = "screenSize";
	final static String FIELD_DATE_LOGIN = "dateLogin";
	final static String FIELD_DATE_LOGOUT = "dateLogout";
	final static String FIELD_ACTIVITY_COUNT = "activityCount";
	final static String FIELD_APPLICATION_OPEN_COUNT = "applicationOpenCount";

    static Login create() {
        return new UdbLogin();
    }

    static Login create(int id) {
        return new UdbLogin(id, true);
    }

    static Login getById(int id) {
        return new UdbLogin(id, false);
    }

    static EntityBuilder<Login> getBuilder() {
        return new UdbLogin(0, false);
    }

    Instant getMetaDeletionDate();

    Login setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    Login setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    Login setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    Login setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    Login setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    Login setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    Login setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    Login setMetaRestoredBy(int value);

    User getUser();

    Login setUser(User value);

    String getIp();

    Login setIp(String value);

    String getUserAgent();

    Login setUserAgent(String value);

    boolean getMobileDevice();

    Login setMobileDevice(boolean value);

    boolean isMobileDevice();

    String getScreenSize();

    Login setScreenSize(String value);

    Instant getDateLogin();

    Login setDateLogin(Instant value);

    int getDateLoginAsEpochSecond();

    Login setDateLoginAsEpochSecond(int value);

    long getDateLoginAsEpochMilli();

    Login setDateLoginAsEpochMilli(long value);

    Instant getDateLogout();

    Login setDateLogout(Instant value);

    int getDateLogoutAsEpochSecond();

    Login setDateLogoutAsEpochSecond(int value);

    long getDateLogoutAsEpochMilli();

    Login setDateLogoutAsEpochMilli(long value);

    int getActivityCount();

    Login setActivityCount(int value);

    int getApplicationOpenCount();

    Login setApplicationOpenCount(int value);


    static List<Login> getAll() {
        return UdbLogin.getAll();
    }

    static List<Login> getDeletedRecords() {
        return UdbLogin.getDeletedRecords();
    }

    static List<Login> sort(List<Login> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbLogin.sort(list, sortFieldName, ascending, userContext, path);
    }

    static int getCount() {
        return UdbLogin.getCount();
    }

    static LoginQuery filter() {
        return new UdbLoginQuery();
    }
}

