package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbApplicationQuery extends AbstractUdbQuery<Application> implements ApplicationQuery {

    public UdbApplicationQuery() {
        super(UdbApplication.table, Application.getBuilder());
    }

    @Override
    public ApplicationQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public ApplicationQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public ApplicationQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public ApplicationQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbApplication.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public ApplicationQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbApplication.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public ApplicationQuery metaCreationDate(NumericFilter filter) {
		and(UdbApplication.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbApplication.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery metaCreatedBy(NumericFilter filter) {
		and(UdbApplication.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbApplication.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery metaModificationDate(NumericFilter filter) {
		and(UdbApplication.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbApplication.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery metaModifiedBy(NumericFilter filter) {
		and(UdbApplication.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbApplication.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery metaDeletionDate(NumericFilter filter) {
		and(UdbApplication.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbApplication.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery metaDeletedBy(NumericFilter filter) {
		and(UdbApplication.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbApplication.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery metaRestoreDate(NumericFilter filter) {
		and(UdbApplication.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbApplication.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery metaRestoredBy(NumericFilter filter) {
		and(UdbApplication.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbApplication.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery name(TextFilter filter) {
		and(UdbApplication.name.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orName(TextFilter filter) {
		or(UdbApplication.name.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery icon(TextFilter filter) {
		and(UdbApplication.icon.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orIcon(TextFilter filter) {
		or(UdbApplication.icon.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery titleKey(TextFilter filter) {
		and(UdbApplication.titleKey.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orTitleKey(TextFilter filter) {
		or(UdbApplication.titleKey.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery descriptionKey(TextFilter filter) {
		and(UdbApplication.descriptionKey.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orDescriptionKey(TextFilter filter) {
		or(UdbApplication.descriptionKey.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery unmanagedApplication(BooleanFilter filter) {
		and(UdbApplication.unmanagedApplication.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orUnmanagedApplication(BooleanFilter filter) {
		or(UdbApplication.unmanagedApplication.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery config(TextFilter filter) {
		and(UdbApplication.config.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orConfig(TextFilter filter) {
		or(UdbApplication.config.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery darkTheme(BooleanFilter filter) {
		and(UdbApplication.darkTheme.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orDarkTheme(BooleanFilter filter) {
		or(UdbApplication.darkTheme.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery filterPerspectives(ApplicationPerspectiveQuery query) {
		UdbApplicationPerspectiveQuery udbQuery = (UdbApplicationPerspectiveQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplication.perspectives, UdbApplicationPerspective.application);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationQuery perspectives(MultiReferenceFilterType type, ApplicationPerspective ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (ApplicationPerspective value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbApplication.perspectives.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery perspectivesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbApplication.perspectives.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery perspectives(MultiReferenceFilter filter) {
		and(UdbApplication.perspectives.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orPerspectives(MultiReferenceFilter filter) {
		or(UdbApplication.perspectives.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery filterPrivilegeGroups(ApplicationPrivilegeGroupQuery query) {
		UdbApplicationPrivilegeGroupQuery udbQuery = (UdbApplicationPrivilegeGroupQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplication.privilegeGroups, UdbApplicationPrivilegeGroup.application);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationQuery privilegeGroups(MultiReferenceFilterType type, ApplicationPrivilegeGroup ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (ApplicationPrivilegeGroup value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbApplication.privilegeGroups.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery privilegeGroupsCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbApplication.privilegeGroups.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery privilegeGroups(MultiReferenceFilter filter) {
		and(UdbApplication.privilegeGroups.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orPrivilegeGroups(MultiReferenceFilter filter) {
		or(UdbApplication.privilegeGroups.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery filterVersions(ApplicationVersionQuery query) {
		UdbApplicationVersionQuery udbQuery = (UdbApplicationVersionQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplication.versions, UdbApplicationVersion.application);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationQuery versions(MultiReferenceFilterType type, ApplicationVersion ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (ApplicationVersion value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbApplication.versions.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery versionsCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbApplication.versions.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery versions(MultiReferenceFilter filter) {
		and(UdbApplication.versions.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orVersions(MultiReferenceFilter filter) {
		or(UdbApplication.versions.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery filterInstalledVersion(ApplicationVersionQuery query) {
		UdbApplicationVersionQuery udbQuery = (UdbApplicationVersionQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplication.installedVersion);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationQuery installedVersion(NumericFilter filter) {
		and(UdbApplication.installedVersion.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orInstalledVersion(NumericFilter filter) {
		or(UdbApplication.installedVersion.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery filterInstalledAsMainApplication(ManagedApplicationQuery query) {
		UdbManagedApplicationQuery udbQuery = (UdbManagedApplicationQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplication.installedAsMainApplication, UdbManagedApplication.mainApplication);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationQuery installedAsMainApplication(MultiReferenceFilterType type, ManagedApplication ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (ManagedApplication value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbApplication.installedAsMainApplication.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery installedAsMainApplicationCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbApplication.installedAsMainApplication.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery installedAsMainApplication(MultiReferenceFilter filter) {
		and(UdbApplication.installedAsMainApplication.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationQuery orInstalledAsMainApplication(MultiReferenceFilter filter) {
		or(UdbApplication.installedAsMainApplication.createFilter(filter));
		return this;
	}


	@Override
	public UdbApplicationQuery andOr(ApplicationQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public ApplicationQuery customFilter(Function<Application, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(Application.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



