package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbApplicationVersionData extends AbstractUdbEntity<ApplicationVersionData> implements ApplicationVersionData {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static TextIndex data;
	protected static IntegerIndex dataRows;
	protected static TextIndex dataAdded;
	protected static IntegerIndex dataAddedRows;
	protected static TextIndex dataRemoved;
	protected static IntegerIndex dataRemovedRows;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		data = (TextIndex) tableIndex.getColumnIndex(FIELD_DATA);
		dataRows = (IntegerIndex) tableIndex.getColumnIndex(FIELD_DATA_ROWS);
		dataAdded = (TextIndex) tableIndex.getColumnIndex(FIELD_DATA_ADDED);
		dataAddedRows = (IntegerIndex) tableIndex.getColumnIndex(FIELD_DATA_ADDED_ROWS);
		dataRemoved = (TextIndex) tableIndex.getColumnIndex(FIELD_DATA_REMOVED);
		dataRemovedRows = (IntegerIndex) tableIndex.getColumnIndex(FIELD_DATA_REMOVED_ROWS);
    }

    public static List<ApplicationVersionData> getAll() {
        return new EntityBitSetList<>(ApplicationVersionData.getBuilder(), table.getRecordBitSet());
    }

    public static List<ApplicationVersionData> getDeletedRecords() {
        return new EntityBitSetList<>(ApplicationVersionData.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<ApplicationVersionData> sort(List<ApplicationVersionData> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<ApplicationVersionData> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, ApplicationVersionData.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbApplicationVersionData() {
        super(table);
    }

    public UdbApplicationVersionData(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public ApplicationVersionData build() {
        return new UdbApplicationVersionData();
    }

    @Override
    public ApplicationVersionData build(int id) {
        return new UdbApplicationVersionData(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public ApplicationVersionData setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public ApplicationVersionData setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public ApplicationVersionData setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public ApplicationVersionData setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public ApplicationVersionData setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public ApplicationVersionData setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public ApplicationVersionData setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public ApplicationVersionData setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public ApplicationVersionData setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public ApplicationVersionData setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public ApplicationVersionData setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public ApplicationVersionData setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public ApplicationVersionData setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public ApplicationVersionData setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public ApplicationVersionData setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public ApplicationVersionData setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public String getData() {
        return getTextValue(data);
	}

	@Override
	public ApplicationVersionData setData(String value) {
	    setTextValue(value, this.data);
		return this;
	}

	@Override
	public int getDataRows() {
        return getIntValue(dataRows);
	}

	@Override
	public ApplicationVersionData setDataRows(int value) {
	    setIntValue(value, this.dataRows);
		return this;
	}

	@Override
	public String getDataAdded() {
        return getTextValue(dataAdded);
	}

	@Override
	public ApplicationVersionData setDataAdded(String value) {
	    setTextValue(value, this.dataAdded);
		return this;
	}

	@Override
	public int getDataAddedRows() {
        return getIntValue(dataAddedRows);
	}

	@Override
	public ApplicationVersionData setDataAddedRows(int value) {
	    setIntValue(value, this.dataAddedRows);
		return this;
	}

	@Override
	public String getDataRemoved() {
        return getTextValue(dataRemoved);
	}

	@Override
	public ApplicationVersionData setDataRemoved(String value) {
	    setTextValue(value, this.dataRemoved);
		return this;
	}

	@Override
	public int getDataRemovedRows() {
        return getIntValue(dataRemovedRows);
	}

	@Override
	public ApplicationVersionData setDataRemovedRows(int value) {
	    setIntValue(value, this.dataRemovedRows);
		return this;
	}



    @Override
    public UdbApplicationVersionData save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



