package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbAppointmentQuery extends AbstractUdbQuery<Appointment> implements AppointmentQuery {

    public UdbAppointmentQuery() {
        super(UdbAppointment.table, Appointment.getBuilder());
    }

    @Override
    public AppointmentQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public AppointmentQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public AppointmentQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public AppointmentQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbAppointment.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public AppointmentQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbAppointment.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public AppointmentQuery metaCreationDate(NumericFilter filter) {
		and(UdbAppointment.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbAppointment.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery metaCreatedBy(NumericFilter filter) {
		and(UdbAppointment.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbAppointment.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery metaModificationDate(NumericFilter filter) {
		and(UdbAppointment.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbAppointment.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery metaModifiedBy(NumericFilter filter) {
		and(UdbAppointment.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbAppointment.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery metaDeletionDate(NumericFilter filter) {
		and(UdbAppointment.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbAppointment.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery metaDeletedBy(NumericFilter filter) {
		and(UdbAppointment.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbAppointment.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery metaRestoreDate(NumericFilter filter) {
		and(UdbAppointment.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbAppointment.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery metaRestoredBy(NumericFilter filter) {
		and(UdbAppointment.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbAppointment.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery filterMessage(MessageQuery query) {
		UdbMessageQuery udbQuery = (UdbMessageQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbAppointment.message, UdbMessage.appointment);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public AppointmentQuery message(NumericFilter filter) {
		and(UdbAppointment.message.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery orMessage(NumericFilter filter) {
		or(UdbAppointment.message.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery filterAppointmentSeries(AppointmentSeriesQuery query) {
		UdbAppointmentSeriesQuery udbQuery = (UdbAppointmentSeriesQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbAppointment.appointmentSeries, UdbAppointmentSeries.appointments);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public AppointmentQuery appointmentSeries(NumericFilter filter) {
		and(UdbAppointment.appointmentSeries.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery orAppointmentSeries(NumericFilter filter) {
		or(UdbAppointment.appointmentSeries.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery webConference(BooleanFilter filter) {
		and(UdbAppointment.webConference.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery orWebConference(BooleanFilter filter) {
		or(UdbAppointment.webConference.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery startDateTime(NumericFilter filter) {
		and(UdbAppointment.startDateTime.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery orStartDateTime(NumericFilter filter) {
		or(UdbAppointment.startDateTime.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery endDateTime(NumericFilter filter) {
		and(UdbAppointment.endDateTime.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery orEndDateTime(NumericFilter filter) {
		or(UdbAppointment.endDateTime.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery fullDayEvent(BooleanFilter filter) {
		and(UdbAppointment.fullDayEvent.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentQuery orFullDayEvent(BooleanFilter filter) {
		or(UdbAppointment.fullDayEvent.createFilter(filter));
		return this;
	}


	@Override
	public UdbAppointmentQuery andOr(AppointmentQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public AppointmentQuery customFilter(Function<Appointment, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(Appointment.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



