package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbLocalizationTopic extends AbstractUdbEntity<LocalizationTopic> implements LocalizationTopic {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static MultiReferenceIndex keys;
	protected static SingleReferenceIndex application;
	protected static TextIndex icon;
	protected static TextIndex title;
	protected static FileIndex screenshot;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		keys = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_KEYS);
		application = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_APPLICATION);
		icon = (TextIndex) tableIndex.getColumnIndex(FIELD_ICON);
		title = (TextIndex) tableIndex.getColumnIndex(FIELD_TITLE);
		screenshot = (FileIndex) tableIndex.getColumnIndex(FIELD_SCREENSHOT);
    }

    public static List<LocalizationTopic> getAll() {
        return new EntityBitSetList<>(LocalizationTopic.getBuilder(), table.getRecordBitSet());
    }

    public static List<LocalizationTopic> getDeletedRecords() {
        return new EntityBitSetList<>(LocalizationTopic.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<LocalizationTopic> sort(List<LocalizationTopic> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<LocalizationTopic> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, LocalizationTopic.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbLocalizationTopic() {
        super(table);
    }

    public UdbLocalizationTopic(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public LocalizationTopic build() {
        return new UdbLocalizationTopic();
    }

    @Override
    public LocalizationTopic build(int id) {
        return new UdbLocalizationTopic(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public LocalizationTopic setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public LocalizationTopic setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public LocalizationTopic setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public LocalizationTopic setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public LocalizationTopic setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public LocalizationTopic setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public LocalizationTopic setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public LocalizationTopic setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public LocalizationTopic setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public LocalizationTopic setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public LocalizationTopic setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public LocalizationTopic setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public LocalizationTopic setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public LocalizationTopic setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public LocalizationTopic setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public LocalizationTopic setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public List<LocalizationKey> getKeys() {
	    return getMultiReferenceValue(keys, LocalizationKey.getBuilder());
	}

	@Override
	public LocalizationTopic setKeys(List<LocalizationKey> value) {
		setMultiReferenceValue(value, keys);
		return this;
	}

	@Override
	public int getKeysCount() {
	    return getMultiReferenceValueCount(keys, LocalizationKey.getBuilder());
	}

	@Override
	public LocalizationTopic setKeys(LocalizationKey ... value) {
		setMultiReferenceValue(Arrays.asList(value), keys);
		return this;
	}

	@Override
	public BitSet getKeysAsBitSet() {
	    return getMultiReferenceValueAsBitSet(keys, LocalizationKey.getBuilder());
	}

	@Override
	public LocalizationTopic addKeys(List<LocalizationKey> value) {
		addMultiReferenceValue(value, keys);
		return this;
	}

	@Override
	public LocalizationTopic addKeys(LocalizationKey ... value) {
		addMultiReferenceValue(Arrays.asList(value), keys);
		return this;
	}

	@Override
	public LocalizationTopic removeKeys(List<LocalizationKey> value) {
		removeMultiReferenceValue(value, keys);
		return this;
	}

	@Override
	public LocalizationTopic removeKeys(LocalizationKey ... value) {
		removeMultiReferenceValue(Arrays.asList(value), keys);
		return this;
	}

	@Override
	public LocalizationTopic removeAllKeys() {
		removeAllMultiReferenceValue(keys);
		return this;
	}

	@Override
	public Application getApplication() {
		if (isChanged(application)) {
			return (Application) getReferenceChangeValue(application);
		} else {
			int id = application.getValue(getId());
			if (id > 0) {
				return Application.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public LocalizationTopic setApplication(Application value) {
		setSingleReferenceValue(application, value, table);
		return this;
	}

	@Override
	public String getIcon() {
        return getTextValue(icon);
	}

	@Override
	public LocalizationTopic setIcon(String value) {
	    setTextValue(value, this.icon);
		return this;
	}

	@Override
	public String getTitle() {
        return getTextValue(title);
	}

	@Override
	public LocalizationTopic setTitle(String value) {
	    setTextValue(value, this.title);
		return this;
	}

	@Override
	public FileValue getScreenshot() {
		if (isChanged(screenshot)) {
			return (FileValue) getChangedValue(screenshot);
		} else {
			return screenshot.getValue(getId());
		}
	}

	@Override
	public LocalizationTopic setScreenshot(File value) {
	    FileValue storeFile = screenshot.storeFile(value);
		setChangeValue(this.screenshot, storeFile, table);
		return this;
	}

	@Override
	public LocalizationTopic setScreenshot(File value, String fileName) {
	    FileValue storeFile = screenshot.storeFile(value, fileName);
		setChangeValue(this.screenshot, storeFile, table);
		return this;
	}



    @Override
    public UdbLocalizationTopic save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



