package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbNewsBoardMessageTranslationQuery extends AbstractUdbQuery<NewsBoardMessageTranslation> implements NewsBoardMessageTranslationQuery {

    public UdbNewsBoardMessageTranslationQuery() {
        super(UdbNewsBoardMessageTranslation.table, NewsBoardMessageTranslation.getBuilder());
    }

    @Override
    public NewsBoardMessageTranslationQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public NewsBoardMessageTranslationQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public NewsBoardMessageTranslationQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public NewsBoardMessageTranslationQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbNewsBoardMessageTranslation.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbNewsBoardMessageTranslation.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery metaCreationDate(NumericFilter filter) {
		and(UdbNewsBoardMessageTranslation.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbNewsBoardMessageTranslation.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery metaCreatedBy(NumericFilter filter) {
		and(UdbNewsBoardMessageTranslation.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbNewsBoardMessageTranslation.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery metaModificationDate(NumericFilter filter) {
		and(UdbNewsBoardMessageTranslation.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbNewsBoardMessageTranslation.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery metaModifiedBy(NumericFilter filter) {
		and(UdbNewsBoardMessageTranslation.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbNewsBoardMessageTranslation.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery metaDeletionDate(NumericFilter filter) {
		and(UdbNewsBoardMessageTranslation.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbNewsBoardMessageTranslation.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery metaDeletedBy(NumericFilter filter) {
		and(UdbNewsBoardMessageTranslation.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbNewsBoardMessageTranslation.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery metaRestoreDate(NumericFilter filter) {
		and(UdbNewsBoardMessageTranslation.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbNewsBoardMessageTranslation.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery metaRestoredBy(NumericFilter filter) {
		and(UdbNewsBoardMessageTranslation.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbNewsBoardMessageTranslation.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery filterMessage(NewsBoardMessageQuery query) {
		UdbNewsBoardMessageQuery udbQuery = (UdbNewsBoardMessageQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbNewsBoardMessageTranslation.message, UdbNewsBoardMessage.translations);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery message(NumericFilter filter) {
		and(UdbNewsBoardMessageTranslation.message.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery orMessage(NumericFilter filter) {
		or(UdbNewsBoardMessageTranslation.message.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery language(TextFilter filter) {
		and(UdbNewsBoardMessageTranslation.language.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery orLanguage(TextFilter filter) {
		or(UdbNewsBoardMessageTranslation.language.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery translation(TextFilter filter) {
		and(UdbNewsBoardMessageTranslation.translation.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageTranslationQuery orTranslation(TextFilter filter) {
		or(UdbNewsBoardMessageTranslation.translation.createFilter(filter));
		return this;
	}


	@Override
	public UdbNewsBoardMessageTranslationQuery andOr(NewsBoardMessageTranslationQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public NewsBoardMessageTranslationQuery customFilter(Function<NewsBoardMessageTranslation, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(NewsBoardMessageTranslation.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



