/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.accesscontrol;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.controlcenter.Privileges;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.bootstrap.LoadedApplication;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.server.system.utils.ValueConverterUtils;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.combo.ComboBoxUtils;
import org.teamapps.application.ux.form.FormController;
import org.teamapps.application.ux.view.MasterDetailController;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.databinding.MutableValue;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationPrivilege;
import org.teamapps.model.controlcenter.ApplicationPrivilegeGroup;
import org.teamapps.model.controlcenter.OrganizationField;
import org.teamapps.model.controlcenter.OrganizationUnitType;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.model.controlcenter.Role;
import org.teamapps.model.controlcenter.RolePrivilegeAssignment;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.pojo.Query;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.CheckBox;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.combobox.TagBoxWrappingMode;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.model.ComboBoxModel;

public class AccessControlPerspective
extends AbstractManagedApplicationPerspective {
    private final PerspectiveSessionData perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
    private final UserSessionData userSessionData = this.perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();

    public AccessControlPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.createUi();
    }

    private void createUi() {
        Supplier<Query> querySupplier = () -> this.isAppFilter() ? RolePrivilegeAssignment.filter().organizationFieldFilter(NumericFilter.equalsFilter((Number)this.getOrganizationField().getId())) : RolePrivilegeAssignment.filter();
        MasterDetailController masterDetailController = new MasterDetailController(ApplicationIcons.KEYS, this.getLocalized("accessControl.accessControlListEntries"), this.getApplicationInstanceData(), querySupplier, Privileges.ACCESS_CONTROL_PERSPECTIVE);
        EntityModelBuilder entityModelBuilder = masterDetailController.getEntityModelBuilder();
        FormController formController = masterDetailController.getFormController();
        ResponsiveForm form = masterDetailController.getResponsiveForm();
        Table table = entityModelBuilder.createTable();
        table.setDisplayAsList(true);
        table.setRowHeight(28);
        table.setStripedRows(false);
        entityModelBuilder.updateModels();
        TemplateField roleTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.createRolePropertyProvider(this.getApplicationInstanceData()));
        TemplateField applicationTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.createApplicationPropertyProvider(this.userSessionData));
        TemplateField applicationPrivilegeGroupTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.createApplicationPrivilegeGroupPropertyProvider(this.userSessionData));
        TagComboBox applicationPrivilegesTableField = UiUtils.createTagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createApplicationPrivilegePropertyProvider(this.userSessionData));
        TemplateField customOrganizationUnitTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.creatOrganizationUnitPropertyProvider(this.getApplicationInstanceData()));
        table.addColumn(new TableColumn("role", this.getLocalized("roles.role"), (AbstractField)roleTableField).setDefaultWidth(200));
        table.addColumn(new TableColumn("application", this.getLocalized("applications.application"), (AbstractField)applicationTableField).setDefaultWidth(200));
        table.addColumn(new TableColumn("privilegeGroup", this.getLocalized("accessControl.privilegeGroup"), (AbstractField)applicationPrivilegeGroupTableField).setDefaultWidth(200));
        table.addColumn(new TableColumn("privileges", this.getLocalized("accessControl.privileges"), (AbstractField)applicationPrivilegesTableField).setDefaultWidth(350));
        table.addColumn(new TableColumn("fixedOrganizationRoot", this.getLocalized("accessControl.customOrganizationUnit"), (AbstractField)customOrganizationUnitTableField).setDefaultWidth(200));
        table.setPropertyExtractor((rolePrivilegeAssignment, propertyName) -> switch (propertyName) {
            case "role" -> rolePrivilegeAssignment.getRole();
            case "application" -> rolePrivilegeAssignment.getApplication();
            case "privilegeGroup" -> rolePrivilegeAssignment.getPrivilegeGroup();
            case "privileges" -> rolePrivilegeAssignment.getPrivileges();
            case "fixedOrganizationRoot" -> rolePrivilegeAssignment.getFixedOrganizationRoot();
            default -> null;
        });
        ComboBox roleComboBox = ComboBoxUtils.createRecordComboBox(() -> this.isAppFilter() ? Role.filter().organizationField(NumericFilter.equalsFilter((Number)this.getOrganizationField().getId())).execute() : Role.getAll(), PropertyProviders.createRolePropertyProvider(this.getApplicationInstanceData()), (Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        ComboBox<Application> applicationComboBox = this.createApplicationComboBox();
        ComboBox<ApplicationPrivilegeGroup> privilegeGroupComboBox = this.createPrivilegeGroupComboBox(applicationComboBox);
        TagComboBox<ApplicationPrivilege> privilegesTagComboBox = this.createPrivilegeTagComboBox(privilegeGroupComboBox);
        TagComboBox<PrivilegeObject> privilegeObjectTagComboBox = this.createPrivilegeObjectTagComboBox(applicationComboBox, privilegeGroupComboBox);
        CheckBox privilegeObjectInheritanceCheckBox = new CheckBox(this.getLocalized("accessControl.privilegeObjectInheritance"));
        ComboBox<OrganizationField> organizationFieldFilterComboBox = this.createOrganizationFieldComboBox();
        AbstractField customOrganizationUnit = formController.getOrganizationUnitViewField((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES, true);
        TagComboBox<OrganizationUnitType> organizationUnitTypeFilterTagComboBox = OrganizationUtils.createOrganizationUnitTypeTagComboBox(50, this.getApplicationInstanceData());
        CheckBox noOrgUnitInheritanceCheckBox = new CheckBox(this.getLocalized("accessControl.noInheritanceOfOrganizationalUnits"));
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(450);
        formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false);
        formLayout.addLabelAndField(null, this.getLocalized("roles.role"), (AbstractField)roleComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("applications.application"), applicationComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("accessControl.privilegeGroup"), privilegeGroupComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("accessControl.privileges"), privilegesTagComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("accessControl.privilegeObjects"), privilegeObjectTagComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("accessControl.privilegeObjectInheritance"), (AbstractField)privilegeObjectInheritanceCheckBox);
        if (!this.isOrgFieldFilterApplied()) {
            formLayout.addLabelAndField(null, this.getLocalized("accessControl.organizationFieldFilter"), organizationFieldFilterComboBox);
        }
        formLayout.addLabelAndField(null, this.getLocalized("accessControl.customOrganizationUnit"), customOrganizationUnit);
        formLayout.addLabelAndField(null, this.getLocalized("accessControl.organizationUnitTypeFilter"), organizationUnitTypeFilterTagComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("accessControl.noInheritance"), (AbstractField)noOrgUnitInheritanceCheckBox);
        Consumer<ApplicationPrivilegeGroup> privilegeGroupHandler = privilegeGroup -> {
            if (privilegeGroup == null) {
                privilegesTagComboBox.setVisible(false);
                privilegeObjectTagComboBox.setVisible(false);
                privilegeObjectInheritanceCheckBox.setVisible(false);
                customOrganizationUnit.setVisible(false);
                organizationUnitTypeFilterTagComboBox.setVisible(false);
                noOrgUnitInheritanceCheckBox.setVisible(false);
                return;
            }
            switch (privilegeGroup.getApplicationPrivilegeGroupType()) {
                case SIMPLE_PRIVILEGE: {
                    privilegesTagComboBox.setVisible(false);
                    privilegeObjectTagComboBox.setVisible(false);
                    privilegeObjectInheritanceCheckBox.setVisible(false);
                    customOrganizationUnit.setVisible(false);
                    organizationUnitTypeFilterTagComboBox.setVisible(false);
                    noOrgUnitInheritanceCheckBox.setVisible(false);
                    break;
                }
                case SIMPLE_ORGANIZATIONAL_PRIVILEGE: {
                    privilegesTagComboBox.setVisible(false);
                    privilegeObjectTagComboBox.setVisible(false);
                    privilegeObjectInheritanceCheckBox.setVisible(false);
                    customOrganizationUnit.setVisible(true);
                    organizationUnitTypeFilterTagComboBox.setVisible(true);
                    noOrgUnitInheritanceCheckBox.setVisible(true);
                    break;
                }
                case SIMPLE_CUSTOM_OBJECT_PRIVILEGE: {
                    privilegesTagComboBox.setVisible(false);
                    privilegeObjectTagComboBox.setVisible(true);
                    privilegeObjectInheritanceCheckBox.setVisible(true);
                    customOrganizationUnit.setVisible(false);
                    organizationUnitTypeFilterTagComboBox.setVisible(false);
                    noOrgUnitInheritanceCheckBox.setVisible(false);
                    break;
                }
                case STANDARD_PRIVILEGE_GROUP: {
                    privilegesTagComboBox.setVisible(true);
                    privilegeObjectTagComboBox.setVisible(false);
                    privilegeObjectInheritanceCheckBox.setVisible(false);
                    customOrganizationUnit.setVisible(false);
                    organizationUnitTypeFilterTagComboBox.setVisible(false);
                    noOrgUnitInheritanceCheckBox.setVisible(false);
                    break;
                }
                case ORGANIZATIONAL_PRIVILEGE_GROUP: {
                    privilegesTagComboBox.setVisible(true);
                    privilegeObjectTagComboBox.setVisible(false);
                    privilegeObjectInheritanceCheckBox.setVisible(false);
                    customOrganizationUnit.setVisible(true);
                    organizationUnitTypeFilterTagComboBox.setVisible(true);
                    noOrgUnitInheritanceCheckBox.setVisible(true);
                    break;
                }
                case CUSTOM_OBJECT_PRIVILEGE_GROUP: {
                    privilegesTagComboBox.setVisible(true);
                    privilegeObjectTagComboBox.setVisible(true);
                    privilegeObjectInheritanceCheckBox.setVisible(true);
                    customOrganizationUnit.setVisible(false);
                    organizationUnitTypeFilterTagComboBox.setVisible(false);
                    noOrgUnitInheritanceCheckBox.setVisible(false);
                    break;
                }
                case ROLE_ASSIGNMENT_DELEGATED_CUSTOM_PRIVILEGE_GROUP: {
                    privilegesTagComboBox.setVisible(true);
                    privilegeObjectTagComboBox.setVisible(false);
                    privilegeObjectInheritanceCheckBox.setVisible(false);
                    customOrganizationUnit.setVisible(false);
                    organizationUnitTypeFilterTagComboBox.setVisible(false);
                    noOrgUnitInheritanceCheckBox.setVisible(false);
                }
            }
        };
        applicationComboBox.onValueChanged.addListener(() -> {
            privilegeGroupComboBox.setValue(null);
            privilegesTagComboBox.setValue(null);
            privilegeObjectTagComboBox.setValue(null);
        });
        privilegeGroupComboBox.onValueChanged.addListener(privilegeGroup -> {
            privilegesTagComboBox.setValue(null);
            privilegeObjectTagComboBox.setValue(null);
            privilegeGroupHandler.accept((ApplicationPrivilegeGroup)privilegeGroup);
        });
        masterDetailController.createViews(this.getPerspective(), (Component)table, formLayout);
        formController.addNotNull((AbstractField)roleComboBox);
        formController.addNotNull(applicationComboBox);
        formController.addNotNull(privilegeGroupComboBox);
        formController.addNotNull((AbstractField)roleComboBox);
        formController.setSaveEntityHandler(rolePrivilegeAssignment -> {
            OrganizationField organizationField = this.isOrgFieldFilterApplied() ? this.getOrganizationField() : (OrganizationField)organizationFieldFilterComboBox.getValue();
            rolePrivilegeAssignment.setRole((Role)roleComboBox.getValue()).setApplication((Application)applicationComboBox.getValue()).setPrivilegeGroup((ApplicationPrivilegeGroup)privilegeGroupComboBox.getValue()).setPrivileges((List)privilegesTagComboBox.getValue()).setPrivilegeObjects(privilegeObjectTagComboBox.getValue() != null ? ValueConverterUtils.compressStringList(((List)privilegeObjectTagComboBox.getValue()).stream().map(p -> "" + p.getId()).collect(Collectors.toList())) : null).setPrivilegeObjectInheritance((Boolean)privilegeObjectInheritanceCheckBox.getValue()).setOrganizationFieldFilter(organizationField).setFixedOrganizationRoot(OrganizationUtils.convert((OrganizationUnitView)customOrganizationUnit.getValue())).setOrganizationUnitTypeFilter((List)organizationUnitTypeFilterTagComboBox.getValue()).setNoInheritanceOfOrganizationalUnits((Boolean)noOrgUnitInheritanceCheckBox.getValue());
            return true;
        });
        entityModelBuilder.getOnSelectionEvent().addListener(rolePrivilegeAssignment -> {
            ApplicationPrivilegeGroup privilegeGroup = rolePrivilegeAssignment.getPrivilegeGroup();
            privilegeGroupHandler.accept(privilegeGroup);
            roleComboBox.setValue((Object)rolePrivilegeAssignment.getRole());
            applicationComboBox.setValue((Object)rolePrivilegeAssignment.getApplication());
            privilegeGroupComboBox.setValue((Object)privilegeGroup);
            privilegesTagComboBox.setValue(rolePrivilegeAssignment.getPrivileges());
            privilegeObjectInheritanceCheckBox.setValue((Object)rolePrivilegeAssignment.getPrivilegeObjectInheritance());
            organizationFieldFilterComboBox.setValue((Object)rolePrivilegeAssignment.getOrganizationFieldFilter());
            customOrganizationUnit.setValue((Object)OrganizationUtils.convert(rolePrivilegeAssignment.getFixedOrganizationRoot()));
            organizationUnitTypeFilterTagComboBox.setValue(rolePrivilegeAssignment.getOrganizationUnitTypeFilter());
            noOrgUnitInheritanceCheckBox.setValue((Object)rolePrivilegeAssignment.isNoInheritanceOfOrganizationalUnits());
        });
        entityModelBuilder.setSelectedRecord((Object)RolePrivilegeAssignment.create());
    }

    private ComboBox<OrganizationField> createOrganizationFieldComboBox() {
        return ComboBoxUtils.createRecordComboBox(() -> this.isAppFilter() ? Collections.singletonList(this.getOrganizationField()) : OrganizationField.getAll(), PropertyProviders.createOrganizationFieldPropertyProvider(this.getApplicationInstanceData()), (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
    }

    private TagComboBox<PrivilegeObject> createPrivilegeObjectTagComboBox(ComboBox<Application> applicationComboBox, ComboBox<ApplicationPrivilegeGroup> privilegeGroupComboBox) {
        TagComboBox tagComboBox = new TagComboBox((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        PropertyProvider<PrivilegeObject> propertyProvider = PropertyProviders.createPrivilegeObjectPropertyProvider();
        Function recordToStringFunction = UiUtils.createRecordToStringFunction(propertyProvider);
        ApplicationPrivilegeGroup privilegeGroup = (ApplicationPrivilegeGroup)privilegeGroupComboBox.getValue();
        Application application = (Application)applicationComboBox.getValue();
        LoadedApplication loadedApplication = this.userSessionData.getRegistry().getLoadedApplication(application);
        ComboBoxModel comboBoxModel = ComboBoxUtils.createComboBoxModel(() -> this.getPrivilegeObjects(privilegeGroup, loadedApplication), propertyProvider, (int)50, (String[])new String[0]);
        tagComboBox.setModel(comboBoxModel);
        tagComboBox.setPropertyProvider(propertyProvider);
        tagComboBox.setRecordToStringFunction(recordToStringFunction);
        tagComboBox.setDistinct(true);
        tagComboBox.setWrappingMode(TagBoxWrappingMode.SINGLE_TAG_PER_LINE);
        return tagComboBox;
    }

    private List<PrivilegeObject> getPrivilegeObjects(ApplicationPrivilegeGroup privilegeGroup, LoadedApplication loadedApplication) {
        if (privilegeGroup == null || loadedApplication == null) {
            return Collections.emptyList();
        }
        PrivilegeGroup group = loadedApplication.getBaseApplicationBuilder().getPrivilegeGroups().stream().filter(g -> g.getName().equals(privilegeGroup.getName())).findAny().orElse(null);
        if (group != null) {
            return (List)group.getPrivilegeObjectsSupplier().get();
        }
        return Collections.emptyList();
    }

    private TagComboBox<ApplicationPrivilege> createPrivilegeTagComboBox(ComboBox<ApplicationPrivilegeGroup> privilegeGroupComboBox) {
        TagComboBox tagComboBox = new TagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        PropertyProvider<ApplicationPrivilege> propertyProvider = PropertyProviders.createApplicationPrivilegePropertyProvider(this.userSessionData);
        Function recordToString = UiUtils.createRecordToStringFunction(propertyProvider);
        ComboBoxModel comboBoxModel = ComboBoxUtils.createComboBoxModel(() -> privilegeGroupComboBox.getValue() != null ? ((ApplicationPrivilegeGroup)privilegeGroupComboBox.getValue()).getPrivileges() : null, propertyProvider, (int)50, (String[])new String[0]);
        tagComboBox.setModel(comboBoxModel);
        tagComboBox.setPropertyProvider(propertyProvider);
        tagComboBox.setRecordToStringFunction(recordToString);
        tagComboBox.setDistinct(true);
        tagComboBox.setWrappingMode(TagBoxWrappingMode.SINGLE_TAG_PER_LINE);
        tagComboBox.setShowClearButton(true);
        return tagComboBox;
    }

    private ComboBox<ApplicationPrivilegeGroup> createPrivilegeGroupComboBox(ComboBox<Application> applicationComboBox) {
        ComboBox comboBox = new ComboBox((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        PropertyProvider<ApplicationPrivilegeGroup> propertyProvider = PropertyProviders.createApplicationPrivilegeGroupPropertyProvider(this.userSessionData);
        Function recordToString = UiUtils.createRecordToStringFunction(propertyProvider);
        ComboBoxModel comboBoxModel = ComboBoxUtils.createComboBoxModel(() -> applicationComboBox.getValue() != null ? ((Application)applicationComboBox.getValue()).getPrivilegeGroups() : Collections.emptyList(), propertyProvider, (int)50, (String[])new String[0]);
        comboBox.setModel(comboBoxModel);
        comboBox.setPropertyProvider(propertyProvider);
        comboBox.setRecordToStringFunction(recordToString);
        return comboBox;
    }

    private ComboBox<Application> createApplicationComboBox() {
        ComboBox comboBox = new ComboBox((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        PropertyProvider<Application> propertyProvider = PropertyProviders.createApplicationPropertyProvider(this.userSessionData);
        Function recordToString = UiUtils.createRecordToStringFunction(propertyProvider);
        ComboBoxModel model = ComboBoxUtils.createComboBoxModel(this::getAvailableApplications, propertyProvider, (int)50, (String[])new String[0]);
        comboBox.setModel(model);
        comboBox.setPropertyProvider(propertyProvider);
        comboBox.setRecordToStringFunction(recordToString);
        return comboBox;
    }

    private List<Application> getAvailableApplications() {
        if (this.isAppFilter()) {
            return this.getManagedApplication().getPerspectives().stream().map(p -> p.getApplicationPerspective().getApplication()).distinct().collect(Collectors.toList());
        }
        return Application.getAll();
    }
}

