/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.bootstrap;

import org.teamapps.application.server.system.server.SecureLinkBuilder;
import org.teamapps.application.server.system.server.SecureResourceHandler;
import org.teamapps.model.controlcenter.User;

public class BaseResourceLinkProvider {
    private final SecureResourceHandler secureResourceHandler = SecureResourceHandler.getInstance();
    private final SecureLinkBuilder userStandardProfilePictureLinkBuilder = this.secureResourceHandler.registerByteArrayResourceHandler(id -> User.getById(id).getProfilePicture(), id -> User.getById(id).getLastLoginAsEpochMilli(), "jpg");
    private final SecureLinkBuilder userLargeProfilePictureLinkBuilder = this.secureResourceHandler.registerByteArrayResourceHandler(id -> User.getById(id).getProfilePictureLarge(), id -> User.getById(id).getLastLoginAsEpochMilli(), "jpg");

    public String getUserProfilePictureLink(int userId, boolean large) {
        String link;
        if (large && (link = this.userLargeProfilePictureLinkBuilder.createLink(userId)) != null) {
            return link;
        }
        return this.userStandardProfilePictureLinkBuilder.createLink(userId);
    }

    public String getUserProfilePictureLink(User user) {
        return this.userStandardProfilePictureLinkBuilder.createLink(user.getId());
    }

    public String getUserLargeProfilePictureLink(User user) {
        return this.userLargeProfilePictureLinkBuilder.createLink(user.getId());
    }
}

