/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.launcher;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.launcher.MobileNavigation;
import org.teamapps.common.format.Color;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.Icon;
import org.teamapps.ux.application.ResponsiveApplication;
import org.teamapps.ux.application.ResponsiveApplicationToolbar;
import org.teamapps.ux.application.assembler.ApplicationAssembler;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.application.view.ViewSize;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.animation.PageTransition;
import org.teamapps.ux.component.calendar.Calendar;
import org.teamapps.ux.component.charting.forcelayout.ForceLayoutGraph;
import org.teamapps.ux.component.flexcontainer.VerticalLayout;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.infiniteitemview.InfiniteItemView2;
import org.teamapps.ux.component.itemview.ItemView;
import org.teamapps.ux.component.itemview.SimpleItem;
import org.teamapps.ux.component.itemview.SimpleItemGroup;
import org.teamapps.ux.component.itemview.SimpleItemView;
import org.teamapps.ux.component.map.MapView;
import org.teamapps.ux.component.mobile.MobileLayout;
import org.teamapps.ux.component.panel.Panel;
import org.teamapps.ux.component.progress.MultiProgressDisplay;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.timegraph.TimeGraph;
import org.teamapps.ux.component.toolbar.AbstractToolContainer;
import org.teamapps.ux.component.toolbar.Toolbar;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.tree.Tree;
import org.teamapps.ux.component.workspacelayout.definition.LayoutItemDefinition;

public class MobileAssembler
implements ApplicationAssembler {
    private static final int PAGE_TRANSITION_ANIMATION_DURATION = 300;
    private final ApplicationLocalizationProvider localizationProvider;
    private final MobileNavigation mobileNavigation;
    private VerticalLayout verticalLayout;
    private Toolbar navigationToolbar;
    private final MobileLayout mobileLayout;
    private AbstractToolContainer mainToolbar;
    private SimpleItemView<Void> viewsItemView;
    private final List<View> applicationViews = new ArrayList<View>();
    private List<View> perspectiveViews = new ArrayList<View>();
    private final ToolbarButtonGroup centerGroup;
    private final ToolbarButtonGroup leftGroup;
    private final ToolbarButtonGroup rightGroup;
    private final ToolbarButton navigationToolbarMenuButton;
    private View activeView;

    public MobileAssembler(MobileNavigation mobileNavigation, ApplicationLocalizationProvider localizationProvider) {
        this.localizationProvider = localizationProvider;
        this.mobileNavigation = mobileNavigation;
        this.verticalLayout = new VerticalLayout();
        this.mobileLayout = new MobileLayout();
        this.viewsItemView = new SimpleItemView();
        this.navigationToolbar = new Toolbar();
        this.verticalLayout.addComponentAutoSize((Component)this.navigationToolbar);
        this.verticalLayout.addComponentFillRemaining((Component)this.mobileLayout);
        this.navigationToolbar.setBackgroundColor((Color)Color.WHITE.withAlpha(0.6f));
        this.leftGroup = this.navigationToolbar.addButtonGroup(new ToolbarButtonGroup());
        ToolbarButton backButton = new ToolbarButton((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, (Object)new BaseTemplateRecord((Icon)MaterialIcon.NAVIGATE_BEFORE, this.getLocalized("org.teamapps.dictionary.back")));
        this.leftGroup.addButton(backButton);
        this.leftGroup.setShowGroupSeparator(false);
        backButton.onClick.addListener(() -> {
            if (this.activeView != null && this.activeView.equals(mobileNavigation.getApplicationMenuView()) && mobileNavigation.isBackOperationAvailable()) {
                mobileNavigation.fireBackOperation();
            } else {
                this.goBack();
            }
        });
        mobileNavigation.onShowStartViewRequest().addListener(() -> {
            this.setNavigationToolbarVisible(true);
            if (!this.perspectiveViews.isEmpty()) {
                this.showView(this.perspectiveViews.get(0));
            } else {
                this.showView(mobileNavigation.getApplicationMenuView());
            }
        });
        mobileNavigation.onShowViewRequest().addListener(view -> {
            this.setNavigationToolbarVisible(true);
            this.showView((View)view);
        });
        this.centerGroup = this.navigationToolbar.addButtonGroup(new ToolbarButtonGroup());
        this.centerGroup.addButton(new ToolbarButton((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, (Object)new BaseTemplateRecord("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;")));
        this.centerGroup.setShowGroupSeparator(false);
        ToolbarButton viewsButton = new ToolbarButton((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, (Object)new BaseTemplateRecord((Icon)MaterialIcon.TAB, this.getLocalized("org.teamapps.dictionary.views")));
        viewsButton.setDropDownComponent(this.viewsItemView);
        viewsButton.onClick.addListener(this::updateViewsDropdown);
        viewsButton.setDroDownPanelWidth(450);
        this.centerGroup.addButton(viewsButton);
        this.rightGroup = this.navigationToolbar.addButtonGroup(new ToolbarButtonGroup());
        this.rightGroup.setRightSide(true);
        this.rightGroup.setShowGroupSeparator(false);
        this.navigationToolbarMenuButton = new ToolbarButton((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, (Object)new BaseTemplateRecord((Icon)MaterialIcon.MENU, this.getLocalized("org.teamapps.dictionary.menu")));
        this.rightGroup.addButton(this.navigationToolbarMenuButton);
        this.setNavigationToolbarVisible(false);
    }

    private String getLocalized(String key) {
        return this.localizationProvider.getLocalized(key, new Object[0]);
    }

    private void setNavigationToolbarVisible(boolean visible) {
        this.navigationToolbar.setVisible(visible);
        this.leftGroup.setVisible(visible);
        this.centerGroup.setVisible(visible);
        this.rightGroup.setVisible(visible);
    }

    public void goBack() {
        int i;
        View view = null;
        for (i = 0; i < this.perspectiveViews.size(); ++i) {
            if (!this.perspectiveViews.get(i).equals(this.activeView)) continue;
            if (i > 0) {
                view = this.perspectiveViews.get(i - 1);
                break;
            }
            if (this.applicationViews.isEmpty()) break;
            view = this.applicationViews.get(this.applicationViews.size() - 1);
            break;
        }
        if (view == null) {
            for (i = 0; i < this.applicationViews.size(); ++i) {
                if (!this.applicationViews.get(i).equals(this.activeView)) continue;
                if (i <= 0) break;
                view = this.applicationViews.get(i - 1);
                break;
            }
        }
        this.activeView = view;
        if (this.activeView == null) {
            this.setNavigationToolbarVisible(false);
            this.mobileLayout.setContent(this.mobileNavigation.getApplicationLauncher(), PageTransition.MOVE_TO_RIGHT_VS_MOVE_FROM_LEFT, 300);
        } else {
            this.setNavigationToolbarVisible(true);
            this.mobileLayout.setContent((Component)this.activeView.getPanel(), PageTransition.MOVE_TO_RIGHT_VS_MOVE_FROM_LEFT, 300);
        }
    }

    public void showView(View view) {
        if (view == null) {
            this.activeView = view;
            this.setNavigationToolbarVisible(false);
            this.mobileLayout.setContent(this.mobileNavigation.getApplicationLauncher(), PageTransition.MOVE_TO_RIGHT_VS_MOVE_FROM_LEFT, 300);
            return;
        }
        if (view.equals(this.activeView)) {
            return;
        }
        ArrayList<View> views = new ArrayList<View>(this.applicationViews);
        views.addAll(this.perspectiveViews);
        int lastPos = -1;
        int newPos = 0;
        for (int i = 0; i < views.size(); ++i) {
            if (this.activeView != null && this.activeView.equals(views.get(i))) {
                lastPos = i;
            }
            if (!view.equals(views.get(i))) continue;
            newPos = i;
        }
        if (newPos > lastPos) {
            this.mobileLayout.setContent((Component)view.getPanel(), PageTransition.MOVE_TO_LEFT_VS_MOVE_FROM_RIGHT, 300);
        } else {
            this.mobileLayout.setContent((Component)view.getPanel(), PageTransition.MOVE_TO_RIGHT_VS_MOVE_FROM_LEFT, 300);
        }
        this.activeView = view;
    }

    public void showInitialView() {
        View view = null;
        if (!this.applicationViews.isEmpty()) {
            view = this.applicationViews.get(0);
        } else if (!this.perspectiveViews.isEmpty()) {
            view = this.perspectiveViews.get(0);
        }
        if (view != null) {
            this.mobileLayout.setContent((Component)view.getPanel(), PageTransition.MOVE_TO_LEFT_VS_MOVE_FROM_RIGHT, 300);
            this.activeView = view;
        }
    }

    public void setWorkSpaceToolbar(ResponsiveApplicationToolbar toolbar) {
        this.mainToolbar = toolbar.getToolbar();
        this.navigationToolbarMenuButton.setDropDownComponent((Component)this.mainToolbar);
        this.mainToolbar.onButtonClick.addListener(() -> {});
    }

    public Component createApplication(ResponsiveApplication application) {
        return this.verticalLayout;
    }

    public MultiProgressDisplay getMultiProgressDisplay() {
        return null;
    }

    public void handleApplicationViewAdded(ResponsiveApplication application, View view) {
        this.applicationViews.add(view);
    }

    public void handleApplicationViewRemoved(ResponsiveApplication application, View view) {
        this.applicationViews.remove(view);
    }

    private void updateViewsDropdown() {
        this.viewsItemView.removeAllGroups();
        SimpleItemGroup appGroup = this.viewsItemView.addSingleColumnGroup(ApplicationIcons.WINDOWS, this.getLocalized("org.teamapps.dictionary.applications"));
        appGroup.setItemTemplate((Template)BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES);
        appGroup.addItem((Icon)ApplicationIcons.WINDOW_EXPLORER, (String)this.getLocalized((String)"org.teamapps.dictionary.applicationLauncher"), (String)this.getLocalized((String)"org.teamapps.dictionary.openNewApplication")).onClick.addListener(() -> this.showView(null));
        this.applicationViews.forEach(view -> appGroup.addItem(this.createViewButton((View)view)));
        SimpleItemGroup viewGroup = this.viewsItemView.addSingleColumnGroup(ApplicationIcons.WINDOWS, this.getLocalized("org.teamapps.dictionary.applications"));
        viewGroup.setItemTemplate((Template)BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES);
        this.perspectiveViews.forEach(view -> viewGroup.addItem(this.createViewButton((View)view)));
    }

    public void handlePerspectiveChange(ResponsiveApplication application, Perspective perspective, Perspective previousPerspective, List<View> activeViews, List<View> addedViews, List<View> removedViews) {
        addedViews.forEach(view -> this.mobileLayout.preloadView((Component)view.getPanel()));
        this.perspectiveViews = activeViews;
        if (!this.perspectiveViews.isEmpty()) {
            View view2;
            this.activeView = view2 = perspective.getFocusedView() != null ? perspective.getFocusedView() : this.perspectiveViews.get(0);
            this.mobileLayout.setContent((Component)view2.getPanel(), PageTransition.MOVE_TO_LEFT_VS_MOVE_FROM_RIGHT, 300);
            this.setNavigationToolbarVisible(true);
        }
    }

    private SimpleItem<Void> createViewButton(View view) {
        SimpleItem item = view.equals(this.mobileNavigation.getApplicationMenuView()) ? new SimpleItem(ApplicationIcons.WINDOW_SIDEBAR, this.getLocalized("org.teamapps.dictionary.applicationMenu"), this.getLocalized("org.teamapps.dictionary.selectApplicationPerspective")) : this.getViewTypeItem(view.getPanel());
        item.onClick.addListener(() -> this.showView(view));
        return item;
    }

    private SimpleItem<Void> getViewTypeItem(Panel panel) {
        String title = panel.getTitle();
        Icon icon = panel.getIcon();
        Component content = panel.getContent();
        if (content == null) {
            return new SimpleItem(panel.getIcon(), panel.getTitle(), null);
        }
        if (content instanceof Table) {
            return new SimpleItem(icon != null ? icon : ApplicationIcons.SPREADSHEET, title, this.getLocalized("org.teamapps.dictionary.table"));
        }
        if (content instanceof ItemView || content instanceof InfiniteItemView2) {
            return new SimpleItem(icon != null ? icon : ApplicationIcons.LIST_STYLE_BULLETS, title, this.getLocalized("org.teamapps.dictionary.list"));
        }
        if (content instanceof ResponsiveForm) {
            return new SimpleItem(icon != null ? icon : ApplicationIcons.FORM, title, this.getLocalized("org.teamapps.dictionary.form"));
        }
        if (content instanceof Calendar) {
            return new SimpleItem(icon != null ? icon : ApplicationIcons.CALENDAR, title, this.getLocalized("org.teamapps.dictionary.calendar"));
        }
        if (content instanceof TimeGraph) {
            return new SimpleItem(icon != null ? icon : ApplicationIcons.CHART_LINE, title, this.getLocalized("org.teamapps.dictionary.timeline"));
        }
        if (content instanceof Tree) {
            return new SimpleItem(icon != null ? icon : ApplicationIcons.TEXT_TREE, title, this.getLocalized("org.teamapps.dictionary.tree"));
        }
        if (content instanceof MapView) {
            return new SimpleItem(icon != null ? icon : ApplicationIcons.MAP, title, this.getLocalized("org.teamapps.dictionary.map"));
        }
        if (content instanceof ForceLayoutGraph) {
            return new SimpleItem(icon != null ? icon : ApplicationIcons.GRAPH_CONNECTION_DIRECTED, title, this.getLocalized("org.teamapps.dictionary.network"));
        }
        return new SimpleItem(panel.getIcon(), panel.getTitle(), null);
    }

    public void handleLayoutChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, LayoutItemDefinition layout) {
    }

    public void handleViewAdded(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view) {
        if (isActivePerspective) {
            this.mobileLayout.preloadView((Component)view.getPanel());
            this.perspectiveViews.add(view);
        }
    }

    public void handleViewRemoved(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view) {
        if (isActivePerspective) {
            this.perspectiveViews.remove(view);
        }
    }

    public void handleViewVisibilityChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, boolean visible) {
        if (isActivePerspective) {
            // empty if block
        }
    }

    public void handleViewFocusRequest(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, boolean ensureVisible) {
        if (isActivePerspective) {
            this.showView(view);
        }
    }

    public void handleViewSizeChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, ViewSize viewSize) {
    }

    public void handleViewTabTitleChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, String title) {
    }

    public void handleViewLayoutPositionChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, String position) {
    }

    public void handleApplicationToolbarButtonGroupAdded(ResponsiveApplication application, ToolbarButtonGroup buttonGroup) {
    }
}

