/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.localization;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.application.api.localization.Language;
import org.teamapps.application.api.localization.LocalizationData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.config.LocalizationConfig;
import org.teamapps.application.server.system.machinetranslation.TranslationService;
import org.teamapps.application.tools.ChangeCounter;
import org.teamapps.application.tools.KeyCompare;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.LocalizationKey;
import org.teamapps.model.controlcenter.LocalizationKeyFormat;
import org.teamapps.model.controlcenter.LocalizationKeyType;
import org.teamapps.model.controlcenter.LocalizationTopic;
import org.teamapps.model.controlcenter.LocalizationValue;
import org.teamapps.model.controlcenter.MachineTranslationState;
import org.teamapps.model.controlcenter.TranslationState;
import org.teamapps.model.controlcenter.TranslationVerificationState;
import org.teamapps.universaldb.index.enumeration.EnumFilterType;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.text.TextFilter;

public class LocalizationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void synchronizeLocalizationData(LocalizationData localizationData, Application application, LocalizationKeyType localizationKeyType, LocalizationConfig localizationConfig) {
        Map localizationMapByKey = localizationData.createLocalizationMapByKey();
        Set machineTranslatedLanguages = localizationData.getMachineTranslatedLanguages();
        int appIdFilter = 0;
        if (application != null) {
            appIdFilter = application.getId();
        }
        List localizationKeys = LocalizationKey.filter().application(NumericFilter.equalsFilter((Number)appIdFilter)).execute();
        KeyCompare keyCompare = new KeyCompare(localizationMapByKey.keySet(), (Collection)localizationKeys, s -> s, LocalizationKey::getKey);
        List newKeys = keyCompare.getAEntriesNotInB();
        LocalizationTopic topic = LocalizationUtil.getTopic(localizationKeyType, application);
        for (String key2 : newKeys) {
            LocalizationKey localizationKey = (LocalizationKey)LocalizationKey.create().setApplication(application).setLocalizationKeyType(localizationKeyType).setTopics(topic).setUsed(true).setKey(key2).save();
            Map translations = (Map)localizationMapByKey.get(key2);
            for (Map.Entry entry : translations.entrySet()) {
                String language2 = (String)entry.getKey();
                String value2 = (String)entry.getValue();
                if (machineTranslatedLanguages.contains(language2)) {
                    LocalizationValue.create().setLocalizationKey(localizationKey).setLanguage(language2).setMachineTranslation(value2).setCurrentDisplayValue(value2).setMachineTranslationState(MachineTranslationState.OK).setTranslationState(TranslationState.TRANSLATION_REQUESTED).setTranslationVerificationState(TranslationVerificationState.NOT_YET_TRANSLATED).save();
                    continue;
                }
                LocalizationValue.create().setLocalizationKey(localizationKey).setLanguage(language2).setOriginal(value2).setCurrentDisplayValue(value2).setMachineTranslationState(MachineTranslationState.NOT_NECESSARY).setTranslationState(TranslationState.NOT_NECESSARY).setTranslationVerificationState(TranslationVerificationState.NOT_NECESSARY).save();
            }
        }
        List removedKeys = keyCompare.getBEntriesNotInA();
        removedKeys.forEach(key -> key.setUsed(false).save());
        List existingKeys = keyCompare.getAEntriesInB();
        for (String key3 : existingKeys) {
            KeyCompare languageCompare;
            Map translations = (Map)localizationMapByKey.get(key3);
            LocalizationKey localizationKey = (LocalizationKey)keyCompare.getB((Object)key3);
            if (!localizationKey.isUsed()) {
                localizationKey.setUsed(true).save();
            }
            if ((languageCompare = new KeyCompare(translations.keySet(), localizationKey.getLocalizationValues(), s -> s, LocalizationValue::getLanguage)).isDifferent()) {
                List newLanguages = languageCompare.getAEntriesNotInB();
                newLanguages.forEach(language -> {
                    String value = (String)translations.get(language);
                    if (machineTranslatedLanguages.contains(language)) {
                        LocalizationValue.create().setLocalizationKey(localizationKey).setLanguage((String)language).setMachineTranslation(value).setCurrentDisplayValue(value).setMachineTranslationState(MachineTranslationState.OK).setTranslationState(TranslationState.TRANSLATION_REQUESTED).setTranslationVerificationState(TranslationVerificationState.NOT_YET_TRANSLATED).save();
                    } else {
                        LocalizationValue.create().setLocalizationKey(localizationKey).setLanguage((String)language).setOriginal(value).setCurrentDisplayValue(value).setMachineTranslationState(MachineTranslationState.NOT_NECESSARY).setTranslationState(TranslationState.NOT_NECESSARY).setTranslationVerificationState(TranslationVerificationState.NOT_NECESSARY).save();
                    }
                });
            }
            for (LocalizationValue localizationValue : languageCompare.getBEntriesInA()) {
                String language3 = localizationValue.getLanguage();
                if (machineTranslatedLanguages.contains(language3)) {
                    String applicationTranslation = (String)translations.get(language3);
                    String machineTranslation = localizationValue.getMachineTranslation();
                    if (applicationTranslation == null || applicationTranslation.isBlank() || machineTranslation == null || applicationTranslation.equals(machineTranslation)) continue;
                    localizationValue.setMachineTranslation(applicationTranslation).setMachineTranslationState(MachineTranslationState.OK);
                    if (localizationValue.getTranslation() == null) {
                        localizationValue.setCurrentDisplayValue(applicationTranslation);
                    }
                    localizationValue.save();
                    LOGGER.info("Update machine translation, key: {}, old: {}, new: {}", new Object[]{localizationValue.getLocalizationKey().getKey(), machineTranslation, applicationTranslation});
                    continue;
                }
                String original = (String)translations.get(language3);
                if (original == null || original.isBlank() || localizationValue.getOriginal() == null || original.equals(localizationValue.getOriginal())) continue;
                LOGGER.info("Update original localization, key: {}, old: {}, new: {}", new Object[]{localizationValue.getLocalizationKey().getKey(), localizationValue.getOriginal(), original});
                localizationValue.setOriginal(original).setCurrentDisplayValue(original).save();
                localizationValue.getLocalizationKey().getLocalizationValues().stream().filter(value -> !value.equals(localizationValue)).filter(value -> value.getOriginal() == null).filter(value -> value.getAdminLocalOverride() == null).filter(value -> value.getAdminKeyOverride() == null).forEach(value -> value.setMachineTranslationState(MachineTranslationState.TRANSLATION_REQUESTED).setTranslationState(TranslationState.TRANSLATION_REQUESTED).setTranslationVerificationState(TranslationVerificationState.NOT_YET_TRANSLATED).save());
            }
        }
        LocalizationUtil.createRequiredLanguageValues(localizationKeys, localizationConfig);
    }

    public static int createRequiredLanguageValues(List<LocalizationKey> localizationKeys, LocalizationConfig localizationConfig) {
        List<String> requiredLanguages = localizationConfig.getRequiredLanguages();
        int countNewEntries = 0;
        for (LocalizationKey key : localizationKeys) {
            Map<String, LocalizationValue> valueByLanguage = key.getLocalizationValues().stream().collect(Collectors.toMap(LocalizationValue::getLanguage, v -> v));
            for (String language : requiredLanguages) {
                if (valueByLanguage.containsKey(language)) continue;
                LocalizationValue.create().setLocalizationKey(key).setLanguage(language).setMachineTranslationState(MachineTranslationState.TRANSLATION_REQUESTED).setTranslationState(TranslationState.TRANSLATION_REQUESTED).setTranslationVerificationState(TranslationVerificationState.NOT_YET_TRANSLATED).save();
                ++countNewEntries;
            }
        }
        return countNewEntries;
    }

    public static void translateAllApplicationValues(TranslationService translationService, Application application, LocalizationConfig localizationConfig) {
        if (translationService == null || localizationConfig == null) {
            return;
        }
        HashSet<String> allowedSourceTranslationLanguages = new HashSet<String>(localizationConfig.getAllowedSourceLanguages());
        List<LocalizationValue> translationRequests = LocalizationValue.filter().machineTranslationState(EnumFilterType.EQUALS, MachineTranslationState.TRANSLATION_REQUESTED).original(TextFilter.emptyFilter()).machineTranslation(TextFilter.emptyFilter()).execute().stream().filter(value -> value.getLocalizationKey().getApplication() != null && value.getLocalizationKey().getApplication().equals(application)).collect(Collectors.toList());
        LOGGER.info("Application translation requests:" + translationRequests.size() + ", app:" + application.getName());
        ExecutorService executor = Executors.newFixedThreadPool(10);
        translationRequests.forEach(localizationValue -> executor.submit(() -> LocalizationUtil.translateLocalizationValue(localizationValue, translationService, allowedSourceTranslationLanguages)));
        executor.shutdown();
    }

    public static void translateAllDictionaryValues(TranslationService translationService, LocalizationConfig localizationConfig) {
        if (translationService == null || localizationConfig == null) {
            return;
        }
        HashSet<String> allowedSourceTranslationLanguages = new HashSet<String>(localizationConfig.getAllowedSourceLanguages());
        List<LocalizationValue> translationRequests = LocalizationValue.filter().machineTranslationState(EnumFilterType.EQUALS, MachineTranslationState.TRANSLATION_REQUESTED).original(TextFilter.emptyFilter()).machineTranslation(TextFilter.emptyFilter()).execute().stream().filter(value -> value.getLocalizationKey().getLocalizationKeyType() == LocalizationKeyType.DICTIONARY_KEY).collect(Collectors.toList());
        ExecutorService executor = Executors.newFixedThreadPool(10);
        translationRequests.forEach(localizationValue -> executor.submit(() -> LocalizationUtil.translateLocalizationValue(localizationValue, translationService, allowedSourceTranslationLanguages)));
        executor.shutdown();
    }

    public static int translateAllValues(TranslationService translationService, LocalizationConfig localizationConfig) {
        if (translationService == null || localizationConfig == null) {
            return -1;
        }
        HashSet<String> allowedSourceTranslationLanguages = new HashSet<String>(localizationConfig.getAllowedSourceLanguages());
        List translationRequests = LocalizationValue.filter().machineTranslationState(EnumFilterType.EQUALS, MachineTranslationState.TRANSLATION_REQUESTED).original(TextFilter.emptyFilter()).machineTranslation(TextFilter.emptyFilter()).execute();
        ExecutorService executor = Executors.newFixedThreadPool(10);
        translationRequests.forEach(localizationValue -> executor.submit(() -> LocalizationUtil.translateLocalizationValue(localizationValue, translationService, allowedSourceTranslationLanguages)));
        executor.shutdown();
        return translationRequests.size();
    }

    public static void translateLocalizationValue(LocalizationValue missingTranslationValue, TranslationService translationService, Set<String> allowedSourceTranslationLanguages) {
        LocalizationValue adminValue = missingTranslationValue.getLocalizationKey().getLocalizationValues().stream().filter(value -> value.getAdminKeyOverride() != null).filter(value -> allowedSourceTranslationLanguages.contains(value.getLanguage())).findFirst().orElse(null);
        if (adminValue != null && translationService.canTranslate(adminValue.getLanguage(), missingTranslationValue.getLanguage())) {
            String translation = translationService.translate(adminValue.getAdminKeyOverride(), adminValue.getLanguage(), missingTranslationValue.getLanguage());
            if (translation != null) {
                translation = LocalizationUtil.firstUpperIfSourceUpper(adminValue.getAdminKeyOverride(), translation);
                LOGGER.info("Translate admin key (" + adminValue.getLanguage() + "->" + missingTranslationValue.getLanguage() + "): " + adminValue.getAdminKeyOverride() + " -> " + translation);
                missingTranslationValue.setMachineTranslation(translation).setMachineTranslationState(MachineTranslationState.OK).setCurrentDisplayValue(LocalizationUtil.getDisplayValue(missingTranslationValue)).save();
            } else {
                LOGGER.warn("Missing translation admin key result (" + adminValue.getLanguage() + "->" + missingTranslationValue.getLanguage() + "): " + adminValue.getAdminKeyOverride() + " -> " + translation);
            }
            return;
        }
        Map<String, LocalizationValue> localizationValueByLanguage = missingTranslationValue.getLocalizationKey().getLocalizationValues().stream().filter(value -> !value.equals(missingTranslationValue)).filter(value -> value.getOriginal() != null).collect(Collectors.toMap(LocalizationValue::getLanguage, v -> v));
        for (String language : allowedSourceTranslationLanguages) {
            String translationSourceText;
            LocalizationValue sourceValue = localizationValueByLanguage.get(language);
            if (sourceValue == null || !translationService.canTranslate(language, missingTranslationValue.getLanguage()) || (translationSourceText = LocalizationUtil.getTranslationSourceText(sourceValue)) == null || translationSourceText.isBlank()) continue;
            String translation = translationService.translate(translationSourceText, language, missingTranslationValue.getLanguage());
            if (translation != null) {
                translation = LocalizationUtil.firstUpperIfSourceUpper(translationSourceText, translation);
                LOGGER.info("Translate (" + language + "->" + missingTranslationValue.getLanguage() + "): " + translationSourceText + " -> " + translation);
                missingTranslationValue.setMachineTranslation(translation).setMachineTranslationState(MachineTranslationState.OK).setCurrentDisplayValue(LocalizationUtil.getDisplayValue(missingTranslationValue)).save();
                break;
            }
            LOGGER.warn("Missing translation result (" + language + "->" + missingTranslationValue.getLanguage() + "): " + translationSourceText + " -> " + translation);
            break;
        }
    }

    private static String getTranslationSourceText(LocalizationValue localizationValue) {
        String value = localizationValue.getAdminKeyOverride();
        if (value == null) {
            value = localizationValue.getAdminLocalOverride();
        }
        if (value == null) {
            value = localizationValue.getOriginal();
        }
        return value;
    }

    private static String getDisplayValue(LocalizationValue localizationValue) {
        String value = localizationValue.getAdminKeyOverride();
        if (value == null) {
            value = localizationValue.getAdminLocalOverride();
        }
        if (value == null) {
            value = localizationValue.getOriginal();
        }
        if (value == null) {
            value = localizationValue.getTranslation();
        }
        if (value == null) {
            value = localizationValue.getMachineTranslation();
        }
        return value;
    }

    private static String firstUpperIfSourceUpper(String source, String text) {
        if (source == null || text == null || source.isEmpty() || text.isEmpty()) {
            return text;
        }
        char c = source.substring(0, 1).charAt(0);
        if (Character.isUpperCase(c)) {
            return text.substring(0, 1).toUpperCase() + text.substring(1);
        }
        return text;
    }

    private static LocalizationTopic getTopic(LocalizationKeyType keyType, Application application) {
        return switch (keyType) {
            case LocalizationKeyType.APPLICATION_RESOURCE_KEY -> LocalizationUtil.getOrCreateTopic(application.getName(), application.getIcon(), application);
            case LocalizationKeyType.DICTIONARY_KEY -> LocalizationUtil.getOrCreateTopic("Dictionary", IconUtils.encodeNoStyle((Icon)ApplicationIcons.DICTIONARY), application);
            case LocalizationKeyType.SYSTEM_KEY -> LocalizationUtil.getOrCreateTopic("System", IconUtils.encodeNoStyle((Icon)ApplicationIcons.SYSTEM), application);
            case LocalizationKeyType.REPORTING_KEY -> LocalizationUtil.getOrCreateTopic("Reporting", IconUtils.encodeNoStyle((Icon)ApplicationIcons.FORM), application);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private static LocalizationTopic getOrCreateTopic(String name, String icon, Application application) {
        LocalizationTopic topic = (LocalizationTopic)LocalizationTopic.filter().title(TextFilter.textEqualsFilter((String)name)).executeExpectSingleton();
        if (topic == null) {
            topic = (LocalizationTopic)LocalizationTopic.create().setTitle(name).setApplication(application).setIcon(icon).save();
        }
        return topic;
    }

    public static File createTranslationResourceFiles() throws IOException {
        Map<String, List<LocalizationValue>> valuesByDomain = LocalizationValue.getAll().stream().filter(value -> value.getLocalizationKey().getKey() != null).filter(value -> value.getCurrentDisplayValue() != null).collect(Collectors.groupingBy(value -> {
            if (value.getLocalizationKey().getApplication() != null) {
                return value.getLocalizationKey().getApplication().getName();
            }
            return value.getLocalizationKey().getLocalizationKeyType().name();
        }));
        File zipFile = File.createTempFile("temp", ".zip");
        FileOutputStream fos = new FileOutputStream(zipFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        for (Map.Entry<String, List<LocalizationValue>> domainEntry : valuesByDomain.entrySet()) {
            String applicationOrType = domainEntry.getKey();
            zos.putNextEntry(new ZipEntry(applicationOrType + "/"));
            zos.closeEntry();
            Map<String, List<LocalizationValue>> valueMap = domainEntry.getValue().stream().collect(Collectors.groupingBy(LocalizationValue::getLanguage));
            for (Map.Entry<String, List<LocalizationValue>> entry : valueMap.entrySet()) {
                String language = entry.getKey();
                String fileName = applicationOrType;
                if (applicationOrType.equals("DICTIONARY_KEY")) {
                    fileName = "dictionary";
                }
                zos.putNextEntry(new ZipEntry(applicationOrType + "/" + fileName + "_" + language + ".properties"));
                List values = entry.getValue().stream().sorted(Comparator.comparing(o -> o.getLocalizationKey().getKey())).collect(Collectors.toList());
                StringBuilder sb = new StringBuilder();
                for (LocalizationValue value2 : values) {
                    sb.append(value2.getLocalizationKey().getKey()).append("=").append(value2.getCurrentDisplayValue() != null ? value2.getCurrentDisplayValue().replace("\r", "").replace("\n", "\\n") : null).append("\n");
                }
                zos.write(sb.toString().getBytes(StandardCharsets.UTF_8));
            }
        }
        zos.close();
        fos.close();
        return zipFile;
    }

    public static File createTranslationExport(Application application) throws IOException {
        Stream<LocalizationKey> keyStream = LocalizationKey.getAll().stream().filter(key -> key.getKey() != null);
        if (application != null) {
            keyStream = keyStream.filter(key -> key.getApplication() != null).filter(key -> key.getApplication().equals(application));
        }
        keyStream = keyStream.sorted(Comparator.comparing(LocalizationKey::getKey));
        List keys = keyStream.collect(Collectors.toList());
        File zipFile = File.createTempFile("temp", ".zip");
        FileOutputStream fos = new FileOutputStream(zipFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        zos.putNextEntry(new ZipEntry("LocalizationKey.csv"));
        CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter(zos), CSVFormat.DEFAULT.withHeader(new String[]{"key", "application", "localizationKeyFormat", "localizationKeyType", "comments"}));
        for (LocalizationKey key2 : keys) {
            printer.printRecord(new Object[]{key2.getKey(), key2.getApplication() != null ? key2.getApplication().getName() : null, key2.getLocalizationKeyFormat() != null ? key2.getLocalizationKeyFormat().name() : null, key2.getLocalizationKeyType() != null ? key2.getLocalizationKeyType().name() : null, key2.getComments()});
        }
        printer.flush();
        zos.closeEntry();
        zos.putNextEntry(new ZipEntry("LocalizationValue.csv"));
        printer = new CSVPrinter((Appendable)new OutputStreamWriter(zos), CSVFormat.DEFAULT.withHeader(new String[]{"key", "application", "language", "original", "machineTranslation", "translation", "adminLocalOverride", "adminKeyOverride", "currentDisplayValue", "notes", "machineTranslationState", "translationState", "translationVerificationState"}));
        for (LocalizationKey key2 : keys) {
            for (LocalizationValue value : key2.getLocalizationValues()) {
                printer.printRecord(new Object[]{value.getLocalizationKey().getKey(), value.getLocalizationKey().getApplication() != null ? value.getLocalizationKey().getApplication().getName() : null, value.getLanguage(), value.getOriginal(), value.getMachineTranslation(), value.getTranslation(), value.getAdminLocalOverride(), value.getAdminKeyOverride(), value.getCurrentDisplayValue(), value.getNotes(), value.getMachineTranslationState() != null ? value.getMachineTranslationState().name() : null, value.getTranslationState() != null ? value.getTranslationState().name() : null, value.getTranslationVerificationState() != null ? value.getTranslationVerificationState().name() : null});
            }
        }
        printer.flush();
        zos.closeEntry();
        zos.close();
        fos.close();
        LOGGER.info("User exported translation data: " + keys.size() + " keys.");
        return zipFile;
    }

    public static void importTranslationExport(File file, Application application) throws IOException {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
        ZipEntry zipEntry = zis.getNextEntry();
        Map<String, LocalizationKey> keyApplicationMap = LocalizationKey.getAll().stream().collect(Collectors.toMap(key -> key.getKey() + ":" + (key.getApplication() != null ? key.getApplication().getName() : ""), key -> key));
        Map<String, Application> applicationMap = Application.getAll().stream().collect(Collectors.toMap(Application::getName, app -> app));
        Map<String, LocalizationKeyFormat> localizationKeyFormatMap = Arrays.stream(LocalizationKeyFormat.values()).collect(Collectors.toMap(Enum::name, e -> e));
        Map<String, LocalizationKeyType> localizationKeyTypeMap = Arrays.stream(LocalizationKeyType.values()).collect(Collectors.toMap(Enum::name, e -> e));
        Map<String, MachineTranslationState> machineTranslationStateMap = Arrays.stream(MachineTranslationState.values()).collect(Collectors.toMap(Enum::name, e -> e));
        Map<String, TranslationState> translationStateMap = Arrays.stream(TranslationState.values()).collect(Collectors.toMap(Enum::name, e -> e));
        Map<String, TranslationVerificationState> translationVerificationStateMap = Arrays.stream(TranslationVerificationState.values()).collect(Collectors.toMap(Enum::name, e -> e));
        Map<String, LocalizationValue> valueByKeyAppAndLanguage = LocalizationValue.getAll().stream().collect(Collectors.toMap(value -> value.getLocalizationKey().getKey() + ":" + (value.getLocalizationKey().getApplication() != null ? value.getLocalizationKey().getApplication().getName() : "") + ":" + value.getLanguage(), value -> value));
        ChangeCounter changeCounter = new ChangeCounter();
        while (zipEntry != null) {
            Object key2;
            CSVParser parser;
            if (zipEntry.getName().equals("LocalizationKey.csv")) {
                parser = CSVFormat.DEFAULT.withHeader(new String[]{"key", "application", "localizationKeyFormat", "localizationKeyType", "comments"}).withFirstRecordAsHeader().parse((Reader)new InputStreamReader(zis));
                for (CSVRecord csvRecord : parser) {
                    key2 = csvRecord.get("key");
                    Application app2 = applicationMap.get(csvRecord.get("application"));
                    String keyApp = (String)key2 + ":" + (app2 != null ? app2.getName() : "");
                    LocalizationKeyFormat localizationKeyFormat = localizationKeyFormatMap.get(csvRecord.get("localizationKeyFormat"));
                    LocalizationKeyType localizationKeyType = localizationKeyTypeMap.get(csvRecord.get("localizationKeyType"));
                    String comments = csvRecord.get("comments");
                    if (application != null && !application.equals(app2)) {
                        changeCounter.error("key");
                        continue;
                    }
                    changeCounter.updateOrCreate("key", keyApplicationMap.containsKey(keyApp));
                    LocalizationKey localizationKey = keyApplicationMap.computeIfAbsent(keyApp, keyValue -> LocalizationKey.create());
                    localizationKey.setApplication(app2).setLocalizationKeyFormat(localizationKeyFormat).setLocalizationKeyType(localizationKeyType).setComments(comments).setUsed(true).save();
                }
            } else if (zipEntry.getName().equals("LocalizationValue.csv")) {
                parser = CSVFormat.DEFAULT.withHeader(new String[]{"key", "application", "language", "original", "machineTranslation", "translation", "adminLocalOverride", "adminKeyOverride", "currentDisplayValue", "notes", "machineTranslationState", "translationState", "translationVerificationState"}).withFirstRecordAsHeader().parse((Reader)new InputStreamReader(zis));
                for (CSVRecord csvRecord : parser) {
                    key2 = keyApplicationMap.get(csvRecord.get("key") + ":" + csvRecord.get("application"));
                    String language = csvRecord.get("language");
                    String original = csvRecord.get("original");
                    String machineTranslation = csvRecord.get("machineTranslation");
                    String translation = csvRecord.get("translation");
                    String adminLocalOverride = csvRecord.get("adminLocalOverride");
                    String adminKeyOverride = csvRecord.get("adminKeyOverride");
                    String currentDisplayValue = csvRecord.get("currentDisplayValue");
                    String notes = csvRecord.get("notes");
                    MachineTranslationState machineTranslationState = machineTranslationStateMap.getOrDefault(csvRecord.get("machineTranslationState"), MachineTranslationState.TRANSLATION_REQUESTED);
                    TranslationState translationState = translationStateMap.getOrDefault(csvRecord.get("translationState"), TranslationState.TRANSLATION_REQUESTED);
                    TranslationVerificationState translationVerificationState = translationVerificationStateMap.getOrDefault(csvRecord.get("translationVerificationState"), TranslationVerificationState.NOT_YET_TRANSLATED);
                    if (key2 == null || language == null) {
                        changeCounter.error("value");
                        continue;
                    }
                    String keyAppLangKey = key2.getKey() + ":" + (key2.getApplication() != null ? key2.getApplication().getName() : null) + ":" + language;
                    changeCounter.updateOrCreate("value", valueByKeyAppAndLanguage.containsKey(keyAppLangKey));
                    LocalizationValue localizationValue = valueByKeyAppAndLanguage.computeIfAbsent(keyAppLangKey, s -> LocalizationValue.create());
                    localizationValue.setLocalizationKey((LocalizationKey)key2).setLanguage(language).setOriginal(original).setMachineTranslation(machineTranslation).setTranslation(translation).setAdminLocalOverride(adminLocalOverride).setAdminKeyOverride(adminKeyOverride).setCurrentDisplayValue(currentDisplayValue).setNotes(notes).setMachineTranslationState(machineTranslationState).setTranslationState(translationState).setTranslationVerificationState(translationVerificationState).save();
                }
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        LOGGER.info("User imported localization data: " + changeCounter.getResults());
    }

    public static File createTranslationTemplateFile() throws IOException {
        File csvFile = File.createTempFile("temp", ".csv");
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(csvFile));
        List languages = LocalizationValue.getAll().stream().map(LocalizationValue::getLanguage).collect(Collectors.toSet()).stream().sorted().collect(Collectors.toList());
        StringBuilder header = new StringBuilder();
        header.append("Key,Application,Type");
        for (String language : languages) {
            header.append(",").append(StringEscapeUtils.escapeCsv((String)language));
        }
        header.append("\n");
        bos.write(header.toString().getBytes(StandardCharsets.UTF_8));
        for (LocalizationKey key : LocalizationKey.getAll()) {
            Map<String, LocalizationValue> valueByLanguage = key.getLocalizationValues().stream().collect(Collectors.toMap(LocalizationValue::getLanguage, v -> v));
            StringBuilder sb = new StringBuilder();
            String app = key.getApplication() != null ? key.getApplication().getName() : null;
            sb.append(StringEscapeUtils.escapeCsv((String)key.getKey())).append(",");
            sb.append(StringEscapeUtils.escapeCsv((String)app)).append(",");
            sb.append(StringEscapeUtils.escapeCsv((String)key.getLocalizationKeyType().name())).append(",");
            for (String language : languages) {
                LocalizationValue value = valueByLanguage.get(language);
                String v2 = value != null ? value.getOriginal() : null;
                sb.append(StringEscapeUtils.escapeCsv((String)v2)).append(",");
            }
            sb.append("\n");
            bos.write(sb.toString().getBytes(StandardCharsets.UTF_8));
        }
        bos.close();
        return csvFile;
    }

    public static String importLocalizationKeyFile(File xlsxFile, Application application, LocalizationConfig localizationConfig) throws IOException {
        if (application == null) {
            return "ERROR no application selected!";
        }
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new FileInputStream(xlsxFile));
        XSSFSheet sheet = workbook.getSheetAt(0);
        StringBuilder errors = new StringBuilder();
        Map<String, LocalizationKey> keyMap = LocalizationKey.filter().application(NumericFilter.equalsFilter((Number)application.getId())).execute().stream().collect(Collectors.toMap(LocalizationKey::getKey, key -> key));
        int countCreatedKeys = 0;
        int countUpdatedKeys = 0;
        int countCreatedValues = 0;
        int countUpdatedValues = 0;
        Iterator rowIterator = sheet.iterator();
        if (rowIterator.hasNext()) {
            rowIterator.next();
        }
        ArrayList<LocalizationKey> createdKeys = new ArrayList<LocalizationKey>();
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            String key2 = LocalizationUtil.getCellText(row.getCell(0));
            String language = LocalizationUtil.getCellText(row.getCell(1));
            int translationMode = LocalizationUtil.getCellIntValue(row.getCell(2));
            String text = LocalizationUtil.getCellText(row.getCell(3));
            if (key2 == null || key2.isBlank() || text == null || text.isBlank()) continue;
            key2 = key2.trim();
            Language languageByIsoCode = Language.getLanguageByIsoCode((String)language);
            if (languageByIsoCode == null) {
                errors.append("Error for key: ").append(key2).append(" unknown language code:").append(language).append("\n");
                continue;
            }
            if (translationMode < 0 || translationMode > 3) {
                errors.append("Error for key: ").append(key2).append(" unknown translation mode:").append(translationMode).append("\n");
                continue;
            }
            LocalizationKey localizationKey = keyMap.get(key2);
            if (localizationKey == null) {
                localizationKey = LocalizationKey.create();
                localizationKey.setApplication(application).setKey(key2).setLocalizationKeyType(LocalizationKeyType.REPORTING_KEY).setUsed(true).save();
                createdKeys.add(localizationKey);
                keyMap.put(key2, localizationKey);
                ++countCreatedKeys;
            } else {
                ++countUpdatedKeys;
            }
            LocalizationValue localizationValue = localizationKey.getLocalizationValues().stream().filter(value -> value.getLanguage().equals(language)).findFirst().orElse(null);
            if (localizationValue == null) {
                localizationValue = (LocalizationValue)LocalizationValue.create().setLocalizationKey(localizationKey).setLanguage(language).save();
                ++countCreatedValues;
            } else {
                ++countUpdatedValues;
            }
            switch (translationMode) {
                case 0: {
                    localizationValue.setOriginal(text).setMachineTranslationState(MachineTranslationState.NOT_NECESSARY).setTranslationState(TranslationState.NOT_NECESSARY).setTranslationVerificationState(TranslationVerificationState.NOT_NECESSARY).setCurrentDisplayValue(text).save();
                    break;
                }
                case 1: {
                    localizationValue.setTranslation(text).setMachineTranslationState(MachineTranslationState.NOT_NECESSARY).setTranslationState(TranslationState.OK).setTranslationVerificationState(TranslationVerificationState.VERIFICATION_REQUESTED).setCurrentDisplayValue(text).save();
                    break;
                }
                case 2: {
                    localizationValue.setTranslation(text).setMachineTranslationState(MachineTranslationState.NOT_NECESSARY).setTranslationState(TranslationState.OK).setTranslationVerificationState(TranslationVerificationState.OK).setCurrentDisplayValue(text).save();
                    break;
                }
                case 3: {
                    localizationValue.setAdminLocalOverride(text).setCurrentDisplayValue(text);
                    if (localizationValue.getMachineTranslationState() == null) {
                        localizationValue.setMachineTranslationState(MachineTranslationState.NOT_NECESSARY);
                    }
                    if (localizationValue.getTranslationState() == null) {
                        localizationValue.setTranslationState(TranslationState.NOT_NECESSARY);
                    }
                    if (localizationValue.getTranslationVerificationState() == null) {
                        localizationValue.setTranslationVerificationState(TranslationVerificationState.NOT_NECESSARY);
                    }
                    localizationValue.save();
                }
            }
        }
        LocalizationUtil.createRequiredLanguageValues(createdKeys, localizationConfig);
        workbook.close();
        return "Localization keys updates:\nCreated keys: " + countCreatedKeys + "\nUpdated keys: " + countUpdatedKeys + "\nCreated values: " + countCreatedValues + "\nUpdated values: " + countUpdatedValues + "\n\nError messages:\n" + errors;
    }

    private static String getCellText(Cell cell) {
        if (cell != null && cell.getCellType() == CellType.STRING) {
            return cell.getStringCellValue();
        }
        return null;
    }

    private static int getCellIntValue(Cell cell) {
        if (cell != null && cell.getCellType() == CellType.NUMERIC) {
            double cellValue = cell.getNumericCellValue();
            return (int)cellValue;
        }
        return -1;
    }
}

