/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.ui.localize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.application.ux.PropertyData;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.LocalizationKey;
import org.teamapps.model.controlcenter.LocalizationKeyType;
import org.teamapps.universaldb.index.enumeration.EnumFilterType;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.template.Template;

public class LocalizationUiUtils {
    public static ComboBox<String> createLocalizationKeyCombo(Template template, ApplicationLocalizationProvider localizationProvider) {
        return LocalizationUiUtils.createLocalizationKeyCombo(template, localizationProvider, null);
    }

    public static ComboBox<String> createLocalizationKeyCombo(Template template, ApplicationLocalizationProvider localizationProvider, Supplier<Application> applicationSupplier) {
        ComboBox comboBox = new ComboBox(template);
        comboBox.setPropertyProvider((s, propertyNames) -> {
            if (s == null || s.isBlank()) {
                return PropertyData.createEmpty();
            }
            LocalizationKey localizationKey = (LocalizationKey)LocalizationKey.filter().key(TextFilter.textEqualsFilter((String)s)).executeExpectSingleton();
            if (localizationKey == null) {
                return PropertyData.create((Icon)ApplicationIcons.SYMBOL_QUESTIONMARK, (String)s);
            }
            return PropertyData.create((Icon)LocalizationUiUtils.getLocalizationKeyIcon(localizationKey), (String)localizationProvider.getLocalized(localizationKey.getKey(), new Object[0]), (String)localizationKey.getKey());
        });
        comboBox.setRecordToStringFunction(x$0 -> localizationProvider.getLocalized(x$0, new Object[0]));
        comboBox.setModel(query -> {
            ArrayList keys = new ArrayList();
            keys.addAll(applicationSupplier != null && applicationSupplier.get() != null ? LocalizationKey.filter().application(NumericFilter.equalsFilter((Number)((Application)applicationSupplier.get()).getId())).execute() : Collections.emptyList());
            keys.addAll(LocalizationKey.filter().localizationKeyType(EnumFilterType.EQUALS, LocalizationKeyType.DICTIONARY_KEY).execute());
            keys.addAll(LocalizationKey.filter().localizationKeyType(EnumFilterType.EQUALS, LocalizationKeyType.SYSTEM_KEY).execute());
            if (query == null || query.isBlank()) {
                return keys.stream().limit(150L).map(LocalizationKey::getKey).collect(Collectors.toList());
            }
            String q = query.toLowerCase();
            return keys.stream().filter(key -> key.getKey().toLowerCase().contains(q) || localizationProvider.getLocalized(key.getKey(), new Object[0]).toLowerCase().contains(q)).limit(150L).map(LocalizationKey::getKey).collect(Collectors.toList());
        });
        return comboBox;
    }

    public static Icon getLocalizationKeyIcon(LocalizationKey key) {
        if (key == null) {
            return null;
        }
        return switch (key.getLocalizationKeyType()) {
            case LocalizationKeyType.APPLICATION_RESOURCE_KEY -> IconUtils.decodeIcon((String)key.getApplication().getIcon());
            case LocalizationKeyType.DICTIONARY_KEY -> ApplicationIcons.DICTIONARY;
            case LocalizationKeyType.REPORTING_KEY -> ApplicationIcons.DOCUMENT_NOTEBOOK;
            case LocalizationKeyType.SYSTEM_KEY -> ApplicationIcons.SYSTEM;
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

