package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbGroupMembershipDefinitionQuery extends AbstractUdbQuery<GroupMembershipDefinition> implements GroupMembershipDefinitionQuery {

    public UdbGroupMembershipDefinitionQuery() {
        super(UdbGroupMembershipDefinition.table, GroupMembershipDefinition.getBuilder());
    }

    @Override
    public GroupMembershipDefinitionQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public GroupMembershipDefinitionQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public GroupMembershipDefinitionQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public GroupMembershipDefinitionQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbGroupMembershipDefinition.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbGroupMembershipDefinition.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery metaCreationDate(NumericFilter filter) {
		and(UdbGroupMembershipDefinition.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbGroupMembershipDefinition.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery metaCreatedBy(NumericFilter filter) {
		and(UdbGroupMembershipDefinition.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbGroupMembershipDefinition.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery metaModificationDate(NumericFilter filter) {
		and(UdbGroupMembershipDefinition.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbGroupMembershipDefinition.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery metaModifiedBy(NumericFilter filter) {
		and(UdbGroupMembershipDefinition.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbGroupMembershipDefinition.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery metaDeletionDate(NumericFilter filter) {
		and(UdbGroupMembershipDefinition.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbGroupMembershipDefinition.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery metaDeletedBy(NumericFilter filter) {
		and(UdbGroupMembershipDefinition.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbGroupMembershipDefinition.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery metaRestoreDate(NumericFilter filter) {
		and(UdbGroupMembershipDefinition.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbGroupMembershipDefinition.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery metaRestoredBy(NumericFilter filter) {
		and(UdbGroupMembershipDefinition.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbGroupMembershipDefinition.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery groupMemberType(EnumFilterType filterType, GroupMemberType... enums) {
		and(UdbGroupMembershipDefinition.groupMemberType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery orGroupMemberType(EnumFilterType filterType, GroupMemberType... enums) {
		or(UdbGroupMembershipDefinition.groupMemberType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery filterUser(UserQuery query) {
		UdbUserQuery udbQuery = (UdbUserQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbGroupMembershipDefinition.user);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery user(NumericFilter filter) {
		and(UdbGroupMembershipDefinition.user.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery orUser(NumericFilter filter) {
		or(UdbGroupMembershipDefinition.user.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery filterGroup(GroupQuery query) {
		UdbGroupQuery udbQuery = (UdbGroupQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbGroupMembershipDefinition.group);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery group(NumericFilter filter) {
		and(UdbGroupMembershipDefinition.group.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery orGroup(NumericFilter filter) {
		or(UdbGroupMembershipDefinition.group.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery filterRole(RoleQuery query) {
		UdbRoleQuery udbQuery = (UdbRoleQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbGroupMembershipDefinition.role);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery role(NumericFilter filter) {
		and(UdbGroupMembershipDefinition.role.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery orRole(NumericFilter filter) {
		or(UdbGroupMembershipDefinition.role.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery filterOrganizationUnit(OrganizationUnitQuery query) {
		UdbOrganizationUnitQuery udbQuery = (UdbOrganizationUnitQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbGroupMembershipDefinition.organizationUnit);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery organizationUnit(NumericFilter filter) {
		and(UdbGroupMembershipDefinition.organizationUnit.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery orOrganizationUnit(NumericFilter filter) {
		or(UdbGroupMembershipDefinition.organizationUnit.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery filterOrganizationUnitTypesFilter(OrganizationUnitTypeQuery query) {
		UdbOrganizationUnitTypeQuery udbQuery = (UdbOrganizationUnitTypeQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbGroupMembershipDefinition.organizationUnitTypesFilter);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery organizationUnitTypesFilter(MultiReferenceFilterType type, OrganizationUnitType ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (OrganizationUnitType value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbGroupMembershipDefinition.organizationUnitTypesFilter.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery organizationUnitTypesFilterCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbGroupMembershipDefinition.organizationUnitTypesFilter.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery organizationUnitTypesFilter(MultiReferenceFilter filter) {
		and(UdbGroupMembershipDefinition.organizationUnitTypesFilter.createFilter(filter));
		return this;
	}

	@Override
	public GroupMembershipDefinitionQuery orOrganizationUnitTypesFilter(MultiReferenceFilter filter) {
		or(UdbGroupMembershipDefinition.organizationUnitTypesFilter.createFilter(filter));
		return this;
	}


	@Override
	public UdbGroupMembershipDefinitionQuery andOr(GroupMembershipDefinitionQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public GroupMembershipDefinitionQuery customFilter(Function<GroupMembershipDefinition, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(GroupMembershipDefinition.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



