/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.roles;

import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.ApplicationRoleAssignmentPrivilegeObjectProvider;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.controlcenter.Privileges;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.bootstrap.LoadedApplication;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.combo.ComboBoxUtils;
import org.teamapps.application.ux.form.FormController;
import org.teamapps.application.ux.view.MasterDetailController;
import org.teamapps.databinding.MutableValue;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.model.controlcenter.OrganizationUnitType;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.model.controlcenter.Role;
import org.teamapps.model.controlcenter.User;
import org.teamapps.model.controlcenter.UserRoleAssignment;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.pojo.Query;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.CheckBox;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

public class UserRoleAssignmentPerspective
extends AbstractManagedApplicationPerspective {
    private final UserSessionData userSessionData;

    public UserRoleAssignmentPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        PerspectiveSessionData perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
        this.userSessionData = perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();
        this.createUi();
    }

    private void createUi() {
        Supplier<Query> querySupplier = () -> this.isAppFilter() ? UserRoleAssignment.filter().filterRole(Role.filter().organizationField(NumericFilter.equalsFilter((Number)this.getOrganizationField().getId()))) : UserRoleAssignment.filter();
        MasterDetailController masterDetailController = new MasterDetailController(ApplicationIcons.USERS_THREE_RELATION, this.getLocalized("userRoleAssignment.userRoleAssignments"), this.getApplicationInstanceData(), querySupplier, Privileges.USER_ROLE_ASSIGNMENT_PERSPECTIVE, "organizationUnit");
        EntityModelBuilder entityModelBuilder = masterDetailController.getEntityModelBuilder();
        FormController formController = masterDetailController.getFormController();
        ResponsiveForm form = masterDetailController.getResponsiveForm();
        Table table = entityModelBuilder.createTable();
        table.setDisplayAsList(true);
        table.setRowHeight(28);
        table.setStripedRows(false);
        entityModelBuilder.updateModels();
        TemplateField userTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.createUserPropertyProvider(this.getApplicationInstanceData()));
        TemplateField roleTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.createRolePropertyProvider(this.getApplicationInstanceData()));
        TemplateField orgUnitTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.creatOrganizationUnitPropertyProvider(this.getApplicationInstanceData()));
        table.addColumn(new TableColumn("user", this.getLocalized("userRoleAssignment.user"), (AbstractField)userTableField).setDefaultWidth(200));
        table.addColumn(new TableColumn("role", this.getLocalized("userRoleAssignment.role"), (AbstractField)roleTableField).setDefaultWidth(200));
        table.addColumn(new TableColumn("organizationUnit", this.getLocalized("userRoleAssignment.orgUnit"), (AbstractField)orgUnitTableField).setDefaultWidth(200));
        entityModelBuilder.setCustomFieldSorter(fieldName -> {
            Comparator comparator = this.getUser().getComparator(true);
            List rankedLanguages = this.getUser().getRankedLanguages();
            return switch (fieldName) {
                case "user" -> (r1, r2) -> comparator.compare(r1.getUser().getLastName(), r2.getUser().getLastName());
                case "role" -> (r1, r2) -> comparator.compare(r1.getRole().getTitle().getText(rankedLanguages), r2.getRole().getTitle().getText(rankedLanguages));
                case "organizationUnit" -> (r1, r2) -> comparator.compare(r1.getOrganizationUnit().getName().getText(rankedLanguages), r2.getOrganizationUnit().getName().getText(rankedLanguages));
                default -> null;
            };
        });
        entityModelBuilder.setCustomFullTextFilter((r, query) -> {
            List rankedLanguages = this.getUser().getRankedLanguages();
            return r.getUser() != null && r.getOrganizationUnit() != null && r.getRole() != null && (this.matches(r.getUser().getFirstName(), (String)query) || this.matches(r.getUser().getLastName(), (String)query) || this.matches(r.getRole().getTitle().getText(rankedLanguages), (String)query) || this.matches(r.getOrganizationUnit().getName().getText(rankedLanguages), (String)query));
        });
        table.setPropertyExtractor((userRoleAssignment, propertyName) -> switch (propertyName) {
            case "user" -> userRoleAssignment.getUser();
            case "role" -> userRoleAssignment.getRole();
            case "organizationUnit" -> userRoleAssignment.getOrganizationUnit();
            default -> null;
        });
        ComboBox userCombobox = ComboBoxUtils.createComboBox(query -> query == null || query.isBlank() ? User.getAll().stream().limit(50L).collect(Collectors.toList()) : User.filter().parseFullTextFilter(query, new String[0]).execute().stream().limit(50L).collect(Collectors.toList()), PropertyProviders.createUserPropertyProvider(this.getApplicationInstanceData()), (Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        ComboBox roleComboBox = ComboBoxUtils.createRecordComboBox(() -> this.isAppFilter() ? Role.filter().organizationField(NumericFilter.equalsFilter((Number)this.getOrganizationField().getId())).execute() : Role.getAll(), PropertyProviders.createRolePropertyProvider(this.getApplicationInstanceData()), (Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        AbstractField organizationComboBox = formController.getOrganizationUnitViewField((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES, false);
        CheckBox mainResponsibleField = new CheckBox(this.getLocalized("userRoleAssignment.mainResponsible"));
        ComboBox delegatedPrivilegeObjectComboBox = ComboBoxUtils.createRecordComboBox(() -> {
            Role role = (Role)roleComboBox.getValue();
            if (role != null && role.isDelegatedCustomPrivilegeObjectRole() && organizationComboBox.getValue() != null) {
                ApplicationRoleAssignmentPrivilegeObjectProvider privilegeObjectProvider = this.getDelegatePrivilegeObjectProvider();
                return privilegeObjectProvider != null ? privilegeObjectProvider.getPrivilegeObjects((OrganizationUnitView)organizationComboBox.getValue()) : Collections.emptyList();
            }
            return Collections.emptyList();
        }, (privilegeObject, collection) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", privilegeObject.getIcon());
            map.put("caption", this.getLocalized(privilegeObject.getTitleKey()));
            return map;
        }, (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        delegatedPrivilegeObjectComboBox.setVisible(false);
        roleComboBox.onValueChanged.addListener(role -> {
            if (role == null || !role.isDelegatedCustomPrivilegeObjectRole()) {
                delegatedPrivilegeObjectComboBox.setVisible(false);
            } else {
                delegatedPrivilegeObjectComboBox.setValue(null);
                delegatedPrivilegeObjectComboBox.setVisible(true);
            }
        });
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(450);
        formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false);
        formLayout.addLabelAndField(null, this.getLocalized("userRoleAssignment.user"), (AbstractField)userCombobox);
        formLayout.addLabelAndField(null, this.getLocalized("userRoleAssignment.role"), (AbstractField)roleComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("userRoleAssignment.orgUnit"), organizationComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("userRoleAssignment.customPrivilegeObject"), (AbstractField)delegatedPrivilegeObjectComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("userRoleAssignment.mainResponsible"), (AbstractField)mainResponsibleField);
        masterDetailController.createViews(this.getPerspective(), (Component)table, formLayout);
        formController.addNotNull((AbstractField)userCombobox);
        formController.addNotNull((AbstractField)roleComboBox);
        formController.addNotNull(organizationComboBox);
        formController.addValidator((AbstractField)roleComboBox, role -> {
            OrganizationUnit organizationUnit = OrganizationUtils.convert((OrganizationUnitView)organizationComboBox.getValue());
            if (organizationUnit != null && role != null) {
                OrganizationUnitType type = organizationUnit.getType();
                List<OrganizationUnitType> unitTypes = role.getAllowedOrganizationUnitTypes();
                if (!unitTypes.isEmpty() && !unitTypes.contains(type)) {
                    return this.getLocalized("userRoleAssignment.wrongOrgUnitForThisRole");
                }
                if (role.isDelegatedCustomPrivilegeObjectRole() && delegatedPrivilegeObjectComboBox.getValue() == null) {
                    return this.getLocalized("userRoleAssignment.missingCustomPrivilegeObject");
                }
            }
            return null;
        });
        formController.setSaveEntityHandler(userRoleAssignment -> {
            userRoleAssignment.setUser((User)userCombobox.getValue()).setRole((Role)roleComboBox.getValue()).setOrganizationUnit(OrganizationUtils.convert((OrganizationUnitView)organizationComboBox.getValue())).setDelegatedCustomPrivilegeObjectId(delegatedPrivilegeObjectComboBox.getValue() != null ? ((PrivilegeObject)delegatedPrivilegeObjectComboBox.getValue()).getId() : 0).setMainResponsible((Boolean)mainResponsibleField.getValue()).setLastVerified(Instant.now());
            return true;
        });
        entityModelBuilder.getOnSelectionEvent().addListener(userRoleAssignment -> {
            userCombobox.setValue((Object)userRoleAssignment.getUser());
            roleComboBox.setValue((Object)userRoleAssignment.getRole());
            organizationComboBox.setValue((Object)OrganizationUtils.convert(userRoleAssignment.getOrganizationUnit()));
            mainResponsibleField.setValue((Object)userRoleAssignment.isMainResponsible());
            delegatedPrivilegeObjectComboBox.setValue(null);
            if (userRoleAssignment.getDelegatedCustomPrivilegeObjectId() > 0) {
                ApplicationRoleAssignmentPrivilegeObjectProvider privilegeObjectProvider = this.getDelegatePrivilegeObjectProvider();
                if (privilegeObjectProvider != null) {
                    delegatedPrivilegeObjectComboBox.setValue((Object)privilegeObjectProvider.getPrivilegeObjectById(userRoleAssignment.getDelegatedCustomPrivilegeObjectId()));
                }
                delegatedPrivilegeObjectComboBox.setVisible(true);
            } else {
                delegatedPrivilegeObjectComboBox.setVisible(false);
            }
        });
        entityModelBuilder.setSelectedRecord((Object)UserRoleAssignment.create());
    }

    private boolean matches(String value, String query) {
        return value != null && value.toLowerCase().contains(query);
    }

    private ApplicationRoleAssignmentPrivilegeObjectProvider getDelegatePrivilegeObjectProvider() {
        LoadedApplication loadedApplication = this.userSessionData.getRegistry().getLoadedApplication(this.getMainApplication());
        return loadedApplication.getBaseApplicationBuilder().getRoleAssignmentDelegatedPrivilegeObjectProvider();
    }
}

