/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.users;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.perspective.AbstractPerspectiveBuilder;
import org.teamapps.application.api.application.perspective.ApplicationPerspective;
import org.teamapps.application.api.application.perspective.PerspectiveMenuPanel;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.localization.Language;
import org.teamapps.application.api.password.SecurePasswordHash;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.controlcenter.Privileges;
import org.teamapps.application.server.controlcenter.roles.UserRoleAssignmentPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.users.UsersPerspectiveBuilder;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.application.server.system.privilege.UserPrivileges;
import org.teamapps.application.server.system.privilege.UserPrivilegesView;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.server.system.utils.ValueConverterUtils;
import org.teamapps.application.server.ui.address.AddressForm;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.combo.ComboBoxUtils;
import org.teamapps.application.ux.form.FormController;
import org.teamapps.application.ux.view.MasterDetailController;
import org.teamapps.application.ux.window.ApplicationWindow;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.databinding.MutableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Address;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.model.controlcenter.User;
import org.teamapps.model.controlcenter.UserAccountStatus;
import org.teamapps.model.controlcenter.UserRoleAssignment;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.pojo.Query;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.dialogue.FormDialogue;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.PasswordField;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.combobox.TagBoxWrappingMode;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.field.datetime.InstantDateTimeField;
import org.teamapps.ux.component.field.upload.PictureChooser;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.itemview.SimpleItemView;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.resource.ByteArrayResource;
import org.teamapps.ux.resource.Resource;

public class UsersPerspective
extends AbstractManagedApplicationPerspective {
    private final UserSessionData userSessionData;

    public UsersPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        PerspectiveSessionData perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
        this.userSessionData = perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();
        this.createUi();
    }

    private void createUi() {
        UsersPerspectiveBuilder usersPerspectiveBuilder = new UsersPerspectiveBuilder();
        PerspectiveMenuPanel menuPanel = PerspectiveMenuPanel.createMenuPanel((ApplicationInstanceData)this.getApplicationInstanceData(), (AbstractPerspectiveBuilder[])new AbstractPerspectiveBuilder[]{usersPerspectiveBuilder, new UserRoleAssignmentPerspectiveBuilder()});
        menuPanel.addInstantiatedPerspective((AbstractPerspectiveBuilder)usersPerspectiveBuilder, (ApplicationPerspective)this);
        SimpleItemView buttonMenu = menuPanel.getButtonMenu();
        this.setPerspectiveMenuPanel(menuPanel.getComponent(), (Component)buttonMenu);
        List allowedUnits = this.getAllowedUnits(Privileges.USERS_PERSPECTIVE, Privilege.READ);
        Set unitIdSet = allowedUnits.stream().map(Entity::getId).collect(Collectors.toSet());
        Supplier<Query> querySupplier = () -> User.filter().customFilter(user -> user.getOrganizationUnit() == null || unitIdSet.contains(user.getOrganizationUnit().getId()));
        MasterDetailController masterDetailController = new MasterDetailController(ApplicationIcons.USERS_CROWD, this.getLocalized("users.users"), this.getApplicationInstanceData(), querySupplier, Privileges.USERS_PERSPECTIVE, "organizationUnit");
        EntityModelBuilder entityModelBuilder = masterDetailController.getEntityModelBuilder();
        FormController formController = masterDetailController.getFormController();
        ResponsiveForm form = masterDetailController.getResponsiveForm();
        Table table = entityModelBuilder.createListTable(false);
        table.setRowHeight(32);
        entityModelBuilder.updateModels();
        TemplateField userTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.createUserPropertyProvider(this.getApplicationInstanceData()));
        TemplateField accountStatusTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, this.createAccountStatusPropertyProvider());
        InstantDateTimeField lastLogin = new InstantDateTimeField();
        TagComboBox languagesTableField = Language.createTagComboBox((ApplicationLocalizationProvider)this.getApplicationInstanceData());
        TextField rolesTableField = new TextField();
        table.addColumn("lastName", this.getLocalized("users.user"), (AbstractField)userTableField).setDefaultWidth(250);
        table.addColumn("userAccountStatus", this.getLocalized("users.accountStatus"), (AbstractField)accountStatusTableField).setDefaultWidth(120);
        table.addColumn("lastLogin", this.getLocalized("users.lastLogin"), (AbstractField)lastLogin).setDefaultWidth(200);
        table.addColumn("languages", this.getLocalized("users.languages"), (AbstractField)languagesTableField).setDefaultWidth(350);
        table.addColumn("roleAssignments", this.getLocalized("users.roles"), (AbstractField)rolesTableField).setDefaultWidth(300);
        table.setPropertyExtractor((user, propertyName) -> switch (propertyName) {
            case "lastName" -> user;
            case "userAccountStatus" -> user.getUserAccountStatus();
            case "lastLogin" -> user.getLastLogin();
            case "languages" -> this.getLanguages(user.getLanguages());
            case "roleAssignments" -> this.getRolesString(user.getRoleAssignments(), 5);
            default -> null;
        });
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(450);
        ToolbarButtonGroup buttonGroup = new ToolbarButtonGroup();
        ToolbarButton updatePasswordButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.KEYS, (String)this.getLocalized("org.teamapps.dictionary.resetPassword")));
        formController.addToolbarButtonGroup(buttonGroup);
        buttonGroup = new ToolbarButtonGroup();
        ToolbarButton userPrivilegesButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.LOCK_OPEN, (String)this.getLocalized("org.teamapps.dictionary.privileges")));
        formController.addToolbarButtonGroup(buttonGroup);
        PictureChooser pictureChooser = new PictureChooser();
        pictureChooser.setImageDisplaySize(120, 120);
        pictureChooser.setTargetImageSize(240, 240);
        pictureChooser.setMaxFileSize(5000000L);
        TextField firstNameField = new TextField();
        TextField lastNameField = new TextField();
        TagComboBox languagesField = Language.createTagComboBox((ApplicationLocalizationProvider)this.getApplicationInstanceData());
        languagesField.setWrappingMode(TagBoxWrappingMode.SINGLE_TAG_PER_LINE);
        languagesField.setShowClearButton(true);
        TextField emailField = new TextField();
        TextField mobileField = new TextField();
        TextField loginField = new TextField();
        PasswordField passwordField = new PasswordField();
        ComboBox<UserAccountStatus> accountStatusComboBox = this.createAccountStatusComboBox();
        TagComboBox<UserRoleAssignment> userRoleAssignmentTagCombo = this.createUserRoleAssignmentTagCombo();
        AbstractField organizationUnitViewField = formController.getOrganizationUnitViewField();
        userRoleAssignmentTagCombo.setMargin(new Spacing(0, 5, 0, -4));
        formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false);
        formLayout.addLabelAndField(null, this.getLocalized("users.profilePicture"), (AbstractField)pictureChooser);
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.firstName"), (AbstractField)firstNameField);
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.lastName"), (AbstractField)lastNameField);
        formLayout.addLabelAndField(null, this.getLocalized("users.languages"), (AbstractField)languagesField);
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.eMail"), (AbstractField)emailField);
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.mobileNumber"), (AbstractField)mobileField);
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.userName"), (AbstractField)loginField);
        formLayout.addLabelAndField(null, this.getLocalized("users.accountStatus"), accountStatusComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("users.roles"), userRoleAssignmentTagCombo);
        formLayout.addLabelAndField(null, this.getLocalized("users.organizationUnit"), organizationUnitViewField);
        AddressForm addressForm = new AddressForm(this.getApplicationInstanceData());
        addressForm.createAddressSection(formLayout);
        addressForm.addFields(formLayout);
        formController.addNotBlank((AbstractField)firstNameField);
        formController.addNotBlank((AbstractField)lastNameField);
        formController.addEmailOrEmpty((AbstractField)emailField);
        formController.addPhoneOrEmptyNumber((AbstractField)mobileField);
        formController.addMinCharactersOrEmpty((AbstractField)loginField, 2);
        formController.addMinCharactersOrEmpty((AbstractField)passwordField, 9);
        formController.addNotEmptyList((AbstractField)languagesField);
        formController.addValidator(organizationUnitViewField, unit -> unit != null && OrganizationUtils.convert(unit).getType().isAllowUsers() ? null : this.getLocalized("users.wrongOrMissingOrgUnit"));
        masterDetailController.createViews(this.getPerspective(), (Component)table, formLayout);
        updatePasswordButton.onClick.addListener(() -> {
            User user = (User)entityModelBuilder.getSelectedRecord();
            if (user != null) {
                this.showUpdatePasswordDialogue(user);
            }
        });
        userPrivilegesButton.onClick.addListener(() -> {
            User user = (User)entityModelBuilder.getSelectedRecord();
            if (user != null) {
                this.showUserPrivilegesWindow(user);
            }
        });
        formController.setSaveEntityHandler(user -> {
            if (!addressForm.validateAddress() || !addressForm.getAddress().equals(user.getAddress())) {
                return false;
            }
            OrganizationUnit organizationUnit = OrganizationUtils.convert((OrganizationUnitView)organizationUnitViewField.getValue());
            byte[] picture = this.readUserPicture(pictureChooser);
            addressForm.getAddress().save();
            user.setFirstName((String)firstNameField.getValue()).setLastName((String)lastNameField.getValue()).setLanguages(this.getCompressedLanguages((List)languagesField.getValue())).setEmail((String)emailField.getValue()).setMobile((String)mobileField.getValue()).setLogin((String)loginField.getValue()).setUserAccountStatus((UserAccountStatus)((Object)((Object)accountStatusComboBox.getValue()))).setOrganizationUnit(organizationUnit);
            if (picture != null && picture.length != user.getProfilePictureLength()) {
                user.setProfilePicture(picture);
            }
            return true;
        });
        entityModelBuilder.getOnSelectionEvent().addListener(user -> {
            pictureChooser.setValue((Object)(user.getProfilePicture() != null ? new ByteArrayResource(user.getProfilePicture(), "image.jpg") : null));
            firstNameField.setValue((Object)user.getFirstName());
            lastNameField.setValue((Object)user.getLastName());
            languagesField.setValue(this.getLanguages(user.getLanguages()));
            emailField.setValue((Object)user.getEmail());
            mobileField.setValue((Object)user.getMobile());
            loginField.setValue((Object)user.getLogin());
            passwordField.setValue((Object)user.getPassword());
            accountStatusComboBox.setValue((Object)user.getUserAccountStatus());
            userRoleAssignmentTagCombo.setValue(user.getRoleAssignments());
            addressForm.setAddress(user.getAddress());
            formController.clearMessages();
        });
        Supplier<User> createNewEntitySupplier = () -> User.create().setAddress(Address.create()).setUserAccountStatus(UserAccountStatus.ACTIVE);
        formController.setCreateNewEntitySupplier(createNewEntitySupplier);
        entityModelBuilder.setSelectedRecord((Object)createNewEntitySupplier.get());
    }

    private void showUpdatePasswordDialogue(User user) {
        FormDialogue formDialogue = FormDialogue.create((Icon)ApplicationIcons.KEYS, (String)this.getLocalized("org.teamapps.dictionary.resetPassword"), (String)this.getLocalized("org.teamapps.dictionary.resetPassword"));
        PasswordField passwordField = new PasswordField();
        formDialogue.addField(ApplicationIcons.KEYS, this.getLocalized("org.teamapps.dictionary.password"), (AbstractField)passwordField);
        formDialogue.addOkCancelButtons(this.getLocalized("org.teamapps.dictionary.oK"), this.getLocalized("org.teamapps.dictionary.cancel"));
        formDialogue.onOk.addListener(() -> {
            String value = (String)passwordField.getValue();
            if (value.length() > 8) {
                user.setPassword(SecurePasswordHash.createDefault().createSecureHash(value)).save();
                UiUtils.showSaveNotification((boolean)true, (ApplicationInstanceData)this.getApplicationInstanceData());
                formDialogue.close();
            } else {
                UiUtils.showSaveNotification((boolean)false, (ApplicationInstanceData)this.getApplicationInstanceData());
            }
        });
        formDialogue.setCloseable(true);
        formDialogue.setCloseOnEscape(true);
        formDialogue.setMaximizable(true);
        formDialogue.show();
    }

    private void showUserPrivilegesWindow(User user) {
        UserPrivileges userPrivileges = new UserPrivileges(user, this.userSessionData.getRegistry());
        UserPrivilegesView userPrivilegesView = new UserPrivilegesView(userPrivileges, this.getApplicationInstanceData());
        ApplicationWindow window = new ApplicationWindow(ApplicationIcons.LOCK_OPEN, this.getLocalized("org.teamapps.dictionary.privileges"), this.getApplicationInstanceData());
        window.setContent(userPrivilegesView.getResponsiveForm());
        window.addCancelButton();
        window.setWindowPreferredSize(1000, 800, 0.1f);
        window.show();
    }

    private byte[] readUserPicture(PictureChooser pictureChooser) {
        if (pictureChooser.getValue() != null) {
            Resource value = (Resource)pictureChooser.getValue();
            try {
                return IOUtils.readFully((InputStream)value.getInputStream(), (int)((int)value.getLength()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getRolesString(List<UserRoleAssignment> assignments, int limit) {
        return assignments.stream().filter(assignment -> assignment.getRole() != null).map(assignment -> this.getLocalized(assignment.getRole().getTitle())).limit(limit).collect(Collectors.joining(", "));
    }

    public List<Language> getLanguages(String compressedValue) {
        return ValueConverterUtils.decompressToStringList(compressedValue).stream().map(Language::getLanguageByIsoCode).collect(Collectors.toList());
    }

    public String getCompressedLanguages(List<Language> languages) {
        return ValueConverterUtils.compressStringList(languages.stream().map(Language::getIsoCode).collect(Collectors.toList()));
    }

    private ComboBox<UserAccountStatus> createAccountStatusComboBox() {
        return ComboBoxUtils.createRecordComboBox(Arrays.asList(UserAccountStatus.values()), this.createAccountStatusPropertyProvider(), (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
    }

    private TagComboBox<UserRoleAssignment> createUserRoleAssignmentTagCombo() {
        TagComboBox tagComboBox = UiUtils.createTagComboBox((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_TWO_LINES, PropertyProviders.createUserRoleAssignmentPropertyProviderNoUserDisplay(this.userSessionData));
        tagComboBox.setEditingMode(FieldEditingMode.READONLY);
        return tagComboBox;
    }

    private PropertyProvider<UserAccountStatus> createAccountStatusPropertyProvider() {
        return (userAccountStatus, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", this.getAccountStatusIcon((UserAccountStatus)((Object)userAccountStatus)));
            map.put("caption", this.getLocalized("users.accountStatus." + userAccountStatus.name()));
            return map;
        };
    }

    private Icon getAccountStatusIcon(UserAccountStatus status) {
        return switch (status) {
            case UserAccountStatus.ACTIVE -> ApplicationIcons.OK;
            case UserAccountStatus.INACTIVE -> ApplicationIcons.ERROR;
            case UserAccountStatus.SUPER_ADMIN -> ApplicationIcons.PILOT;
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

