/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.server;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.LinkOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.application.api.password.SecurePasswordHash;
import org.teamapps.application.server.rest.ChatRestServlet;
import org.teamapps.application.server.system.bootstrap.BootstrapSessionHandler;
import org.teamapps.application.server.system.bootstrap.PublicLinkResourceProvider;
import org.teamapps.application.server.system.server.SecureResourceHandler;
import org.teamapps.application.server.system.server.SessionHandler;
import org.teamapps.application.server.system.server.SessionManager;
import org.teamapps.application.server.system.utils.ValueConverterUtils;
import org.teamapps.cluster.network.NodeAddress;
import org.teamapps.config.TeamAppsConfiguration;
import org.teamapps.model.ApplicationServerSchema;
import org.teamapps.model.controlcenter.User;
import org.teamapps.model.controlcenter.UserAccountStatus;
import org.teamapps.model.system.SystemStarts;
import org.teamapps.model.system.Type;
import org.teamapps.server.ServletRegistration;
import org.teamapps.server.undertow.embedded.TeamAppsUndertowEmbeddedServer;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.schema.SchemaInfoProvider;
import org.teamapps.ux.resource.ClassPathResourceProvider;
import org.teamapps.ux.resource.FileResource;
import org.teamapps.ux.resource.ResourceProvider;
import org.teamapps.ux.resource.ResourceProviderServlet;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.webcontroller.WebController;

public class ApplicationServer
implements WebController,
SessionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private File basePath;
    private TeamAppsConfiguration teamAppsConfiguration;
    private int port;
    private UniversalDB universalDb;
    private List<ServletRegistration> servletRegistrations = new ArrayList<ServletRegistration>();
    private SessionHandler sessionHandler;
    private WeakHashMap<SessionHandler, Long> weakStartDateBySessionHandler = new WeakHashMap();
    private boolean useCluster;
    private String clusterSecret;
    private int leaderPort;
    private String leaderHost;
    private int localPort;

    public ApplicationServer() {
        this(new File("./server-data"), new TeamAppsConfiguration(), 8080);
    }

    public ApplicationServer(boolean useCluster, String clusterSecret, int localPort, String leaderHost, int leaderPort) {
        this.basePath = new File("./server-data");
        this.teamAppsConfiguration = new TeamAppsConfiguration();
        this.port = 8080;
        this.useCluster = useCluster;
        this.clusterSecret = clusterSecret;
        this.leaderPort = leaderPort;
        this.leaderHost = leaderHost;
        this.localPort = localPort;
    }

    public ApplicationServer(File basePath) {
        this(basePath, new TeamAppsConfiguration(), 8080);
    }

    public ApplicationServer(File basePath, TeamAppsConfiguration teamAppsConfiguration, int port) {
        this.basePath = basePath;
        this.teamAppsConfiguration = teamAppsConfiguration;
        this.port = port;
    }

    @Override
    public void updateSessionHandler(File jarFile) throws Exception {
        LOGGER.info("Loading new session handler:" + jarFile.getPath());
        URLClassLoader classLoader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()});
        SessionHandler newSessionHandler = this.loadSessionHandler(classLoader);
        newSessionHandler.init(this, this.universalDb);
        this.weakStartDateBySessionHandler.put(newSessionHandler, System.currentTimeMillis());
        this.sessionHandler = newSessionHandler;
        System.gc();
        LOGGER.info("Updated session handler:" + this.sessionHandler);
    }

    @Override
    public void updateSessionHandler(SessionHandler sessionHandler) {
        sessionHandler.init(this, this.universalDb);
        this.weakStartDateBySessionHandler.put(sessionHandler, System.currentTimeMillis());
        this.sessionHandler = sessionHandler;
        LOGGER.info("Updated fixed session handler:" + sessionHandler);
    }

    private SessionHandler loadSessionHandler(URLClassLoader classLoader) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ClassGraph classGraph = new ClassGraph();
        if (classLoader != null) {
            classGraph.overrideClassLoaders(new ClassLoader[]{classLoader});
        }
        ClassInfoList classInfos = classGraph.enableAllInfo().scan().getClassesImplementing(SessionHandler.class.getName()).getStandardClasses();
        Class builder = ((ClassInfo)classInfos.get(0)).loadClass();
        return (SessionHandler)builder.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    public void onSessionStart(SessionContext context) {
        this.sessionHandler.handleSessionStart(context);
    }

    @Override
    public Collection<Long> getBootstrappedSystems() {
        return this.weakStartDateBySessionHandler.values();
    }

    public void start() throws Exception {
        File dbPath = new File(this.basePath, "database");
        dbPath.mkdir();
        this.universalDb = this.useCluster ? (this.leaderHost != null ? new UniversalDB(dbPath, (SchemaInfoProvider)new ApplicationServerSchema(), this.clusterSecret, this.localPort, new NodeAddress(this.leaderHost, this.leaderPort)) : new UniversalDB(dbPath, (SchemaInfoProvider)new ApplicationServerSchema(), this.clusterSecret, this.localPort)) : UniversalDB.createStandalone((File)dbPath, (SchemaInfoProvider)new ApplicationServerSchema());
        this.sessionHandler.init(this, this.universalDb);
        TeamAppsUndertowEmbeddedServer server = new TeamAppsUndertowEmbeddedServer((WebController)this, this.teamAppsConfiguration, this.port);
        this.addClassPathResourceProvider("org.teamapps.application.server.media", "/ta-media/");
        File staticResourcesPath = new File(this.basePath, "static");
        staticResourcesPath.mkdir();
        this.addServletRegistration(new ServletRegistration((Servlet)new ChatRestServlet(), "/connect-api-v1/*"));
        this.addServletRegistration(new ServletRegistration((Servlet)new ResourceProviderServlet((servletPath, relativeResourcePath, httpSessionId) -> {
            try {
                File file = new File(staticResourcesPath, relativeResourcePath);
                if (file.exists() && !file.isDirectory() && file.toPath().toRealPath(new LinkOption[0]).startsWith(staticResourcesPath.getPath())) {
                    return new FileResource(file);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }), "/static/*"));
        for (final ServletRegistration servletRegistration : this.servletRegistrations) {
            for (final String mapping : servletRegistration.getMappings()) {
                LOGGER.info("Registering servlet on url path: " + mapping);
                server.addServletContextListener(new ServletContextListener(){

                    public void contextInitialized(ServletContextEvent sce) {
                        ServletRegistration.Dynamic dynamic = sce.getServletContext().addServlet("teamapps-registered-" + servletRegistration.getServlet().getClass().getSimpleName() + UUID.randomUUID().toString(), servletRegistration.getServlet());
                        dynamic.setAsyncSupported(servletRegistration.isAsyncSupported());
                        dynamic.addMapping(new String[]{mapping});
                    }
                });
            }
        }
        server.addServletContextListener(new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                ServletContext servletContext = sce.getServletContext();
                servletContext.addServlet("ta-sec-links", (Servlet)new ResourceProviderServlet((servletPath, relativeResourcePath, httpSessionId) -> SecureResourceHandler.getInstance().getResource(servletPath, relativeResourcePath, httpSessionId))).addMapping(new String[]{"/TA-SEC-PRVD/*"});
                servletContext.addServlet("public-link-servlet", (Servlet)new ResourceProviderServlet((ResourceProvider)PublicLinkResourceProvider.getInstance())).addMapping(new String[]{"/pl/*"});
            }
        });
        server.start();
        SystemStarts.create().setTimestamp(Instant.now()).setType(Type.START).save();
    }

    public void addClassPathResourceProvider(String basePackage, String prefix) {
        if (!((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        this.addServletRegistration(new ServletRegistration((Servlet)new ResourceProviderServlet((ResourceProvider)new ClassPathResourceProvider(basePackage)), (String)prefix + "*"));
    }

    public void addServletRegistration(ServletRegistration servletRegistration) {
        this.servletRegistrations.add(servletRegistration);
    }

    public void setTeamAppsConfiguration(TeamAppsConfiguration teamAppsConfiguration) {
        this.teamAppsConfiguration = teamAppsConfiguration;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setBasePath(File basePath) {
        this.basePath = basePath;
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            LOGGER.error("Error missing path!");
            return;
        }
        File path = new File(args[0]);
        ApplicationServer applicationServer = new ApplicationServer(path);
        applicationServer.setSessionHandler(new BootstrapSessionHandler());
        applicationServer.start();
        if (User.getCount() == 0) {
            User.create().setFirstName("Super").setLastName("Admin").setLogin("admin").setPassword(SecurePasswordHash.createDefault().createSecureHash("teamapps!")).setUserAccountStatus(UserAccountStatus.SUPER_ADMIN).setLanguages(ValueConverterUtils.compressStringList(Arrays.asList("de", "en", "fr"))).save();
        }
    }
}

