/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.session;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.teamapps.application.api.user.SessionUser;
import org.teamapps.application.server.system.utils.ValueConverterUtils;
import org.teamapps.model.controlcenter.User;
import org.teamapps.ux.session.SessionContext;

public class SessionUserImpl
implements SessionUser {
    private final User user;
    private final SessionContext context;
    private final List<String> rankedLanguages;

    public SessionUserImpl(User user, SessionContext context) {
        this.user = user;
        this.context = context;
        this.rankedLanguages = new ArrayList<String>();
        this.init();
    }

    private void init() {
        List<String> languages = ValueConverterUtils.decompressToStringList(this.user.getLanguages());
        if (languages == null || languages.isEmpty()) {
            languages = new ArrayList<String>();
            languages.add(this.context.getLocale().getLanguage());
        }
        this.rankedLanguages.addAll(languages);
    }

    public int getId() {
        return this.user.getId();
    }

    public String getFirstName() {
        return this.user.getFirstName();
    }

    public String getLastName() {
        return this.user.getLastName();
    }

    public String getName(boolean lastNameFirst) {
        if (lastNameFirst) {
            return this.user.getLastName() + ", " + this.user.getFirstName();
        }
        return this.user.getFirstName() + " " + this.user.getLastName();
    }

    public String getProfilePictureLink() {
        return null;
    }

    public String getLargeProfilePictureLink() {
        return null;
    }

    public SessionContext getSessionContext() {
        return this.context;
    }

    public ULocale getULocale() {
        return null;
    }

    public Locale getLocale() {
        return this.context.getLocale();
    }

    public List<String> getRankedLanguages() {
        return this.rankedLanguages;
    }
}

