package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface ApplicationVersionData extends Entity<ApplicationVersionData> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_DATA = "data";
	final static String FIELD_DATA_ROWS = "dataRows";
	final static String FIELD_DATA_ADDED = "dataAdded";
	final static String FIELD_DATA_ADDED_ROWS = "dataAddedRows";
	final static String FIELD_DATA_REMOVED = "dataRemoved";
	final static String FIELD_DATA_REMOVED_ROWS = "dataRemovedRows";

    static ApplicationVersionData create() {
        return new UdbApplicationVersionData();
    }

    static ApplicationVersionData create(int id) {
        return new UdbApplicationVersionData(id, true);
    }

    static ApplicationVersionData getById(int id) {
        return new UdbApplicationVersionData(id, false);
    }

    static EntityBuilder<ApplicationVersionData> getBuilder() {
        return new UdbApplicationVersionData(0, false);
    }

    Instant getMetaCreationDate();

    ApplicationVersionData setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    ApplicationVersionData setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    ApplicationVersionData setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    ApplicationVersionData setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    ApplicationVersionData setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    ApplicationVersionData setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    ApplicationVersionData setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    ApplicationVersionData setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    ApplicationVersionData setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    ApplicationVersionData setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    ApplicationVersionData setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    ApplicationVersionData setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    ApplicationVersionData setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    ApplicationVersionData setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    ApplicationVersionData setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    ApplicationVersionData setMetaRestoredBy(int value);

    String getData();

    ApplicationVersionData setData(String value);

    int getDataRows();

    ApplicationVersionData setDataRows(int value);

    String getDataAdded();

    ApplicationVersionData setDataAdded(String value);

    int getDataAddedRows();

    ApplicationVersionData setDataAddedRows(int value);

    String getDataRemoved();

    ApplicationVersionData setDataRemoved(String value);

    int getDataRemovedRows();

    ApplicationVersionData setDataRemovedRows(int value);


    static List<ApplicationVersionData> getAll() {
        return UdbApplicationVersionData.getAll();
    }

    static List<ApplicationVersionData> getDeletedRecords() {
        return UdbApplicationVersionData.getDeletedRecords();
    }

    static List<ApplicationVersionData> sort(List<ApplicationVersionData> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbApplicationVersionData.sort(list, sortFieldName, ascending, userContext, path);
    }

    static int getCount() {
        return UdbApplicationVersionData.getCount();
    }

    static ApplicationVersionDataQuery filter() {
        return new UdbApplicationVersionDataQuery();
    }
}

