package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbNewsBoardMessage extends AbstractUdbEntity<NewsBoardMessage> implements NewsBoardMessage {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static BooleanIndex published;
	protected static TextIndex htmlMessage;
	protected static TextIndex language;
	protected static MultiReferenceIndex images;
	protected static MultiReferenceIndex translations;
	protected static SingleReferenceIndex organizationField;
	protected static SingleReferenceIndex organizationUnit;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		published = (BooleanIndex) tableIndex.getColumnIndex(FIELD_PUBLISHED);
		htmlMessage = (TextIndex) tableIndex.getColumnIndex(FIELD_HTML_MESSAGE);
		language = (TextIndex) tableIndex.getColumnIndex(FIELD_LANGUAGE);
		images = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_IMAGES);
		translations = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_TRANSLATIONS);
		organizationField = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ORGANIZATION_FIELD);
		organizationUnit = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ORGANIZATION_UNIT);
    }

    public static List<NewsBoardMessage> getAll() {
        return new EntityBitSetList<>(NewsBoardMessage.getBuilder(), table.getRecordBitSet());
    }

    public static List<NewsBoardMessage> getDeletedRecords() {
        return new EntityBitSetList<>(NewsBoardMessage.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<NewsBoardMessage> sort(List<NewsBoardMessage> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<NewsBoardMessage> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, NewsBoardMessage.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbNewsBoardMessage() {
        super(table);
    }

    public UdbNewsBoardMessage(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public NewsBoardMessage build() {
        return new UdbNewsBoardMessage();
    }

    @Override
    public NewsBoardMessage build(int id) {
        return new UdbNewsBoardMessage(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public NewsBoardMessage setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public NewsBoardMessage setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public NewsBoardMessage setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public NewsBoardMessage setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public NewsBoardMessage setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public NewsBoardMessage setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public NewsBoardMessage setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public NewsBoardMessage setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public NewsBoardMessage setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public NewsBoardMessage setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public NewsBoardMessage setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public NewsBoardMessage setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public NewsBoardMessage setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public NewsBoardMessage setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public NewsBoardMessage setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public NewsBoardMessage setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public boolean getPublished() {
	    return getBooleanValue(published);
	}

	@Override
	public NewsBoardMessage setPublished(boolean value) {
	    setBooleanValue(value, this.published);
		return this;
	}

	@Override
	public boolean isPublished() {
	    return getBooleanValue(published);
	}

	@Override
	public String getHtmlMessage() {
        return getTextValue(htmlMessage);
	}

	@Override
	public NewsBoardMessage setHtmlMessage(String value) {
	    setTextValue(value, this.htmlMessage);
		return this;
	}

	@Override
	public String getLanguage() {
        return getTextValue(language);
	}

	@Override
	public NewsBoardMessage setLanguage(String value) {
	    setTextValue(value, this.language);
		return this;
	}

	@Override
	public List<NewsBoardMessageImage> getImages() {
	    return getMultiReferenceValue(images, NewsBoardMessageImage.getBuilder());
	}

	@Override
	public NewsBoardMessage setImages(List<NewsBoardMessageImage> value) {
		setMultiReferenceValue(value, images);
		return this;
	}

	@Override
	public int getImagesCount() {
	    return getMultiReferenceValueCount(images, NewsBoardMessageImage.getBuilder());
	}

	@Override
	public NewsBoardMessage setImages(NewsBoardMessageImage ... value) {
		setMultiReferenceValue(Arrays.asList(value), images);
		return this;
	}

	@Override
	public BitSet getImagesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(images, NewsBoardMessageImage.getBuilder());
	}

	@Override
	public NewsBoardMessage addImages(List<NewsBoardMessageImage> value) {
		addMultiReferenceValue(value, images);
		return this;
	}

	@Override
	public NewsBoardMessage addImages(NewsBoardMessageImage ... value) {
		addMultiReferenceValue(Arrays.asList(value), images);
		return this;
	}

	@Override
	public NewsBoardMessage removeImages(List<NewsBoardMessageImage> value) {
		removeMultiReferenceValue(value, images);
		return this;
	}

	@Override
	public NewsBoardMessage removeImages(NewsBoardMessageImage ... value) {
		removeMultiReferenceValue(Arrays.asList(value), images);
		return this;
	}

	@Override
	public NewsBoardMessage removeAllImages() {
		removeAllMultiReferenceValue(images);
		return this;
	}

	@Override
	public List<NewsBoardMessageTranslation> getTranslations() {
	    return getMultiReferenceValue(translations, NewsBoardMessageTranslation.getBuilder());
	}

	@Override
	public NewsBoardMessage setTranslations(List<NewsBoardMessageTranslation> value) {
		setMultiReferenceValue(value, translations);
		return this;
	}

	@Override
	public int getTranslationsCount() {
	    return getMultiReferenceValueCount(translations, NewsBoardMessageTranslation.getBuilder());
	}

	@Override
	public NewsBoardMessage setTranslations(NewsBoardMessageTranslation ... value) {
		setMultiReferenceValue(Arrays.asList(value), translations);
		return this;
	}

	@Override
	public BitSet getTranslationsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(translations, NewsBoardMessageTranslation.getBuilder());
	}

	@Override
	public NewsBoardMessage addTranslations(List<NewsBoardMessageTranslation> value) {
		addMultiReferenceValue(value, translations);
		return this;
	}

	@Override
	public NewsBoardMessage addTranslations(NewsBoardMessageTranslation ... value) {
		addMultiReferenceValue(Arrays.asList(value), translations);
		return this;
	}

	@Override
	public NewsBoardMessage removeTranslations(List<NewsBoardMessageTranslation> value) {
		removeMultiReferenceValue(value, translations);
		return this;
	}

	@Override
	public NewsBoardMessage removeTranslations(NewsBoardMessageTranslation ... value) {
		removeMultiReferenceValue(Arrays.asList(value), translations);
		return this;
	}

	@Override
	public NewsBoardMessage removeAllTranslations() {
		removeAllMultiReferenceValue(translations);
		return this;
	}

	@Override
	public OrganizationField getOrganizationField() {
		if (isChanged(organizationField)) {
			return (OrganizationField) getReferenceChangeValue(organizationField);
		} else {
			int id = organizationField.getValue(getId());
			if (id > 0) {
				return OrganizationField.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public NewsBoardMessage setOrganizationField(OrganizationField value) {
		setSingleReferenceValue(organizationField, value, table);
		return this;
	}

	@Override
	public OrganizationUnit getOrganizationUnit() {
		if (isChanged(organizationUnit)) {
			return (OrganizationUnit) getReferenceChangeValue(organizationUnit);
		} else {
			int id = organizationUnit.getValue(getId());
			if (id > 0) {
				return OrganizationUnit.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public NewsBoardMessage setOrganizationUnit(OrganizationUnit value) {
		setSingleReferenceValue(organizationUnit, value, table);
		return this;
	}



    @Override
    public UdbNewsBoardMessage save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



