/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.auth;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.teamapps.application.api.password.SecurePasswordHash;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.auth.AuthenticationHandler;
import org.teamapps.application.server.system.bootstrap.LogoutHandler;
import org.teamapps.application.server.system.bootstrap.SystemRegistry;
import org.teamapps.application.server.system.launcher.ApplicationLauncher;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.server.system.template.Templates;
import org.teamapps.common.format.Color;
import org.teamapps.model.controlcenter.User;
import org.teamapps.model.controlcenter.UserAccessToken;
import org.teamapps.model.controlcenter.UserAccountStatus;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.enumeration.EnumFilterType;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.Button;
import org.teamapps.ux.component.field.CheckBox;
import org.teamapps.ux.component.field.DisplayField;
import org.teamapps.ux.component.field.FieldMessage;
import org.teamapps.ux.component.field.PasswordField;
import org.teamapps.ux.component.field.SpecialKey;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.infiniteitemview.InfiniteItemView;
import org.teamapps.ux.component.infiniteitemview.InfiniteItemViewModel;
import org.teamapps.ux.component.infiniteitemview.ListInfiniteItemViewModel;
import org.teamapps.ux.component.itemview.ItemViewRowJustification;
import org.teamapps.ux.component.itemview.ItemViewVerticalItemAlignment;
import org.teamapps.ux.component.linkbutton.LinkButton;
import org.teamapps.ux.component.panel.ElegantPanel;
import org.teamapps.ux.component.panel.Panel;
import org.teamapps.ux.component.rootpanel.RootPanel;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.session.SessionContext;

public class LoginHandler {
    private final SystemRegistry systemRegistry;
    private final LogoutHandler logoutHandler;
    private List<String> rankedLanguages;

    public LoginHandler(SystemRegistry systemRegistry, LogoutHandler logoutHandler) {
        this.systemRegistry = systemRegistry;
        this.logoutHandler = logoutHandler;
    }

    public LoginHandler(SystemRegistry systemRegistry, LogoutHandler logoutHandler, UserSessionData userSessionData) {
        this.systemRegistry = systemRegistry;
        this.logoutHandler = logoutHandler;
        this.rankedLanguages = userSessionData.getRankedLanguages();
    }

    public void handleNewSession(SessionContext context) {
        if (this.rankedLanguages == null) {
            this.rankedLanguages = new ArrayList<String>();
            this.rankedLanguages.add(context.getLocale().getLanguage());
            this.rankedLanguages.add("en");
        }
        RootPanel rootPanel = context.addRootPanel();
        Map clientParameters = context.getClientInfo().getClientParameters();
        if (clientParameters != null && clientParameters.containsKey("ATOK")) {
            for (AuthenticationHandler authenticationHandler : this.systemRegistry.getAuthenticationHandlers()) {
                User authenticatedUser = authenticationHandler.authenticate(context, clientParameters);
                if (authenticatedUser == null) continue;
                rootPanel.setContent((Component)new Panel());
                this.handleSuccessfulLogin(authenticatedUser, rootPanel, context);
                return;
            }
        }
        this.createLoginView(context, rootPanel);
    }

    public void createLoginView(SessionContext context, RootPanel rootPanel) {
        String backgroundUrl = this.systemRegistry.getSystemConfig().getThemingConfig().getLoginBackgroundUrl();
        context.registerBackgroundImage("login", backgroundUrl, backgroundUrl);
        context.setBackgroundImage("login", 0);
        List<UserAccessToken> secureLoginTokens = this.getSecureLoginTokens();
        if (!secureLoginTokens.isEmpty()) {
            this.showSecureTokenLogin(secureLoginTokens, context, rootPanel);
        } else {
            this.showPasswordLogin(context, rootPanel);
        }
        context.setBackgroundImage("login", 0);
    }

    private User authenticate(String login, String password) {
        if (login == null || login.isBlank() || password == null || password.isBlank()) {
            return null;
        }
        User user = (User)User.filter().login(TextFilter.textEqualsIgnoreCaseFilter((String)login)).userAccountStatus(EnumFilterType.NOT_EQUALS, UserAccountStatus.INACTIVE).executeExpectSingleton();
        if (user != null) {
            String hash = user.getPassword();
            if (SecurePasswordHash.createDefault().verifyPassword(password, hash)) {
                return user;
            }
        }
        return null;
    }

    private void showPasswordLogin(SessionContext context, RootPanel rootPanel) {
        ElegantPanel elegantPanel = new ElegantPanel();
        elegantPanel.setMaxContentWidth(450);
        ResponsiveForm loginForm = new ResponsiveForm(120, 150, 0);
        elegantPanel.setContent((AbstractComponent)loginForm);
        ResponsiveFormLayout formLayout = loginForm.addResponsiveFormLayout(400);
        DisplayField headerField = new DisplayField(false, true);
        headerField.setValue((Object)("<span style='font-size:150%'>" + this.getLocalized("org.teamapps.dictionary.login") + "</span>"));
        DisplayField errorField = new DisplayField(false, true);
        errorField.setValue((Object)"<span style='font-size:120%;color:#961900'>&nbsp;</span>");
        TextField loginField = new TextField();
        PasswordField passwordField = new PasswordField();
        CheckBox stayLoggedIn = new CheckBox(this.getLocalized("org.teamapps.dictionary.keepMeLoggedInthisPCIsSecure"));
        stayLoggedIn.setCheckColor((Color)Color.MATERIAL_BLUE_400);
        loginField.setAutofill(true);
        passwordField.setAutofill(true);
        Button buttonLogin = Button.create((String)this.getLocalized("org.teamapps.dictionary.login"));
        buttonLogin.setColor((Color)Color.WHITE.withAlpha(1.0f));
        LinkButton buttonResetPassword = new LinkButton(this.getLocalized("org.teamapps.dictionary.resetPassword"));
        buttonResetPassword.setCssStyle("color", Color.MATERIAL_GREY_900.toHtmlColorString());
        LinkButton buttonRegister = new LinkButton(this.getLocalized("org.teamapps.dictionary.register"));
        buttonRegister.setCssStyle("color", Color.MATERIAL_GREY_900.toHtmlColorString());
        formLayout.addSection().setDrawHeaderLine(false).setPadding(new Spacing(0, 0, 0, 0)).setCollapsible(false);
        formLayout.addLabelField((AbstractField)headerField).setColSpan(2);
        formLayout.addLabelField((AbstractField)errorField).setColSpan(2);
        formLayout.addLabelAndField(ApplicationIcons.USER, this.getLocalized("org.teamapps.dictionary.userName"), (AbstractField)loginField);
        formLayout.addLabelAndField(ApplicationIcons.KEY, this.getLocalized("org.teamapps.dictionary.password"), (AbstractField)passwordField);
        formLayout.addLabelAndField(null, null, (AbstractField)stayLoggedIn);
        formLayout.addLabelAndComponent(null, null, (Component)buttonLogin);
        formLayout.addLabelAndComponent((Component)buttonResetPassword).field.getRowDefinition().setTopPadding(20);
        formLayout.addLabelAndComponent((Component)buttonRegister).field.getRowDefinition().setTopPadding(10);
        rootPanel.setContent((Component)elegantPanel);
        Runnable onLogin = () -> {
            if (this.checkFieldIsNotEmpty(loginField) && this.checkFieldIsNotEmpty((TextField)passwordField)) {
                User user = this.authenticate((String)loginField.getValue(), (String)passwordField.getValue());
                if (user != null) {
                    if (((Boolean)stayLoggedIn.getValue()).booleanValue()) {
                        this.createSecureLoginToken(user);
                    }
                    this.handleSuccessfulLogin(user, rootPanel, context);
                } else {
                    errorField.setValue((Object)("<span style='font-size:120%;color:#961900'>" + this.getLocalized("org.teamapps.dictionary.wrongUserNameOrPassword") + "</span>"));
                }
            }
        };
        loginField.onSpecialKeyPressed.addListener(key -> {
            if (SpecialKey.ENTER == key) {
                passwordField.focus();
            }
        });
        passwordField.onSpecialKeyPressed.addListener(key -> {
            if (key == SpecialKey.ENTER) {
                onLogin.run();
            }
        });
        buttonLogin.onClicked.addListener(onLogin);
        buttonResetPassword.onClicked.addListener(() -> this.showPasswordResetView());
        buttonRegister.onClicked.addListener(() -> this.showRegistrationView());
    }

    private void showSecureTokenLogin(List<UserAccessToken> loginTokens, SessionContext context, RootPanel rootPanel) {
        ElegantPanel elegantPanel = new ElegantPanel();
        InfiniteItemView itemView = new InfiniteItemView((Template)Templates.LOGIN_TEMPLATE, 170.0f, 170);
        ListInfiniteItemViewModel itemViewModel = new ListInfiniteItemViewModel();
        HashMap accessTokenByUser = new HashMap();
        loginTokens.stream().filter(token -> token.getUser() != null).filter(token -> token.getUser().getUserAccountStatus() != UserAccountStatus.INACTIVE).forEach(token -> accessTokenByUser.put(token.getUser(), token));
        ArrayList users = new ArrayList(accessTokenByUser.keySet());
        users.add(User.create().setFirstName(this.getLocalized("org.teamapps.dictionary.otherUser")));
        itemViewModel.setRecords(users);
        itemView.setModel((InfiniteItemViewModel)itemViewModel);
        itemView.setAutoHeight(true);
        itemView.setRowHeight(175);
        itemView.setVerticalItemAlignment(ItemViewVerticalItemAlignment.CENTER);
        itemView.setItemJustification(ItemViewRowJustification.CENTER);
        itemView.setItemPropertyProvider(PropertyProviders.createSimpleUserPropertyProvider(this.systemRegistry));
        elegantPanel.setContent((AbstractComponent)itemView);
        elegantPanel.setHorizontalContentAlignment(HorizontalElementAlignment.CENTER);
        rootPanel.setContent((Component)elegantPanel);
        itemView.onItemClicked.addListener(data -> {
            User user = (User)data.getRecord();
            if (user.getUserAccountStatus() == UserAccountStatus.INACTIVE) {
                return;
            }
            if (!user.isStored()) {
                this.showPasswordLogin(context, rootPanel);
            } else {
                UserAccessToken userAccessToken = (UserAccessToken)accessTokenByUser.get(user);
                userAccessToken.setLastUsed(Instant.now()).setUserAgentLastUsed(SessionContext.current().getClientInfo().getUserAgent()).save();
                this.handleSuccessfulLogin(user, rootPanel, context);
            }
        });
    }

    private void showRegistrationView() {
    }

    private void showPasswordResetView() {
    }

    private void showAuthCodeView() {
    }

    private void createSecureLoginToken(User user) {
        SessionContext context = SessionContext.current();
        UserAccessToken loginToken = this.getSecureLoginTokens().stream().filter(token -> token.getUser() != null && token.getUser().equals(user)).findAny().orElse(null);
        if (loginToken == null) {
            String token2 = "TOK" + UUID.randomUUID().toString().replace("-", "");
            context.addClientToken(token2);
            UserAccessToken.create().setUser(user).setSecureToken(token2).setUserAgentOnCreation(context.getClientInfo().getUserAgent()).setValid(true).save();
        }
    }

    private List<UserAccessToken> getSecureLoginTokens() {
        ArrayList<UserAccessToken> loginTokens = new ArrayList<UserAccessToken>();
        Set clientTokens = SessionContext.current().getClientInfo().getClientTokens();
        if (clientTokens != null && !clientTokens.isEmpty()) {
            for (String clientToken : clientTokens) {
                UserAccessToken loginToken = (UserAccessToken)UserAccessToken.filter().secureToken(TextFilter.textEqualsFilter((String)clientToken)).executeExpectSingleton();
                if (loginToken == null || !loginToken.getValid()) continue;
                loginTokens.add(loginToken);
            }
        }
        return loginTokens;
    }

    private boolean checkFieldIsNotEmpty(TextField field) {
        String value = (String)field.getValue();
        if (value == null || value.isEmpty()) {
            field.setCustomFieldMessages(Collections.singletonList(new FieldMessage(FieldMessage.Position.BELOW, FieldMessage.Visibility.ON_FOCUS, FieldMessage.Severity.ERROR, this.getLocalized("org.teamapps.dictionary.thisFieldMustNotBeEmpty"))));
            return false;
        }
        field.clearCustomFieldMessages();
        return true;
    }

    private String getLocalized(String value) {
        return this.systemRegistry.getDictionary().getLocalizationValue(value, this.rankedLanguages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSuccessfulLogin(User user, RootPanel rootPanel, SessionContext context) {
        try {
            UserSessionData userSessionData = new UserSessionData(user, context, this.systemRegistry, rootPanel);
            UniversalDB.setUserId((int)userSessionData.getUser().getId());
            if (this.systemRegistry.getSessionRegistryHandler() != null) {
                this.systemRegistry.getSessionRegistryHandler().handleAuthenticatedUser(userSessionData, context);
            }
            new ApplicationLauncher(userSessionData, this.logoutHandler);
        }
        finally {
            UniversalDB.setUserId((int)0);
        }
    }
}

