/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.bootstrap.entity;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.teamapps.application.api.application.entity.EntityUpdate;
import org.teamapps.application.server.system.bootstrap.entity.EntityEventBuilder;
import org.teamapps.universaldb.record.EntityBuilder;
import org.teamapps.universaldb.update.RecordUpdateEvent;
import org.teamapps.ux.session.SessionContext;

public class EntityUpdateEventHandler
extends Thread {
    private final ArrayBlockingQueue<RecordUpdateEvent> updateQueue;
    private final ConcurrentHashMap<Integer, EntityEventBuilder> entityEventBuilderMap = new ConcurrentHashMap();

    public EntityUpdateEventHandler(ArrayBlockingQueue<RecordUpdateEvent> updateQueue) {
        this.updateQueue = updateQueue;
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    RecordUpdateEvent updateEvent;
                    EntityEventBuilder entityEventBuilder;
                    if ((entityEventBuilder = this.entityEventBuilderMap.get((updateEvent = this.updateQueue.take()).getTableId())) == null) {
                        continue;
                    }
                    entityEventBuilder.fireEvent(updateEvent);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public synchronized <ENTITY> void registerEntity(EntityBuilder<ENTITY> entityBuilder, int userId, Consumer<EntityUpdate<ENTITY>> listener) {
        if (SessionContext.currentOrNull() == null) {
            throw new RuntimeException("Error: cannot register entity update listener without session context!");
        }
        if (userId <= 0) {
            throw new RuntimeException("Error: cannot register entity update listener without userId!");
        }
        Consumer<EntityUpdate> consumer = entityEntityUpdate -> {
            if (userId != entityEntityUpdate.getUserId()) {
                listener.accept((EntityUpdate)entityEntityUpdate);
            }
        };
        EntityEventBuilder<ENTITY> entityEventBuilder = this.entityEventBuilderMap.get(entityBuilder.getTableId());
        if (entityEventBuilder == null) {
            entityEventBuilder = new EntityEventBuilder<ENTITY>(entityBuilder);
            this.entityEventBuilderMap.put(entityBuilder.getTableId(), entityEventBuilder);
        } else {
            entityEventBuilder.updateBuilder(entityBuilder);
        }
        entityEventBuilder.getEvent().addListener(consumer);
    }
}

