/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.session;

import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.perspective.PerspectiveBuilder;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.privilege.ApplicationPrivilegeProvider;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.bootstrap.LoadedApplication;
import org.teamapps.application.server.system.bootstrap.SystemRegistry;
import org.teamapps.application.server.system.launcher.MobileApplicationNavigation;
import org.teamapps.application.server.system.launcher.MobileAssembler;
import org.teamapps.application.server.system.privilege.AllowAllPrivilegeProvider;
import org.teamapps.application.server.system.privilege.PrivilegeApplicationKey;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UnmanagedApplicationSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.ManagedApplicationPerspective;
import org.teamapps.model.controlcenter.OrganizationFieldView;
import org.teamapps.model.controlcenter.UserAccountStatus;
import org.teamapps.ux.application.ResponsiveApplication;
import org.teamapps.ux.application.assembler.ApplicationAssembler;
import org.teamapps.ux.application.assembler.DesktopApplicationAssembler;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.session.SessionContext;

public class ManagedApplicationSessionData {
    private final UserSessionData userSessionData;
    private final ManagedApplication managedApplication;
    private final OrganizationFieldView organizationFieldView;
    private final MobileApplicationNavigation mobileNavigation;
    private final ResponsiveApplication responsiveApplication;
    private final SystemRegistry registry;
    private final ApplicationLocalizationProvider mainApplicationLocalizationProvider;
    private ToolbarButton applicationMenuToolbarButton;
    private ToolbarButton perspectiveMenuToolbarButton;

    public ManagedApplicationSessionData(UserSessionData userSessionData, ManagedApplication managedApplication, MobileApplicationNavigation mobileNavigation) {
        this.userSessionData = userSessionData;
        this.managedApplication = managedApplication;
        this.organizationFieldView = managedApplication.getOrganizationField() != null ? OrganizationFieldView.getById(managedApplication.getOrganizationField().getId()) : null;
        this.mobileNavigation = mobileNavigation;
        boolean mobileDevice = SessionContext.current().getClientInfo().isMobileDevice();
        ApplicationLocalizationProvider dictionary = userSessionData.getLocalizationProvider();
        this.responsiveApplication = ResponsiveApplication.createApplication((ApplicationAssembler)(mobileDevice ? new MobileAssembler(mobileNavigation, dictionary) : new DesktopApplicationAssembler()));
        if (!mobileDevice) {
            ToolbarButtonGroup buttonGroup = this.responsiveApplication.addApplicationButtonGroup(new ToolbarButtonGroup());
            this.applicationMenuToolbarButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.WINDOWS, (String)dictionary.getLocalized("org.teamapps.dictionary.perspective", new Object[0]), (String)dictionary.getLocalized("org.teamapps.dictionary.selectApplicationPerspective", new Object[0])));
            this.applicationMenuToolbarButton.setDroDownPanelWidth(350);
            this.applicationMenuToolbarButton.setVisible(false);
            this.perspectiveMenuToolbarButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.WINDOW_EXPLORER, (String)dictionary.getLocalized("org.teamapps.dictionary.views", new Object[0]), (String)dictionary.getLocalized("org.teamapps.dictionary.views", new Object[0])));
            this.perspectiveMenuToolbarButton.setDroDownPanelWidth(350);
            this.perspectiveMenuToolbarButton.setVisible(false);
        }
        this.registry = userSessionData.getRegistry();
        this.mainApplicationLocalizationProvider = userSessionData.getApplicationLocalizationProvider(managedApplication.getMainApplication());
    }

    public PerspectiveSessionData createPerspectiveSessionData(ManagedApplicationPerspective managedApplicationPerspective) {
        LoadedApplication loadedApplication = this.registry.getLoadedApplication(managedApplicationPerspective.getApplicationPerspective().getApplication());
        if (loadedApplication == null) {
            return null;
        }
        ApplicationLocalizationProvider localizationProvider = this.userSessionData.getApplicationLocalizationProvider(managedApplicationPerspective.getApplicationPerspective().getApplication());
        ApplicationPrivilegeProvider privilegeProvider = this.userSessionData.getUserPrivileges().getApplicationPrivilegeProvider(PrivilegeApplicationKey.create(managedApplicationPerspective));
        PerspectiveBuilder perspectiveBuilder = loadedApplication.getPerspectiveBuilder(managedApplicationPerspective.getApplicationPerspective().getName());
        if (this.userSessionData.getUser().getUserAccountStatus() == UserAccountStatus.SUPER_ADMIN) {
            privilegeProvider = new AllowAllPrivilegeProvider();
        }
        return new PerspectiveSessionData(this, this.managedApplication, managedApplicationPerspective, perspectiveBuilder, privilegeProvider, localizationProvider, this.registry.getDocumentConverterSupplier());
    }

    public ApplicationInstanceData getUnmanagedApplicationData() {
        ApplicationPrivilegeProvider privilegeProvider = this.userSessionData.getUserPrivileges().getApplicationPrivilegeProvider(PrivilegeApplicationKey.createUnmanagedKey(this.managedApplication));
        if (this.userSessionData.getUser().getUserAccountStatus() == UserAccountStatus.SUPER_ADMIN) {
            privilegeProvider = new AllowAllPrivilegeProvider();
        }
        return new UnmanagedApplicationSessionData(this.userSessionData, this.managedApplication, this.responsiveApplication, privilegeProvider, this.mainApplicationLocalizationProvider);
    }

    public boolean isUnmanagedApplication() {
        return this.registry.getLoadedApplication(this.managedApplication.getMainApplication()).isUnmanagedPerspectives();
    }

    public ApplicationLocalizationProvider getMainApplicationLocalizationProvider() {
        return this.mainApplicationLocalizationProvider;
    }

    public UserSessionData getUserSessionData() {
        return this.userSessionData;
    }

    public ManagedApplication getManagedApplication() {
        return this.managedApplication;
    }

    public MobileApplicationNavigation getMobileNavigation() {
        return this.mobileNavigation;
    }

    public OrganizationFieldView getOrganizationFieldView() {
        return this.organizationFieldView;
    }

    public LoadedApplication getMainApplication() {
        return this.registry.getLoadedApplication(this.managedApplication.getMainApplication());
    }

    public ResponsiveApplication getResponsiveApplication() {
        return this.responsiveApplication;
    }

    public void setApplicationToolbarMenuComponent(Component component) {
        if (component == null) {
            this.applicationMenuToolbarButton.setVisible(false);
        } else {
            this.applicationMenuToolbarButton.updateDropDownComponent(component);
            this.applicationMenuToolbarButton.setVisible(true);
        }
    }

    public void setPerspectiveToolbarMenuComponent(Component component) {
        if (component == null) {
            this.perspectiveMenuToolbarButton.setVisible(false);
        } else {
            this.perspectiveMenuToolbarButton.updateDropDownComponent(component);
            this.perspectiveMenuToolbarButton.setVisible(true);
        }
    }
}

