package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface LoginQuery extends Query<Login> {

    static LoginQuery create() {
        return new UdbLoginQuery();
    }

    LoginQuery id(Integer... ids);

    LoginQuery id(BitSet ids);

    LoginQuery id(Collection<Integer> ids);

    LoginQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    LoginQuery parseFullTextFilter(String query, String... fieldNames);

	LoginQuery metaDeletionDate(NumericFilter filter);

	LoginQuery orMetaDeletionDate(NumericFilter filter);

	LoginQuery metaDeletedBy(NumericFilter filter);

	LoginQuery orMetaDeletedBy(NumericFilter filter);

	LoginQuery metaRestoreDate(NumericFilter filter);

	LoginQuery orMetaRestoreDate(NumericFilter filter);

	LoginQuery metaRestoredBy(NumericFilter filter);

	LoginQuery orMetaRestoredBy(NumericFilter filter);

	LoginQuery filterUser(UserQuery query);

	LoginQuery user(NumericFilter filter);

	LoginQuery orUser(NumericFilter filter);

	LoginQuery ip(TextFilter filter);

	LoginQuery orIp(TextFilter filter);

	LoginQuery userAgent(TextFilter filter);

	LoginQuery orUserAgent(TextFilter filter);

	LoginQuery mobileDevice(BooleanFilter filter);

	LoginQuery orMobileDevice(BooleanFilter filter);

	LoginQuery screenSize(TextFilter filter);

	LoginQuery orScreenSize(TextFilter filter);

	LoginQuery dateLogin(NumericFilter filter);

	LoginQuery orDateLogin(NumericFilter filter);

	LoginQuery dateLogout(NumericFilter filter);

	LoginQuery orDateLogout(NumericFilter filter);

	LoginQuery activityCount(NumericFilter filter);

	LoginQuery orActivityCount(NumericFilter filter);

	LoginQuery applicationOpenCount(NumericFilter filter);

	LoginQuery orApplicationOpenCount(NumericFilter filter);


    LoginQuery andOr(LoginQuery... queries);

    LoginQuery customFilter(Function<Login, Boolean> customFilter);

}

