package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbChatMessageQuery extends AbstractUdbQuery<ChatMessage> implements ChatMessageQuery {

    public UdbChatMessageQuery() {
        super(UdbChatMessage.table, ChatMessage.getBuilder());
    }

    @Override
    public ChatMessageQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public ChatMessageQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public ChatMessageQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public ChatMessageQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbChatMessage.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public ChatMessageQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbChatMessage.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public ChatMessageQuery metaCreationDate(NumericFilter filter) {
		and(UdbChatMessage.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbChatMessage.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery metaCreatedBy(NumericFilter filter) {
		and(UdbChatMessage.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbChatMessage.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery metaModificationDate(NumericFilter filter) {
		and(UdbChatMessage.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbChatMessage.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery metaModifiedBy(NumericFilter filter) {
		and(UdbChatMessage.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbChatMessage.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery metaDeletionDate(NumericFilter filter) {
		and(UdbChatMessage.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbChatMessage.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery metaDeletedBy(NumericFilter filter) {
		and(UdbChatMessage.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbChatMessage.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery metaRestoreDate(NumericFilter filter) {
		and(UdbChatMessage.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbChatMessage.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery metaRestoredBy(NumericFilter filter) {
		and(UdbChatMessage.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbChatMessage.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery filterChatChannel(ChatChannelQuery query) {
		UdbChatChannelQuery udbQuery = (UdbChatChannelQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbChatMessage.chatChannel, UdbChatChannel.chatMessages);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ChatMessageQuery chatChannel(NumericFilter filter) {
		and(UdbChatMessage.chatChannel.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery orChatChannel(NumericFilter filter) {
		or(UdbChatMessage.chatChannel.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery filterAuthor(UserQuery query) {
		UdbUserQuery udbQuery = (UdbUserQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbChatMessage.author);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ChatMessageQuery author(NumericFilter filter) {
		and(UdbChatMessage.author.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery orAuthor(NumericFilter filter) {
		or(UdbChatMessage.author.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery message(TextFilter filter) {
		and(UdbChatMessage.message.createFilter(filter));
		return this;
	}

	@Override
	public ChatMessageQuery orMessage(TextFilter filter) {
		or(UdbChatMessage.message.createFilter(filter));
		return this;
	}


	@Override
	public UdbChatMessageQuery andOr(ChatMessageQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public ChatMessageQuery customFilter(Function<ChatMessage, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(ChatMessage.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



