package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbMessageQuery extends AbstractUdbQuery<Message> implements MessageQuery {

    public UdbMessageQuery() {
        super(UdbMessage.table, Message.getBuilder());
    }

    @Override
    public MessageQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public MessageQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public MessageQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public MessageQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbMessage.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public MessageQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbMessage.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public MessageQuery metaCreationDate(NumericFilter filter) {
		and(UdbMessage.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbMessage.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery metaCreatedBy(NumericFilter filter) {
		and(UdbMessage.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbMessage.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery metaModificationDate(NumericFilter filter) {
		and(UdbMessage.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbMessage.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery metaModifiedBy(NumericFilter filter) {
		and(UdbMessage.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbMessage.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery metaDeletionDate(NumericFilter filter) {
		and(UdbMessage.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbMessage.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery metaDeletedBy(NumericFilter filter) {
		and(UdbMessage.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbMessage.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery metaRestoreDate(NumericFilter filter) {
		and(UdbMessage.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbMessage.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery metaRestoredBy(NumericFilter filter) {
		and(UdbMessage.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbMessage.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery messageRecipientType(EnumFilterType filterType, MessageRecipientType... enums) {
		and(UdbMessage.messageRecipientType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public MessageQuery orMessageRecipientType(EnumFilterType filterType, MessageRecipientType... enums) {
		or(UdbMessage.messageRecipientType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public MessageQuery filterPrivateRecipients(UserQuery query) {
		UdbUserQuery udbQuery = (UdbUserQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbMessage.privateRecipients, UdbUser.privateMessages);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public MessageQuery privateRecipients(MultiReferenceFilterType type, User ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (User value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbMessage.privateRecipients.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery privateRecipientsCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbMessage.privateRecipients.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery privateRecipients(MultiReferenceFilter filter) {
		and(UdbMessage.privateRecipients.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery orPrivateRecipients(MultiReferenceFilter filter) {
		or(UdbMessage.privateRecipients.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery filterGroupFolder(GroupFolderQuery query) {
		UdbGroupFolderQuery udbQuery = (UdbGroupFolderQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbMessage.groupFolder, UdbGroupFolder.messages);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public MessageQuery groupFolder(NumericFilter filter) {
		and(UdbMessage.groupFolder.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery orGroupFolder(NumericFilter filter) {
		or(UdbMessage.groupFolder.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery filterApplicationFolder(ApplicationFolderQuery query) {
		UdbApplicationFolderQuery udbQuery = (UdbApplicationFolderQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbMessage.applicationFolder, UdbApplicationFolder.messages);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public MessageQuery applicationFolder(NumericFilter filter) {
		and(UdbMessage.applicationFolder.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery orApplicationFolder(NumericFilter filter) {
		or(UdbMessage.applicationFolder.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery subject(TextFilter filter) {
		and(UdbMessage.subject.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery orSubject(TextFilter filter) {
		or(UdbMessage.subject.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery message(TextFilter filter) {
		and(UdbMessage.message.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery orMessage(TextFilter filter) {
		or(UdbMessage.message.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery messageType(EnumFilterType filterType, MessageType... enums) {
		and(UdbMessage.messageType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public MessageQuery orMessageType(EnumFilterType filterType, MessageType... enums) {
		or(UdbMessage.messageType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public MessageQuery file(FileFilter filter) {
		and(UdbMessage.file.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery orFile(FileFilter filter) {
		or(UdbMessage.file.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery filterAppointment(AppointmentQuery query) {
		UdbAppointmentQuery udbQuery = (UdbAppointmentQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbMessage.appointment, UdbAppointment.message);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public MessageQuery appointment(NumericFilter filter) {
		and(UdbMessage.appointment.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery orAppointment(NumericFilter filter) {
		or(UdbMessage.appointment.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery filterAppointmentSeries(AppointmentSeriesQuery query) {
		UdbAppointmentSeriesQuery udbQuery = (UdbAppointmentSeriesQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbMessage.appointmentSeries, UdbAppointmentSeries.message);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public MessageQuery appointmentSeries(NumericFilter filter) {
		and(UdbMessage.appointmentSeries.createFilter(filter));
		return this;
	}

	@Override
	public MessageQuery orAppointmentSeries(NumericFilter filter) {
		or(UdbMessage.appointmentSeries.createFilter(filter));
		return this;
	}


	@Override
	public UdbMessageQuery andOr(MessageQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public MessageQuery customFilter(Function<Message, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(Message.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



