package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbSystemLogQuery extends AbstractUdbQuery<SystemLog> implements SystemLogQuery {

    public UdbSystemLogQuery() {
        super(UdbSystemLog.table, SystemLog.getBuilder());
    }

    @Override
    public SystemLogQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public SystemLogQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public SystemLogQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public SystemLogQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbSystemLog.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public SystemLogQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbSystemLog.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public SystemLogQuery metaCreationDate(NumericFilter filter) {
		and(UdbSystemLog.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbSystemLog.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery metaCreatedBy(NumericFilter filter) {
		and(UdbSystemLog.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbSystemLog.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery metaModificationDate(NumericFilter filter) {
		and(UdbSystemLog.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbSystemLog.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery metaModifiedBy(NumericFilter filter) {
		and(UdbSystemLog.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbSystemLog.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery metaDeletionDate(NumericFilter filter) {
		and(UdbSystemLog.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbSystemLog.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery metaDeletedBy(NumericFilter filter) {
		and(UdbSystemLog.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbSystemLog.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery metaRestoreDate(NumericFilter filter) {
		and(UdbSystemLog.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbSystemLog.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery metaRestoredBy(NumericFilter filter) {
		and(UdbSystemLog.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbSystemLog.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery filterManagedApplication(ManagedApplicationQuery query) {
		UdbManagedApplicationQuery udbQuery = (UdbManagedApplicationQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbSystemLog.managedApplication);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public SystemLogQuery managedApplication(NumericFilter filter) {
		and(UdbSystemLog.managedApplication.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery orManagedApplication(NumericFilter filter) {
		or(UdbSystemLog.managedApplication.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery filterManagedPerspective(ManagedApplicationPerspectiveQuery query) {
		UdbManagedApplicationPerspectiveQuery udbQuery = (UdbManagedApplicationPerspectiveQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbSystemLog.managedPerspective);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public SystemLogQuery managedPerspective(NumericFilter filter) {
		and(UdbSystemLog.managedPerspective.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery orManagedPerspective(NumericFilter filter) {
		or(UdbSystemLog.managedPerspective.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery filterApplication(ApplicationQuery query) {
		UdbApplicationQuery udbQuery = (UdbApplicationQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbSystemLog.application);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public SystemLogQuery application(NumericFilter filter) {
		and(UdbSystemLog.application.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery orApplication(NumericFilter filter) {
		or(UdbSystemLog.application.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery filterApplicationPerspective(ApplicationPerspectiveQuery query) {
		UdbApplicationPerspectiveQuery udbQuery = (UdbApplicationPerspectiveQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbSystemLog.applicationPerspective);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public SystemLogQuery applicationPerspective(NumericFilter filter) {
		and(UdbSystemLog.applicationPerspective.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery orApplicationPerspective(NumericFilter filter) {
		or(UdbSystemLog.applicationPerspective.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery filterApplicationVersion(ApplicationVersionQuery query) {
		UdbApplicationVersionQuery udbQuery = (UdbApplicationVersionQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbSystemLog.applicationVersion);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public SystemLogQuery applicationVersion(NumericFilter filter) {
		and(UdbSystemLog.applicationVersion.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery orApplicationVersion(NumericFilter filter) {
		or(UdbSystemLog.applicationVersion.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery logLevel(EnumFilterType filterType, LogLevel... enums) {
		and(UdbSystemLog.logLevel.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public SystemLogQuery orLogLevel(EnumFilterType filterType, LogLevel... enums) {
		or(UdbSystemLog.logLevel.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public SystemLogQuery thread(TextFilter filter) {
		and(UdbSystemLog.thread.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery orThread(TextFilter filter) {
		or(UdbSystemLog.thread.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery message(TextFilter filter) {
		and(UdbSystemLog.message.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery orMessage(TextFilter filter) {
		or(UdbSystemLog.message.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery details(TextFilter filter) {
		and(UdbSystemLog.details.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery orDetails(TextFilter filter) {
		or(UdbSystemLog.details.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery exceptionClass(TextFilter filter) {
		and(UdbSystemLog.exceptionClass.createFilter(filter));
		return this;
	}

	@Override
	public SystemLogQuery orExceptionClass(TextFilter filter) {
		or(UdbSystemLog.exceptionClass.createFilter(filter));
		return this;
	}


	@Override
	public UdbSystemLogQuery andOr(SystemLogQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public SystemLogQuery customFilter(Function<SystemLog, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(SystemLog.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



