package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbUserAcceptedPolicyQuery extends AbstractUdbQuery<UserAcceptedPolicy> implements UserAcceptedPolicyQuery {

    public UdbUserAcceptedPolicyQuery() {
        super(UdbUserAcceptedPolicy.table, UserAcceptedPolicy.getBuilder());
    }

    @Override
    public UserAcceptedPolicyQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public UserAcceptedPolicyQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public UserAcceptedPolicyQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public UserAcceptedPolicyQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbUserAcceptedPolicy.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbUserAcceptedPolicy.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery metaCreationDate(NumericFilter filter) {
		and(UdbUserAcceptedPolicy.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbUserAcceptedPolicy.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery metaCreatedBy(NumericFilter filter) {
		and(UdbUserAcceptedPolicy.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbUserAcceptedPolicy.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery metaModificationDate(NumericFilter filter) {
		and(UdbUserAcceptedPolicy.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbUserAcceptedPolicy.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery metaModifiedBy(NumericFilter filter) {
		and(UdbUserAcceptedPolicy.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbUserAcceptedPolicy.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery metaDeletionDate(NumericFilter filter) {
		and(UdbUserAcceptedPolicy.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbUserAcceptedPolicy.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery metaDeletedBy(NumericFilter filter) {
		and(UdbUserAcceptedPolicy.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbUserAcceptedPolicy.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery metaRestoreDate(NumericFilter filter) {
		and(UdbUserAcceptedPolicy.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbUserAcceptedPolicy.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery metaRestoredBy(NumericFilter filter) {
		and(UdbUserAcceptedPolicy.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbUserAcceptedPolicy.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery lastAcceptedPrivacyPolicy(NumericFilter filter) {
		and(UdbUserAcceptedPolicy.lastAcceptedPrivacyPolicy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery orLastAcceptedPrivacyPolicy(NumericFilter filter) {
		or(UdbUserAcceptedPolicy.lastAcceptedPrivacyPolicy.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery lastAcceptedTermsOfUse(NumericFilter filter) {
		and(UdbUserAcceptedPolicy.lastAcceptedTermsOfUse.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery orLastAcceptedTermsOfUse(NumericFilter filter) {
		or(UdbUserAcceptedPolicy.lastAcceptedTermsOfUse.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery filterAcceptEntries(UserAcceptedPolicyEntriesQuery query) {
		UdbUserAcceptedPolicyEntriesQuery udbQuery = (UdbUserAcceptedPolicyEntriesQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUserAcceptedPolicy.acceptEntries);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery acceptEntries(MultiReferenceFilterType type, UserAcceptedPolicyEntries ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (UserAcceptedPolicyEntries value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbUserAcceptedPolicy.acceptEntries.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery acceptEntriesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbUserAcceptedPolicy.acceptEntries.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery acceptEntries(MultiReferenceFilter filter) {
		and(UdbUserAcceptedPolicy.acceptEntries.createFilter(filter));
		return this;
	}

	@Override
	public UserAcceptedPolicyQuery orAcceptEntries(MultiReferenceFilter filter) {
		or(UdbUserAcceptedPolicy.acceptEntries.createFilter(filter));
		return this;
	}


	@Override
	public UdbUserAcceptedPolicyQuery andOr(UserAcceptedPolicyQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public UserAcceptedPolicyQuery customFilter(Function<UserAcceptedPolicy, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(UserAcceptedPolicy.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



