/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter;

import java.util.List;
import org.teamapps.application.api.privilege.ApplicationPrivilegeBuilder;
import org.teamapps.application.api.privilege.ApplicationRole;
import org.teamapps.application.api.privilege.ApplicationRoleBuilder;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.api.privilege.SimplePrivilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.controlcenter.organization.OrganizationChartPerspective;
import org.teamapps.icons.Icon;
import org.teamapps.icons.composite.CompositeIcon;

public class Privileges {
    private static final ApplicationPrivilegeBuilder PRIVILEGE_BUILDER = new ApplicationPrivilegeBuilder();
    private static final ApplicationRoleBuilder ROLE_BUILDER = new ApplicationRoleBuilder();
    public static final SimplePrivilege LAUNCH_APPLICATION = Privileges.PRIVILEGE_BUILDER.LAUNCH_APPLICATION;
    public static final SimplePrivilege LAUNCH_PERSPECTIVE_APPLICATION_GROUPS = PRIVILEGE_BUILDER.addSimplePrivilege("launchPerspectiveApplicationGroups", ApplicationIcons.WINDOWS, "applicationGroups.launch", "applicationGroups.desc");
    public static final SimplePrivilege LAUNCH_PERSPECTIVE_APPLICATION_PROVISIONING = PRIVILEGE_BUILDER.addSimplePrivilege("launchPerspectiveApplicationProvisioning", ApplicationIcons.INSTALL, "applicationProvisioning.launch", "applicationProvisioning.desc");
    public static final SimplePrivilege LAUNCH_PERSPECTIVE_APPLICATIONS = PRIVILEGE_BUILDER.addSimplePrivilege("launchPerspectiveApplications", ApplicationIcons.BOX_SOFTWARE, "applications.launch", "applications.desc");
    public static final SimplePrivilege LAUNCH_PERSPECTIVE_APP_LOCAL_ADMINISTRATION = PRIVILEGE_BUILDER.addSimplePrivilege("launchPerspectiveAppLocalAdministration", ApplicationIcons.WINDOW_KEY, "appLocalAdministration.launch", "appLocalAdministration.desc");
    public static final SimplePrivilege LAUNCH_PERSPECTIVE_APPLICATION_CONFIGURATION = PRIVILEGE_BUILDER.addSimplePrivilege("launchPerspectiveApplicationConfiguration", ApplicationIcons.CODE_LINE, "applicationConfiguration.launch", "applicationConfiguration.desc");
    public static final SimplePrivilege LAUNCH_PERSPECTIVE_MACHINE_TRANSLATION = PRIVILEGE_BUILDER.addSimplePrivilege("launchPerspectiveMachineTranslation", ApplicationIcons.EARTH_LINK, "machineTranslation.launch", "machineTranslation.desc");
    public static final SimplePrivilege LAUNCH_PERSPECTIVE_TRANSLATIONS = PRIVILEGE_BUILDER.addSimplePrivilege("launchPerspectiveTranslations", ApplicationIcons.SPELL_CHECK, "translations.launch", "translations.desc");
    public static final SimplePrivilege LAUNCH_PERSPECTIVE_MONITORING = PRIVILEGE_BUILDER.addSimplePrivilege("launchPerspectiveMonitoring", ApplicationIcons.CHART_LINE, "monitoring.launch", "monitoring.desc");
    public static final OrganizationalPrivilegeGroup USERS_PERSPECTIVE = PRIVILEGE_BUILDER.addDefaultOrganizationalPrivilegeGroup("usersPerspective", ApplicationIcons.USERS_CROWD, "users.title", "users.desc");
    public static final OrganizationalPrivilegeGroup USER_ROLE_ASSIGNMENT_PERSPECTIVE = PRIVILEGE_BUILDER.addDefaultOrganizationalPrivilegeGroup("userRoleAssignmentPerspective", ApplicationIcons.USERS_THREE_RELATION, "userRoleAssignment.title", "userRoleAssignment.desc");
    public static final OrganizationalPrivilegeGroup ORGANIZATION_UNIT_PERSPECTIVE = PRIVILEGE_BUILDER.addDefaultOrganizationalPrivilegeGroup("organizationUnitPerspective", ApplicationIcons.ELEMENTS_HIERARCHY, "organization.title", "organization.desc");
    public static final StandardPrivilegeGroup ORGANIZATION_UNIT_TYPE_PERSPECTIVE = PRIVILEGE_BUILDER.addDefaultStandardPrivilegeGroup("organizationUnitTypePerspective", ApplicationIcons.ELEMENTS_CASCADE, "organizationUnitType.title", "organizationUnitType.desc");
    public static final StandardPrivilegeGroup ORGANIZATION_FIELD_PERSPECTIVE = PRIVILEGE_BUILDER.addDefaultStandardPrivilegeGroup("organizationFieldPerspective", ApplicationIcons.ELEMENTS_TREE, "organizationField.title", "organizationField.desc");
    public static final StandardPrivilegeGroup ROLES_PERSPECTIVE = PRIVILEGE_BUILDER.addDefaultStandardPrivilegeGroup("rolesPerspective", ApplicationIcons.WORKER, "roles.title", "roles.desc");
    public static final OrganizationalPrivilegeGroup ACCESS_CONTROL_PERSPECTIVE = PRIVILEGE_BUILDER.addDefaultOrganizationalPrivilegeGroup("accessControlPerspective", ApplicationIcons.KEYS, "accessControl.title", "accessControl.desc");
    public static final OrganizationalPrivilegeGroup ACCESS_CONTROL_APP_ROLE_PERSPECTIVE = PRIVILEGE_BUILDER.addDefaultOrganizationalPrivilegeGroup("accessControlAppRolePerspective", (Icon)CompositeIcon.of((Icon)ApplicationIcons.KEY, (Icon)ApplicationIcons.WORKER), "accessControlAppRole.title", "accessControlAppRole.desc");
    public static final StandardPrivilegeGroup APPLICATION_UPDATES_PERSPECTIVE = PRIVILEGE_BUILDER.addStandardPrivilegeGroup("applicationUpdatesPerspective", ApplicationIcons.BOX_SOFTWARE, "applicationUpdates.title", "applicationUpdates.desc", new Privilege[]{Privilege.READ, Privilege.EXECUTE, Privilege.RESTORE});
    public static final StandardPrivilegeGroup APPLICATION_PROVISIONING_PERSPECTIVE = PRIVILEGE_BUILDER.addDefaultStandardPrivilegeGroup("applicationProvisioning", ApplicationIcons.INSTALL, "applicationProvisioning.title", "applicationProvisioning.desc");
    public static final StandardPrivilegeGroup SYSTEM_LOG_PERSPECTIVE = PRIVILEGE_BUILDER.addStandardPrivilegeGroup("systemLogPerspective", ApplicationIcons.CONSOLE, "systemLog.title", "systemLog.desc", new Privilege[]{Privilege.READ});
    public static final StandardPrivilegeGroup DATABASE_PERSPECTIVE = PRIVILEGE_BUILDER.addStandardPrivilegeGroup("databasePerspective", ApplicationIcons.DATA_TABLE, "database.launch", "database.desc", new Privilege[]{Privilege.READ, Privilege.SHOW_RECYCLE_BIN});
    public static final StandardPrivilegeGroup CLUSTER_PERSPECTIVE = PRIVILEGE_BUILDER.addStandardPrivilegeGroup("clusterPerspective", ApplicationIcons.RACK_SERVER_NETWORK, "cluster.launch", "cluster.desc", new Privilege[]{Privilege.READ, Privilege.CREATE, Privilege.UPDATE, Privilege.DELETE});
    public static final OrganizationalPrivilegeGroup ORGANIZATION_CHART_PERSPECTIVE = PRIVILEGE_BUILDER.addOrganizationalPrivilegeGroup("organizationChartPerspective", ApplicationIcons.PIECES, "organizationChart.title", "organizationChart.desc", new Privilege[]{OrganizationChartPerspective.SHOW_UPWARDS_LEADERS, OrganizationChartPerspective.SHOW_UPWARDS_ALL_ROLES, OrganizationChartPerspective.SHOW_DOWNWARDS_LEADERS, OrganizationChartPerspective.SHOW_DOWNWARDS_ALL_ROLES});
    public static final ApplicationRole APPLICATION_ADMINISTRATOR_ROLE = ROLE_BUILDER.addRole("applicationAdministratorRole", ApplicationIcons.PILOT, "application.roles.applicationAdministrator", "application.roles.applicationAdministrator.desc", new PrivilegeGroup[]{LAUNCH_APPLICATION, LAUNCH_PERSPECTIVE_APP_LOCAL_ADMINISTRATION, LAUNCH_PERSPECTIVE_TRANSLATIONS, USER_ROLE_ASSIGNMENT_PERSPECTIVE.createCopyWithPrivileges(new Privilege[]{Privilege.READ, Privilege.CREATE, Privilege.UPDATE, Privilege.DELETE, Privilege.SHOW_MODIFICATION_HISTORY}), ROLES_PERSPECTIVE.createCopyWithPrivileges(new Privilege[]{Privilege.READ, Privilege.CREATE, Privilege.UPDATE, Privilege.DELETE, Privilege.SHOW_MODIFICATION_HISTORY}), ACCESS_CONTROL_PERSPECTIVE.createCopyWithPrivileges(new Privilege[]{Privilege.READ, Privilege.CREATE, Privilege.UPDATE, Privilege.DELETE, Privilege.SHOW_MODIFICATION_HISTORY}), ACCESS_CONTROL_APP_ROLE_PERSPECTIVE.createCopyWithPrivileges(new Privilege[]{Privilege.READ, Privilege.CREATE, Privilege.UPDATE, Privilege.DELETE, Privilege.SHOW_MODIFICATION_HISTORY}), APPLICATION_UPDATES_PERSPECTIVE.createCopyWithPrivileges(new Privilege[]{Privilege.READ, Privilege.EXECUTE, Privilege.RESTORE}), SYSTEM_LOG_PERSPECTIVE, LAUNCH_PERSPECTIVE_APPLICATION_CONFIGURATION, DATABASE_PERSPECTIVE.createCopyWithPrivileges(new Privilege[]{Privilege.READ, Privilege.SHOW_RECYCLE_BIN})});
    public static final ApplicationRole APPLICATION_DEVELOPER_ROLE = ROLE_BUILDER.addRole("applicationDeveloperRole", ApplicationIcons.TEXT_BINARY, "application.roles.applicationDeveloper", "application.roles.applicationDeveloper.desc", new PrivilegeGroup[]{LAUNCH_PERSPECTIVE_APP_LOCAL_ADMINISTRATION, LAUNCH_PERSPECTIVE_TRANSLATIONS, USER_ROLE_ASSIGNMENT_PERSPECTIVE.createCopyWithPrivileges(new Privilege[]{Privilege.READ}), ROLES_PERSPECTIVE.createCopyWithPrivileges(new Privilege[]{Privilege.READ}), ACCESS_CONTROL_PERSPECTIVE.createCopyWithPrivileges(new Privilege[]{Privilege.READ}), ACCESS_CONTROL_APP_ROLE_PERSPECTIVE.createCopyWithPrivileges(new Privilege[]{Privilege.READ}), APPLICATION_UPDATES_PERSPECTIVE.createCopyWithPrivileges(new Privilege[]{Privilege.READ, Privilege.EXECUTE, Privilege.RESTORE}), SYSTEM_LOG_PERSPECTIVE, LAUNCH_PERSPECTIVE_APPLICATION_CONFIGURATION, DATABASE_PERSPECTIVE.createCopyWithPrivileges(new Privilege[]{Privilege.READ, Privilege.SHOW_RECYCLE_BIN})});

    public static List<ApplicationRole> getRoles() {
        return ROLE_BUILDER.getRoles();
    }

    public static List<PrivilegeGroup> getPrivileges() {
        return PRIVILEGE_BUILDER.getPrivileges();
    }
}

