/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.server.controlcenter.Privileges;
import org.teamapps.application.server.controlcenter.organization.OrgChartNode;
import org.teamapps.application.server.controlcenter.organization.OrgChartRow;
import org.teamapps.application.server.controlcenter.organization.OrganizationChartPerspective;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.model.controlcenter.OrganizationField;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.model.controlcenter.UserRoleAssignment;

public class OrgChartData {
    private Set<OrganizationUnit> orgChartUnits = new HashSet<OrganizationUnit>();
    private Set<OrganizationUnit> orgChartUnitsWithAllRoles = new HashSet<OrganizationUnit>();
    private List<OrganizationUnit> rootUnits;
    private List<OrgChartNode> orgChartNodes = new ArrayList<OrgChartNode>();
    private List<OrgChartRow> orgChartRows = new ArrayList<OrgChartRow>();

    public OrgChartData(OrganizationField organizationField, ApplicationInstanceData applicationInstanceData) {
        List upwardLeaderUnits = applicationInstanceData.getAllowedUnits(Privileges.ORGANIZATION_CHART_PERSPECTIVE, OrganizationChartPerspective.SHOW_UPWARDS_LEADERS);
        List upwardAllRoleUnits = applicationInstanceData.getAllowedUnits(Privileges.ORGANIZATION_CHART_PERSPECTIVE, OrganizationChartPerspective.SHOW_UPWARDS_ALL_ROLES);
        List downwardLeaderUnits = applicationInstanceData.getAllowedUnits(Privileges.ORGANIZATION_CHART_PERSPECTIVE, OrganizationChartPerspective.SHOW_DOWNWARDS_LEADERS);
        List downwardAllRoleUnits = applicationInstanceData.getAllowedUnits(Privileges.ORGANIZATION_CHART_PERSPECTIVE, OrganizationChartPerspective.SHOW_DOWNWARDS_ALL_ROLES);
        Set<OrganizationUnit> upwardUnits = OrganizationUtils.convertViewSet(upwardLeaderUnits, upwardAllRoleUnits);
        Set<OrganizationUnit> upwardAllRolesUnits = OrganizationUtils.convertViewSet((Collection<OrganizationUnitView>)upwardAllRoleUnits);
        List<OrganizationUnit> upwardRootNodes = OrganizationUtils.getRootNodes(upwardUnits);
        for (OrganizationUnit unit : upwardRootNodes) {
            List<OrganizationUnit> upwardPath = OrganizationUtils.getPath(unit);
            this.orgChartUnits.addAll(upwardPath);
            if (!upwardAllRolesUnits.contains(unit)) continue;
            this.orgChartUnitsWithAllRoles.addAll(upwardPath);
        }
        this.orgChartUnits.addAll(OrganizationUtils.convertViewList(downwardLeaderUnits));
        this.orgChartUnits.addAll(OrganizationUtils.convertViewList(downwardAllRoleUnits));
        this.orgChartUnitsWithAllRoles.addAll(OrganizationUtils.convertViewList(downwardAllRoleUnits));
        this.rootUnits = OrganizationUtils.getRootNodes(this.orgChartUnits);
        Map<OrganizationUnit, List<UserRoleAssignment>> roleAssignmentsByOrganizationUnit = UserRoleAssignment.getAll().stream().filter(userRoleAssignment -> organizationField.equals(userRoleAssignment.getRole().getOrganizationField())).filter(userRoleAssignment -> this.orgChartUnits.contains(userRoleAssignment.getOrganizationUnit())).filter(userRoleAssignment -> userRoleAssignment.getUser() != null).collect(Collectors.groupingBy(UserRoleAssignment::getOrganizationUnit));
        for (OrganizationUnit rootUnit : this.rootUnits) {
            this.traverseOrgTree(rootUnit, roleAssignmentsByOrganizationUnit, applicationInstanceData);
        }
    }

    private void traverseOrgTree(OrganizationUnit unit, Map<OrganizationUnit, List<UserRoleAssignment>> roleAssignmentsByOrganizationUnit, ApplicationInstanceData applicationInstanceData) {
        List<UserRoleAssignment> userRoleAssignments = roleAssignmentsByOrganizationUnit.get(unit);
        OrgChartNode orgChartNode = new OrgChartNode(unit, userRoleAssignments, this.orgChartUnitsWithAllRoles.contains(unit), applicationInstanceData);
        this.orgChartNodes.add(orgChartNode);
        List<OrgChartRow> rows = OrgChartRow.createRows(orgChartNode);
        this.orgChartRows.addAll(rows);
        for (OrganizationUnit childUnit : unit.getChildren()) {
            if (!this.orgChartUnits.contains(childUnit)) continue;
            this.traverseOrgTree(childUnit, roleAssignmentsByOrganizationUnit, applicationInstanceData);
        }
    }

    public List<OrgChartNode> getOrgChartNodes() {
        return this.orgChartNodes;
    }

    public List<OrgChartRow> getOrgChartRows() {
        return this.orgChartRows;
    }
}

