/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.organization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.model.controlcenter.Role;
import org.teamapps.model.controlcenter.RoleType;
import org.teamapps.model.controlcenter.User;
import org.teamapps.model.controlcenter.UserRoleAssignment;

public class OrgChartNode {
    private final OrganizationUnit organizationUnit;
    private UserRoleAssignment userRoleAssignment;
    private String userFullName;
    private String roleName;
    private String unitNameWithPrefix;
    private String unitTypeName;
    private String searchMatchingString;
    private String userImage;
    private Icon orgUnitIcon;
    private RoleType roleType;
    private List<OrgChartNode> subNodes = new ArrayList<OrgChartNode>();

    public OrgChartNode(OrganizationUnit organizationUnit, List<UserRoleAssignment> roleAssignments, boolean allRoles, ApplicationInstanceData applicationInstanceData) {
        this.organizationUnit = organizationUnit;
        this.init(roleAssignments, allRoles, applicationInstanceData);
    }

    protected OrgChartNode(OrganizationUnit organizationUnit, UserRoleAssignment assignment, String fullName, String image, String role, RoleType type, String search) {
        this.organizationUnit = organizationUnit;
        this.userRoleAssignment = assignment;
        this.userFullName = fullName;
        this.userImage = image;
        this.roleName = role;
        this.roleType = type != null ? type : RoleType.OTHER;
        this.searchMatchingString = search;
    }

    private void init(List<UserRoleAssignment> roleAssignments, boolean allRoles, ApplicationInstanceData applicationInstanceData) {
        PropertyProvider<OrganizationUnit> organizationUnitPropertyProvider = PropertyProviders.creatOrganizationUnitPropertyProvider(applicationInstanceData);
        PropertyProvider<Role> rolePropertyProvider = PropertyProviders.createRolePropertyProvider(applicationInstanceData);
        PropertyProvider<User> userPropertyProvider = PropertyProviders.createUserPropertyProvider(applicationInstanceData);
        List sortedAssignments = roleAssignments == null ? Collections.emptyList() : roleAssignments.stream().sorted(this::compareRoleTypes).collect(Collectors.toList());
        Map orgUnitProperties = organizationUnitPropertyProvider.getValues((Object)this.organizationUnit, null);
        this.unitNameWithPrefix = (String)orgUnitProperties.get("caption");
        this.unitTypeName = (String)orgUnitProperties.get("description");
        this.orgUnitIcon = (Icon)orgUnitProperties.get("icon");
        UserRoleAssignment assignment = sortedAssignments.isEmpty() ? null : (UserRoleAssignment)sortedAssignments.get(0);
        int otherAssignmentIndex = 1;
        if (assignment != null && assignment.getRole().getRoleType() == RoleType.LEADER) {
            Map userProperties = userPropertyProvider.getValues((Object)assignment.getUser(), null);
            this.userFullName = (String)userProperties.get("caption");
            this.userImage = (String)userProperties.get("image");
            Map roleProperties = rolePropertyProvider.getValues((Object)assignment.getRole(), null);
            this.roleName = (String)roleProperties.get("caption");
            this.roleType = assignment.getRole().getRoleType();
            this.userRoleAssignment = assignment;
            this.searchMatchingString = (this.unitNameWithPrefix + " " + this.unitTypeName + " " + this.userFullName + " " + this.roleName).toLowerCase();
        } else {
            otherAssignmentIndex = 0;
            this.searchMatchingString = (this.unitNameWithPrefix + " " + this.unitTypeName).toLowerCase();
        }
        if (!allRoles) {
            return;
        }
        for (int i = otherAssignmentIndex; i < sortedAssignments.size(); ++i) {
            assignment = (UserRoleAssignment)sortedAssignments.get(i);
            Map userProperties = userPropertyProvider.getValues((Object)assignment.getUser(), null);
            String fullName = (String)userProperties.get("caption");
            String image = (String)userProperties.get("image");
            Map roleProperties = rolePropertyProvider.getValues((Object)assignment.getRole(), null);
            String role = (String)roleProperties.get("caption");
            RoleType type = assignment.getRole().getRoleType();
            String search = (this.unitNameWithPrefix + " " + this.unitTypeName + " " + fullName + " " + role).toLowerCase();
            this.subNodes.add(new OrgChartNode(this.organizationUnit, assignment, fullName, image, role, type, search));
        }
    }

    public List<OrgChartNode> getNodesByType(RoleType ... types) {
        HashSet<RoleType> roleTypes = new HashSet<RoleType>(Arrays.asList(types));
        List<OrgChartNode> orgChartNodes = this.subNodes.stream().filter(node -> roleTypes.contains((Object)node.getRoleType())).collect(Collectors.toList());
        if (roleTypes.contains((Object)RoleType.LEADER)) {
            ArrayList<OrgChartNode> leaderNodes = new ArrayList<OrgChartNode>();
            leaderNodes.add(this);
            leaderNodes.addAll(orgChartNodes);
            return leaderNodes;
        }
        return orgChartNodes;
    }

    public boolean matches(String query) {
        if (query == null || query.isBlank()) {
            return true;
        }
        return this.searchMatchingString.contains(query.toLowerCase());
    }

    public OrganizationUnit getOrganizationUnit() {
        return this.organizationUnit;
    }

    public UserRoleAssignment getUserRoleAssignment() {
        return this.userRoleAssignment;
    }

    public String getUserFullName() {
        return this.userFullName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getUnitNameWithPrefix() {
        return this.unitNameWithPrefix;
    }

    public String getUnitTypeName() {
        return this.unitTypeName;
    }

    public String getSearchMatchingString() {
        return this.searchMatchingString;
    }

    public String getUserImage() {
        return this.userImage;
    }

    public Icon getOrgUnitIcon() {
        return this.orgUnitIcon;
    }

    public RoleType getRoleType() {
        return this.roleType;
    }

    public List<OrgChartNode> getSubNodes() {
        return this.subNodes;
    }

    private int compareRoleTypes(UserRoleAssignment assignment1, UserRoleAssignment assignment2) {
        int ordinal2;
        RoleType type1 = assignment1.getRole().getRoleType();
        RoleType type2 = assignment2.getRole().getRoleType();
        int ordinal1 = type1 != null ? type1.ordinal() : RoleType.OTHER.ordinal();
        int n = ordinal2 = type2 != null ? type2.ordinal() : RoleType.OTHER.ordinal();
        if (type1 == RoleType.LEADER && assignment1.isMainResponsible()) {
            ordinal1 = -1;
        }
        if (type2 == RoleType.LEADER && assignment2.isMainResponsible()) {
            ordinal2 = -1;
        }
        if (ordinal1 == ordinal2 && assignment1.getUser().getProfilePictureLength() == 0) {
            ++ordinal1;
        }
        return Integer.compare(ordinal1, ordinal2);
    }
}

