/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.messaging.newsboard.views;

import java.util.HashMap;
import java.util.List;
import org.teamapps.application.api.application.AbstractApplicationView;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.tools.EntityListModelBuilder;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.formatter.FileSizeFormatter;
import org.teamapps.model.controlcenter.NewsBoardMessageImage;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.session.SessionContext;

public class ImageListView
extends AbstractApplicationView {
    private Table<NewsBoardMessageImage> table;
    private final EntityListModelBuilder<NewsBoardMessageImage> modelBuilder;

    public ImageListView(ApplicationInstanceData applicationInstanceData) {
        super(applicationInstanceData);
        this.modelBuilder = new EntityListModelBuilder(applicationInstanceData);
        SessionContext context = SessionContext.current();
        PropertyProvider propertyProvider = (newsBoardMessageImage, collection) -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("image", context.createFileLink(newsBoardMessageImage.getThumbnail().retrieveFile()));
            map.put("caption", newsBoardMessageImage.getFileName());
            map.put("description", FileSizeFormatter.humanReadableByteCount((long)newsBoardMessageImage.getFile().getSize(), (boolean)false, (int)2));
            return map;
        };
        this.table = this.modelBuilder.createTemplateFieldTableList((Template)BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES, propertyProvider, 52);
    }

    public Component getComponent() {
        return this.table;
    }

    public NewsBoardMessageImage getSelectedImage() {
        return (NewsBoardMessageImage)this.modelBuilder.getSelectedRecord();
    }

    public void removeSelectedImage() {
        this.modelBuilder.removeRecord((Object)((NewsBoardMessageImage)this.modelBuilder.getSelectedRecord()));
    }

    public void setImages(List<NewsBoardMessageImage> images) {
        this.modelBuilder.setRecords(images);
    }

    public void addImages(List<NewsBoardMessageImage> images) {
        this.modelBuilder.addRecords(images);
    }
}

