/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.bootstrap.installer;

import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.application.api.application.BaseApplicationBuilder;
import org.teamapps.application.server.system.bootstrap.ApplicationInfo;
import org.teamapps.application.server.system.bootstrap.ApplicationInfoDataElement;
import org.teamapps.application.server.system.bootstrap.installer.ApplicationInstallationPhase;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationVersion;
import org.teamapps.model.controlcenter.ApplicationVersionData;

public class ApplicationArtifactInstallationPhase
implements ApplicationInstallationPhase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void checkApplication(ApplicationInfo applicationInfo) {
        try {
            BaseApplicationBuilder baseApplicationBuilder;
            String applicationName;
            if (!applicationInfo.getErrors().isEmpty()) {
                return;
            }
            if (applicationInfo.getApplicationJar() != null) {
                String binaryHash = applicationInfo.getBinaryHash();
                applicationInfo.setBinaryHash(binaryHash);
            }
            if ((applicationName = (baseApplicationBuilder = applicationInfo.getBaseApplicationBuilder()).getApplicationName()) == null || applicationName.isEmpty() || applicationName.contains(" ") || applicationName.contains(".")) {
                applicationInfo.addError("Invalid application name: " + applicationName);
                return;
            }
            org.teamapps.application.api.versioning.ApplicationVersion applicationVersion = baseApplicationBuilder.getApplicationVersion();
            if (applicationVersion == null) {
                applicationInfo.addError("Missing application version");
                return;
            }
            if (baseApplicationBuilder.getApplicationTitleKey() == null) {
                applicationInfo.addError("Missing application title");
                return;
            }
            String versionString = applicationVersion.getVersion();
            applicationInfo.setName(applicationName);
            applicationInfo.setReleaseNotes(applicationInfo.getBaseApplicationBuilder().getReleaseNotes());
            applicationInfo.setVersion(versionString);
            Application application = applicationInfo.getApplication();
            if (application != null) {
                for (ApplicationVersion version : application.getVersions()) {
                    String installedVersion = version.getVersion();
                    org.teamapps.application.api.versioning.ApplicationVersion installedVersion2 = new org.teamapps.application.api.versioning.ApplicationVersion(installedVersion);
                    if (installedVersion.equals(versionString)) {
                        applicationInfo.addWarning("This version is already installed: " + versionString);
                        applicationInfo.setApplicationVersion(version);
                    }
                    if (installedVersion2.compareTo(applicationVersion) <= 0) continue;
                    applicationInfo.addWarning("A higher version is already installed! This version: " + versionString + ", installed Version: " + installedVersion);
                }
            }
        }
        catch (Exception e) {
            applicationInfo.addError("Error checking artifact:" + e.getMessage());
            LOGGER.error("Error checking artifact:", (Throwable)e);
        }
    }

    @Override
    public void installApplication(ApplicationInfo applicationInfo) {
        Application application = applicationInfo.getApplication();
        BaseApplicationBuilder baseApplicationBuilder = applicationInfo.getBaseApplicationBuilder();
        if (application == null) {
            application = Application.create().setName(applicationInfo.getName());
        }
        application.setIcon(IconUtils.encodeNoStyle((Icon)baseApplicationBuilder.getApplicationIcon())).setTitleKey(baseApplicationBuilder.getApplicationTitleKey()).setDescriptionKey(baseApplicationBuilder.getApplicationDescriptionKey()).setUnmanagedApplication(applicationInfo.isUnmanagedPerspectives()).setDarkTheme(baseApplicationBuilder.isDarkTheme()).save();
        ApplicationVersion applicationVersion = (ApplicationVersion)ApplicationVersion.create().setApplication(application).setVersion(applicationInfo.getVersion()).setBinary(applicationInfo.getApplicationJar()).setBinaryHash(applicationInfo.getBinaryHash()).setReleaseNotes(applicationInfo.getReleaseNotes()).setDataModelData(this.createVersionData(applicationInfo.getDataModelData())).setLocalizationData(this.createVersionData(applicationInfo.getLocalizationData())).setPrivilegeData(this.createVersionData(applicationInfo.getPrivilegeData())).setPerspectiveData(this.createVersionData(applicationInfo.getPerspectiveData())).save();
        applicationInfo.setApplicationVersion(applicationVersion);
    }

    @Override
    public void loadApplication(ApplicationInfo applicationInfo) {
    }

    private ApplicationVersionData createVersionData(ApplicationInfoDataElement dataElement) {
        if (dataElement == null || dataElement.getData() == null && dataElement.getDataAdded().isEmpty() && dataElement.getDataRemoved().isEmpty()) {
            return null;
        }
        return (ApplicationVersionData)ApplicationVersionData.create().setData(dataElement.getData()).setDataRows(dataElement.getData() == null ? 0 : dataElement.getData().split("\n").length).setDataAdded(String.join((CharSequence)"\n", dataElement.getDataAdded())).setDataAddedRows(dataElement.getDataAdded().size()).setDataRemoved(String.join((CharSequence)"\n", dataElement.getDataRemoved())).setDataRemovedRows(dataElement.getDataRemoved().size()).save();
    }
}

