/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.privilege;

import java.util.HashMap;
import java.util.Map;
import org.teamapps.application.api.privilege.PrivilegeGroupType;
import org.teamapps.application.server.system.privilege.MergedApplicationPrivileges;
import org.teamapps.application.server.system.privilege.MergedPrivilege;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.template.BaseTemplateTreeNode;

public class MergedPrivilegeGroup
extends BaseTemplateTreeNode<Object> {
    private final MergedApplicationPrivileges parent;
    private final String name;
    private final PrivilegeGroupType groupType;
    private final Icon icon;
    private final String title;
    private final String description;
    private Map<String, MergedPrivilege> privilegesByName = new HashMap<String, MergedPrivilege>();

    public MergedPrivilegeGroup(MergedApplicationPrivileges parent, String name, PrivilegeGroupType groupType, Icon icon, String title, String description) {
        this.parent = parent;
        this.name = name;
        this.groupType = groupType;
        this.icon = icon;
        this.title = title;
        this.description = description;
    }

    public void addPrivilege(String name, Icon icon, String title) {
        if (!this.privilegesByName.containsKey(name)) {
            this.privilegesByName.put(name, new MergedPrivilege(this, name, icon, title));
        }
    }

    public String getName() {
        return this.name;
    }

    public PrivilegeGroupType getGroupType() {
        return this.groupType;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, MergedPrivilege> getPrivilegesByName() {
        return this.privilegesByName;
    }

    public BaseTemplateTreeNode<Object> getParent() {
        return this.parent;
    }

    public String getCaption() {
        return this.title;
    }

    public String getBadge() {
        return this.privilegesByName.size() > 0 ? "" + this.privilegesByName.size() : null;
    }
}

