/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.utils;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.privilege.ApplicationRole;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.server.system.bootstrap.SystemRegistry;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.application.server.system.privilege.MergedApplicationPrivileges;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationPrivilegeGroup;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.model.controlcenter.OrganizationUnitType;
import org.teamapps.model.controlcenter.Role;
import org.teamapps.model.controlcenter.RoleApplicationRoleAssignment;
import org.teamapps.model.controlcenter.RolePrivilegeAssignment;
import org.teamapps.model.controlcenter.RoleType;
import org.teamapps.model.controlcenter.UserRoleAssignment;

public class RoleUtils {
    public static Set<Role> getAllRoleInstances(Role role) {
        HashSet<Role> roleSet = new HashSet<Role>();
        RoleUtils.calculateRoleInstances(role, roleSet);
        return roleSet;
    }

    private static void calculateRoleInstances(Role role, Set<Role> roleSet) {
        if (!roleSet.contains(role)) {
            roleSet.add(role);
            for (Role specializationRole : role.getSpecializationRoles()) {
                RoleUtils.calculateRoleInstances(specializationRole, roleSet);
            }
        }
    }

    public static Set<Role> getAllPrivilegeRoles(Role role) {
        HashSet<Role> roleSet = new HashSet<Role>();
        RoleUtils.calculatePrivilegeRoles(role, roleSet);
        return roleSet;
    }

    private static void calculatePrivilegeRoles(Role role, Set<Role> roleSet) {
        if (!roleSet.contains(role)) {
            roleSet.add(role);
            for (Role generalizationRole : role.getGeneralizationRoles()) {
                RoleUtils.calculatePrivilegeRoles(generalizationRole, roleSet);
            }
            for (Role privilegesSendingRole : role.getPrivilegesSendingRoles()) {
                RoleUtils.calculatePrivilegeRoles(privilegesSendingRole, roleSet);
            }
        }
    }

    public static List<UserRoleAssignment> getUserRoleAssignments(Role role, boolean withSpecializationRoles, OrganizationUnit organizationUnit, List<OrganizationUnitType> organizationUnitTypesFilter) {
        if (role == null || organizationUnit == null) {
            return Collections.emptyList();
        }
        HashSet<Role> roleSet = withSpecializationRoles ? RoleUtils.getAllRoleInstances(role) : new HashSet<Role>(Collections.singletonList(role));
        Set<OrganizationUnit> allUnits = OrganizationUtils.getAllUnits(organizationUnit, organizationUnitTypesFilter);
        return RoleUtils.getUserRoleAssignments(roleSet, allUnits);
    }

    public static List<UserRoleAssignment> getUserRoleAssignments(Set<Role> roleSet, Set<OrganizationUnit> organizationUnits) {
        return UserRoleAssignment.getAll().stream().filter(assignment -> roleSet.contains(assignment.getRole())).filter(assignment -> organizationUnits.contains(assignment.getOrganizationUnit())).collect(Collectors.toList());
    }

    public static int getMemberCount(Role role, boolean withSpecializationRoles) {
        HashSet<Role> roleSet = withSpecializationRoles ? RoleUtils.getAllRoleInstances(role) : new HashSet<Role>(Collections.singletonList(role));
        return (int)UserRoleAssignment.getAll().stream().filter(assignment -> roleSet.contains(assignment.getRole())).count();
    }

    public static List<UserRoleAssignment> getMembers(Role role, boolean withSpecializationRoles) {
        HashSet<Role> roleSet = withSpecializationRoles ? RoleUtils.getAllRoleInstances(role) : new HashSet<Role>(Collections.singletonList(role));
        return UserRoleAssignment.getAll().stream().filter(assignment -> roleSet.contains(assignment.getRole())).collect(Collectors.toList());
    }

    public static Comparator<UserRoleAssignment> createRoleTypeAndMainResponsibleComparator() {
        return (assignment1, assignment2) -> {
            int ordinal2;
            RoleType type1 = assignment1.getRole().getRoleType();
            RoleType type2 = assignment2.getRole().getRoleType();
            int ordinal1 = type1 != null ? type1.ordinal() : RoleType.OTHER.ordinal();
            int n = ordinal2 = type2 != null ? type2.ordinal() : RoleType.OTHER.ordinal();
            if (type1 == type2) {
                if (assignment1.isMainResponsible()) {
                    ordinal1 = -1;
                }
                if (assignment2.isMainResponsible()) {
                    ordinal2 = -1;
                }
                if (ordinal1 == ordinal2 && assignment1.getUser().getProfilePictureLength() == 0) {
                    ++ordinal1;
                }
            }
            return Integer.compare(ordinal1, ordinal2);
        };
    }

    public static List<MergedApplicationPrivileges> calcPrivileges(Role role, UserSessionData userSessionData) {
        SystemRegistry systemRegistry = userSessionData.getRegistry();
        HashMap<String, MergedApplicationPrivileges> applicationPrivilegesMap = new HashMap<String, MergedApplicationPrivileges>();
        Set<Role> privilegeRoles = RoleUtils.getAllPrivilegeRoles(role);
        for (Role privilegeRole : privilegeRoles) {
            ApplicationLocalizationProvider localizationProvider;
            Application application;
            for (RoleApplicationRoleAssignment applicationRoleAssignment : privilegeRole.getApplicationRoleAssignments()) {
                application = applicationRoleAssignment.getApplication();
                localizationProvider = userSessionData.getApplicationLocalizationProvider(application);
                MergedApplicationPrivileges mergedApplicationPrivileges = applicationPrivilegesMap.computeIfAbsent(application.getName(), s -> new MergedApplicationPrivileges((String)s, IconUtils.decodeIcon((String)application.getIcon()), localizationProvider.getLocalized(application.getTitleKey(), new Object[0]), localizationProvider.getLocalized(application.getDescriptionKey(), new Object[0])));
                ApplicationRole applicationRole = RoleUtils.getApplicationRole(application.getName(), applicationRoleAssignment.getApplicationRoleName(), systemRegistry);
                if (applicationRole == null) continue;
                for (PrivilegeGroup privilegeGroup : applicationRole.getPrivilegeGroups()) {
                    mergedApplicationPrivileges.addPrivilegeGroup(privilegeGroup, localizationProvider);
                }
            }
            for (RolePrivilegeAssignment privilegeAssignment : privilegeRole.getPrivilegeAssignments()) {
                application = privilegeAssignment.getApplication();
                localizationProvider = userSessionData.getApplicationLocalizationProvider(application);
                ApplicationPrivilegeGroup privilegeGroup = privilegeAssignment.getPrivilegeGroup();
                MergedApplicationPrivileges mergedApplicationPrivileges = applicationPrivilegesMap.computeIfAbsent(application.getName(), s -> new MergedApplicationPrivileges((String)s, IconUtils.decodeIcon((String)application.getIcon()), localizationProvider.getLocalized(application.getTitleKey(), new Object[0]), localizationProvider.getLocalized(application.getDescriptionKey(), new Object[0])));
                mergedApplicationPrivileges.addPrivilegeGroup(privilegeGroup, localizationProvider);
            }
        }
        return applicationPrivilegesMap.values().stream().sorted(Comparator.comparing(MergedApplicationPrivileges::getTitle)).collect(Collectors.toList());
    }

    public static ApplicationRole getApplicationRole(String applicationName, String applicationRoleName, SystemRegistry systemRegistry) {
        return systemRegistry.getLoadedApplications().stream().filter(app -> app.getApplication().getName().equals(applicationName)).filter(app -> app.getBaseApplicationBuilder() != null).flatMap(app -> app.getBaseApplicationBuilder().getApplicationRoles().stream()).filter(role -> role.getName().equals(applicationRoleName)).findFirst().orElse(null);
    }
}

