/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.ui.localize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.event.Level;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.localization.Language;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.bootstrap.SystemRegistry;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.form.FormWindow;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.LocalizationKey;
import org.teamapps.model.controlcenter.LocalizationKeyFormat;
import org.teamapps.model.controlcenter.LocalizationKeyQuery;
import org.teamapps.model.controlcenter.LocalizationKeyType;
import org.teamapps.model.controlcenter.LocalizationValue;
import org.teamapps.model.controlcenter.MachineTranslationState;
import org.teamapps.model.controlcenter.TranslationState;
import org.teamapps.model.controlcenter.TranslationVerificationState;
import org.teamapps.universaldb.index.enumeration.EnumFilterType;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldMessage;
import org.teamapps.ux.component.field.Fields;
import org.teamapps.ux.component.field.TextField;

public class LocalizationKeyWindow {
    public final Event<String> onNewKey = new Event();
    private final ApplicationInstanceData applicationInstanceData;
    private final List<Language> rankedLanguages;
    private final SystemRegistry systemRegistry;
    private final Supplier<Application> applicationSupplier;
    private FormWindow formWindow;
    private String newLocalizationKey;

    public LocalizationKeyWindow(ApplicationInstanceData applicationInstanceData, SystemRegistry systemRegistry, Supplier<Application> applicationSupplier) {
        this.applicationInstanceData = applicationInstanceData;
        this.rankedLanguages = applicationInstanceData.getUser().getRankedLanguages().stream().map(Language::getLanguageByIsoCode).filter(Objects::nonNull).collect(Collectors.toList());
        this.systemRegistry = systemRegistry;
        this.applicationSupplier = applicationSupplier;
        this.createUi();
    }

    private void createUi() {
        this.formWindow = new FormWindow(ApplicationIcons.ADDRESS_BOOK, this.applicationInstanceData.getLocalized("org.teamapps.dictionary.translationKey", new Object[0]), this.applicationInstanceData);
        this.formWindow.setWindowSize(600, 450);
        this.formWindow.addSaveButton();
        this.formWindow.addCancelButton();
        this.formWindow.addSection();
        TextField keyField = new TextField();
        this.formWindow.addField(ApplicationIcons.DICTIONARY, this.applicationInstanceData.getLocalized("org.teamapps.dictionary.translationKey", new Object[0]), (Component)keyField);
        HashMap<Language, TextField> valueFieldByLanguage = new HashMap<Language, TextField>();
        for (Language language : this.rankedLanguages) {
            TextField valueField = new TextField();
            valueFieldByLanguage.put(language, valueField);
            this.formWindow.addField((Icon)language.getIcon(), language.getLanguageLocalized((ApplicationLocalizationProvider)this.applicationInstanceData), (Component)valueField);
        }
        keyField.setRequired(true);
        keyField.addValidator(s -> {
            LocalizationKeyQuery keyQuery = LocalizationKey.filter();
            if (this.applicationSupplier != null && this.applicationSupplier.get() != null) {
                keyQuery.key(TextFilter.textEqualsIgnoreCaseFilter((String)s)).application(NumericFilter.equalsFilter((Number)this.applicationSupplier.get().getId()));
            } else {
                keyQuery.key(TextFilter.textEqualsIgnoreCaseFilter((String)("org.teamapps.systemKey." + s))).localizationKeyType(EnumFilterType.EQUALS, LocalizationKeyType.SYSTEM_KEY);
            }
            LocalizationKey key = (LocalizationKey)keyQuery.executeExpectSingleton();
            if (key != null || s == null || s.length() < 3 || s.contains(" ")) {
                return Collections.singletonList(new FieldMessage(FieldMessage.Severity.ERROR, this.applicationInstanceData.getLocalized("org.teamapps.dictionary.errorTranslationKeyAlreadyExists", new Object[0])));
            }
            return null;
        });
        this.formWindow.getSaveButton().onClick.addListener(() -> {
            boolean success = false;
            if (Fields.validateAll((AbstractField[])new AbstractField[]{keyField})) {
                LocalizationKey localizationKey = LocalizationKey.create().setKey((String)keyField.getValue()).setUsed(true).setLocalizationKeyFormat(LocalizationKeyFormat.SINGLE_LINE);
                if (this.applicationSupplier != null && this.applicationSupplier.get() != null) {
                    localizationKey.setApplication(this.applicationSupplier.get()).setLocalizationKeyType(LocalizationKeyType.REPORTING_KEY);
                } else {
                    localizationKey.setKey("org.teamapps.systemKey." + (String)keyField.getValue()).setLocalizationKeyType(LocalizationKeyType.SYSTEM_KEY);
                }
                ArrayList<LocalizationValue> values = new ArrayList<LocalizationValue>();
                StringBuilder userData = new StringBuilder();
                userData.append("key:").append((String)keyField.getValue()).append("\n");
                for (Language language : this.rankedLanguages) {
                    TextField field = (TextField)valueFieldByLanguage.get(language);
                    String value = (String)field.getValue();
                    if (value == null || value.isBlank()) continue;
                    userData.append(language).append(":").append(value).append("\n");
                    LocalizationValue localizationValue = LocalizationValue.create().setLanguage(language.getIsoCode()).setOriginal(value).setCurrentDisplayValue(value).setMachineTranslationState(MachineTranslationState.NOT_NECESSARY).setTranslationState(TranslationState.NOT_NECESSARY).setTranslationVerificationState(TranslationVerificationState.NOT_NECESSARY);
                    values.add(localizationValue);
                }
                if (!values.isEmpty()) {
                    Set createdLanguages = values.stream().map(LocalizationValue::getLanguage).collect(Collectors.toSet());
                    for (String requiredLanguage : this.systemRegistry.getSystemConfig().getLocalizationConfig().getRequiredLanguages()) {
                        if (createdLanguages.contains(requiredLanguage)) continue;
                        LocalizationValue localizationValue = (LocalizationValue)LocalizationValue.create().setLanguage(requiredLanguage).setMachineTranslationState(MachineTranslationState.TRANSLATION_REQUESTED).setTranslationState(TranslationState.TRANSLATION_REQUESTED).setTranslationVerificationState(TranslationVerificationState.NOT_YET_TRANSLATED).save();
                        values.add(localizationValue);
                    }
                    localizationKey.setLocalizationValues(values).save();
                    success = true;
                    this.newLocalizationKey = localizationKey.getKey();
                    this.formWindow.close();
                    this.applicationInstanceData.writeActivityLog(Level.INFO, "Created new translation key", userData.toString());
                    this.systemRegistry.updateGlobalLocalizationProvider();
                    this.systemRegistry.machineTranslateMissingEntries();
                    this.onNewKey.fire((Object)this.newLocalizationKey);
                }
                UiUtils.showSaveNotification((boolean)success, (ApplicationInstanceData)this.applicationInstanceData);
            }
        });
    }

    public void resetUi() {
        this.formWindow.getFields().forEach(field -> field.setValue(null));
    }

    public void show() {
        this.formWindow.show();
    }

    public String getNewLocalizationKey() {
        return this.newLocalizationKey;
    }
}

