package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface LocalizationKey extends Entity<LocalizationKey> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_APPLICATION = "application";
	final static String FIELD_KEY = "key";
	final static String FIELD_USED = "used";
	final static String FIELD_LOCALIZATION_KEY_FORMAT = "localizationKeyFormat";
	final static String FIELD_LOCALIZATION_KEY_TYPE = "localizationKeyType";
	final static String FIELD_COMMENTS = "comments";
	final static String FIELD_LOCALIZATION_VALUES = "localizationValues";
	final static String FIELD_TOPICS = "topics";

    static LocalizationKey create() {
        return new UdbLocalizationKey();
    }

    static LocalizationKey create(int id) {
        return new UdbLocalizationKey(id, true);
    }

    static LocalizationKey getById(int id) {
        return new UdbLocalizationKey(id, false);
    }

    static EntityBuilder<LocalizationKey> getBuilder() {
        return new UdbLocalizationKey(0, false);
    }

    Instant getMetaCreationDate();

    LocalizationKey setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    LocalizationKey setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    LocalizationKey setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    LocalizationKey setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    LocalizationKey setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    LocalizationKey setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    LocalizationKey setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    LocalizationKey setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    LocalizationKey setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    LocalizationKey setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    LocalizationKey setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    LocalizationKey setMetaDeletedBy(int value);

    Application getApplication();

    LocalizationKey setApplication(Application value);

    String getKey();

    LocalizationKey setKey(String value);

    boolean getUsed();

    LocalizationKey setUsed(boolean value);

    LocalizationKeyFormat getLocalizationKeyFormat();

    LocalizationKey setLocalizationKeyFormat(LocalizationKeyFormat value);

    LocalizationKeyType getLocalizationKeyType();

    LocalizationKey setLocalizationKeyType(LocalizationKeyType value);

    String getComments();

    LocalizationKey setComments(String value);

    List<LocalizationValue> getLocalizationValues();

    LocalizationKey setLocalizationValues(List<LocalizationValue> value);

    int getLocalizationValuesCount();

    LocalizationKey setLocalizationValues(LocalizationValue ... value);

    BitSet getLocalizationValuesAsBitSet();

    LocalizationKey addLocalizationValues(List<LocalizationValue> value);

    LocalizationKey addLocalizationValues(LocalizationValue ... value);

    LocalizationKey removeLocalizationValues(List<LocalizationValue> value);

    LocalizationKey removeLocalizationValues(LocalizationValue ... value);

    LocalizationKey removeAllLocalizationValues();

    List<LocalizationTopic> getTopics();

    LocalizationKey setTopics(List<LocalizationTopic> value);

    int getTopicsCount();

    LocalizationKey setTopics(LocalizationTopic ... value);

    BitSet getTopicsAsBitSet();

    LocalizationKey addTopics(List<LocalizationTopic> value);

    LocalizationKey addTopics(LocalizationTopic ... value);

    LocalizationKey removeTopics(List<LocalizationTopic> value);

    LocalizationKey removeTopics(LocalizationTopic ... value);

    LocalizationKey removeAllTopics();


    static List<LocalizationKey> getAll() {
        return UdbLocalizationKey.getAll();
    }

    static List<LocalizationKey> sort(List<LocalizationKey> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbLocalizationKey.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbLocalizationKey.getCount();
    }

    static LocalizationKeyQuery filter() {
        return new UdbLocalizationKeyQuery();
    }
}

