package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface LocalizationTopic extends Entity<LocalizationTopic> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_KEYS = "keys";
	final static String FIELD_APPLICATION = "application";
	final static String FIELD_ICON = "icon";
	final static String FIELD_TITLE = "title";
	final static String FIELD_SCREENSHOT = "screenshot";

    static LocalizationTopic create() {
        return new UdbLocalizationTopic();
    }

    static LocalizationTopic create(int id) {
        return new UdbLocalizationTopic(id, true);
    }

    static LocalizationTopic getById(int id) {
        return new UdbLocalizationTopic(id, false);
    }

    static EntityBuilder<LocalizationTopic> getBuilder() {
        return new UdbLocalizationTopic(0, false);
    }

    Instant getMetaCreationDate();

    LocalizationTopic setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    LocalizationTopic setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    LocalizationTopic setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    LocalizationTopic setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    LocalizationTopic setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    LocalizationTopic setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    LocalizationTopic setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    LocalizationTopic setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    LocalizationTopic setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    LocalizationTopic setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    LocalizationTopic setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    LocalizationTopic setMetaDeletedBy(int value);

    List<LocalizationKey> getKeys();

    LocalizationTopic setKeys(List<LocalizationKey> value);

    int getKeysCount();

    LocalizationTopic setKeys(LocalizationKey ... value);

    BitSet getKeysAsBitSet();

    LocalizationTopic addKeys(List<LocalizationKey> value);

    LocalizationTopic addKeys(LocalizationKey ... value);

    LocalizationTopic removeKeys(List<LocalizationKey> value);

    LocalizationTopic removeKeys(LocalizationKey ... value);

    LocalizationTopic removeAllKeys();

    Application getApplication();

    LocalizationTopic setApplication(Application value);

    String getIcon();

    LocalizationTopic setIcon(String value);

    String getTitle();

    LocalizationTopic setTitle(String value);

    FileValue getScreenshot();

    LocalizationTopic setScreenshot(File value);

    LocalizationTopic setScreenshot(File value, String fileName);


    static List<LocalizationTopic> getAll() {
        return UdbLocalizationTopic.getAll();
    }

    static List<LocalizationTopic> sort(List<LocalizationTopic> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbLocalizationTopic.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbLocalizationTopic.getCount();
    }

    static LocalizationTopicQuery filter() {
        return new UdbLocalizationTopicQuery();
    }
}

