package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbApplicationPerspectiveQuery extends AbstractUdbQuery<ApplicationPerspective> implements ApplicationPerspectiveQuery {

    public UdbApplicationPerspectiveQuery() {
        super(UdbApplicationPerspective.table, ApplicationPerspective.getBuilder());
    }

	@Override
	public ApplicationPerspectiveQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbApplicationPerspective.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbApplicationPerspective.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery metaCreationDate(NumericFilter filter) {
		and(UdbApplicationPerspective.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbApplicationPerspective.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery metaCreatedBy(NumericFilter filter) {
		and(UdbApplicationPerspective.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbApplicationPerspective.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery metaModificationDate(NumericFilter filter) {
		and(UdbApplicationPerspective.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbApplicationPerspective.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery metaModifiedBy(NumericFilter filter) {
		and(UdbApplicationPerspective.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbApplicationPerspective.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery metaDeletionDate(NumericFilter filter) {
		and(UdbApplicationPerspective.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbApplicationPerspective.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery metaDeletedBy(NumericFilter filter) {
		and(UdbApplicationPerspective.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbApplicationPerspective.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery filterApplication(ApplicationQuery query) {
		UdbApplicationQuery udbQuery = (UdbApplicationQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplicationPerspective.application, UdbApplication.perspectives);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery application(NumericFilter filter) {
		and(UdbApplicationPerspective.application.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery orApplication(NumericFilter filter) {
		or(UdbApplicationPerspective.application.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery name(TextFilter filter) {
		and(UdbApplicationPerspective.name.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery orName(TextFilter filter) {
		or(UdbApplicationPerspective.name.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery icon(TextFilter filter) {
		and(UdbApplicationPerspective.icon.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery orIcon(TextFilter filter) {
		or(UdbApplicationPerspective.icon.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery titleKey(TextFilter filter) {
		and(UdbApplicationPerspective.titleKey.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery orTitleKey(TextFilter filter) {
		or(UdbApplicationPerspective.titleKey.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery descriptionKey(TextFilter filter) {
		and(UdbApplicationPerspective.descriptionKey.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery orDescriptionKey(TextFilter filter) {
		or(UdbApplicationPerspective.descriptionKey.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery autoProvision(BooleanFilter filter) {
		and(UdbApplicationPerspective.autoProvision.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery orAutoProvision(BooleanFilter filter) {
		or(UdbApplicationPerspective.autoProvision.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery filterManagedPerspectives(ManagedApplicationPerspectiveQuery query) {
		UdbManagedApplicationPerspectiveQuery udbQuery = (UdbManagedApplicationPerspectiveQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplicationPerspective.managedPerspectives, UdbManagedApplicationPerspective.applicationPerspective);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery managedPerspectives(MultiReferenceFilterType type, ManagedApplicationPerspective ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (ManagedApplicationPerspective value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbApplicationPerspective.managedPerspectives.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery managedPerspectivesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbApplicationPerspective.managedPerspectives.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery managedPerspectives(MultiReferenceFilter filter) {
		and(UdbApplicationPerspective.managedPerspectives.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPerspectiveQuery orManagedPerspectives(MultiReferenceFilter filter) {
		or(UdbApplicationPerspective.managedPerspectives.createFilter(filter));
		return this;
	}


	@Override
	public UdbApplicationPerspectiveQuery andOr(ApplicationPerspectiveQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public ApplicationPerspectiveQuery customFilter(Function<ApplicationPerspective, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(ApplicationPerspective.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



