package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbCountry extends AbstractUdbEntity<Country> implements Country {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static TextIndex isoCode;
	protected static TextIndex icon;
	protected static TextIndex englishDisplayName;
	protected static SingleReferenceIndex localizationKey;
	protected static TextIndex addressFormat;
	protected static SingleReferenceIndex mainLanguage;
	protected static MultiReferenceIndex otherLanguages;
	protected static SingleReferenceIndex currency;
	protected static MultiReferenceIndex otherCurrencies;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		isoCode = (TextIndex) tableIndex.getColumnIndex(FIELD_ISO_CODE);
		icon = (TextIndex) tableIndex.getColumnIndex(FIELD_ICON);
		englishDisplayName = (TextIndex) tableIndex.getColumnIndex(FIELD_ENGLISH_DISPLAY_NAME);
		localizationKey = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_LOCALIZATION_KEY);
		addressFormat = (TextIndex) tableIndex.getColumnIndex(FIELD_ADDRESS_FORMAT);
		mainLanguage = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_MAIN_LANGUAGE);
		otherLanguages = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_OTHER_LANGUAGES);
		currency = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_CURRENCY);
		otherCurrencies = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_OTHER_CURRENCIES);
    }

    public static List<Country> getAll() {
        return new EntityBitSetList<>(Country.getBuilder(), table.getRecordBitSet());
    }

    public static List<Country> sort(List<Country> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<Country> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, Country.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbCountry() {
        super(table);
    }

    public UdbCountry(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public Country build() {
        return new UdbCountry();
    }

    @Override
    public Country build(int id) {
        return new UdbCountry(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public Country setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public Country setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public Country setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public Country setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public Country setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public Country setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public Country setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public Country setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public Country setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public Country setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public Country setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public Country setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public String getIsoCode() {
        return getTextValue(isoCode);
	}

	@Override
	public Country setIsoCode(String value) {
	    setTextValue(value, this.isoCode);
		return this;
	}

	@Override
	public String getIcon() {
        return getTextValue(icon);
	}

	@Override
	public Country setIcon(String value) {
	    setTextValue(value, this.icon);
		return this;
	}

	@Override
	public String getEnglishDisplayName() {
        return getTextValue(englishDisplayName);
	}

	@Override
	public Country setEnglishDisplayName(String value) {
	    setTextValue(value, this.englishDisplayName);
		return this;
	}

	@Override
	public LocalizationKey getLocalizationKey() {
		if (isChanged(localizationKey)) {
			return (LocalizationKey) getReferenceChangeValue(localizationKey);
		} else {
			int id = localizationKey.getValue(getId());
			if (id > 0) {
				return LocalizationKey.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public Country setLocalizationKey(LocalizationKey value) {
		setSingleReferenceValue(localizationKey, value, table);
		return this;
	}

	@Override
	public String getAddressFormat() {
        return getTextValue(addressFormat);
	}

	@Override
	public Country setAddressFormat(String value) {
	    setTextValue(value, this.addressFormat);
		return this;
	}

	@Override
	public Language getMainLanguage() {
		if (isChanged(mainLanguage)) {
			return (Language) getReferenceChangeValue(mainLanguage);
		} else {
			int id = mainLanguage.getValue(getId());
			if (id > 0) {
				return Language.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public Country setMainLanguage(Language value) {
		setSingleReferenceValue(mainLanguage, value, table);
		return this;
	}

	@Override
	public List<Language> getOtherLanguages() {
	    return getMultiReferenceValue(otherLanguages, Language.getBuilder());
	}

	@Override
	public Country setOtherLanguages(List<Language> value) {
		setMultiReferenceValue(value, otherLanguages);
		return this;
	}

	@Override
	public int getOtherLanguagesCount() {
	    return getMultiReferenceValueCount(otherLanguages, Language.getBuilder());
	}

	@Override
	public Country setOtherLanguages(Language ... value) {
		setMultiReferenceValue(Arrays.asList(value), otherLanguages);
		return this;
	}

	@Override
	public BitSet getOtherLanguagesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(otherLanguages, Language.getBuilder());
	}

	@Override
	public Country addOtherLanguages(List<Language> value) {
		addMultiReferenceValue(value, otherLanguages);
		return this;
	}

	@Override
	public Country addOtherLanguages(Language ... value) {
		addMultiReferenceValue(Arrays.asList(value), otherLanguages);
		return this;
	}

	@Override
	public Country removeOtherLanguages(List<Language> value) {
		removeMultiReferenceValue(value, otherLanguages);
		return this;
	}

	@Override
	public Country removeOtherLanguages(Language ... value) {
		removeMultiReferenceValue(Arrays.asList(value), otherLanguages);
		return this;
	}

	@Override
	public Country removeAllOtherLanguages() {
		removeAllMultiReferenceValue(otherLanguages);
		return this;
	}

	@Override
	public Currency getCurrency() {
		if (isChanged(currency)) {
			return (Currency) getReferenceChangeValue(currency);
		} else {
			int id = currency.getValue(getId());
			if (id > 0) {
				return Currency.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public Country setCurrency(Currency value) {
		setSingleReferenceValue(currency, value, table);
		return this;
	}

	@Override
	public List<Currency> getOtherCurrencies() {
	    return getMultiReferenceValue(otherCurrencies, Currency.getBuilder());
	}

	@Override
	public Country setOtherCurrencies(List<Currency> value) {
		setMultiReferenceValue(value, otherCurrencies);
		return this;
	}

	@Override
	public int getOtherCurrenciesCount() {
	    return getMultiReferenceValueCount(otherCurrencies, Currency.getBuilder());
	}

	@Override
	public Country setOtherCurrencies(Currency ... value) {
		setMultiReferenceValue(Arrays.asList(value), otherCurrencies);
		return this;
	}

	@Override
	public BitSet getOtherCurrenciesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(otherCurrencies, Currency.getBuilder());
	}

	@Override
	public Country addOtherCurrencies(List<Currency> value) {
		addMultiReferenceValue(value, otherCurrencies);
		return this;
	}

	@Override
	public Country addOtherCurrencies(Currency ... value) {
		addMultiReferenceValue(Arrays.asList(value), otherCurrencies);
		return this;
	}

	@Override
	public Country removeOtherCurrencies(List<Currency> value) {
		removeMultiReferenceValue(value, otherCurrencies);
		return this;
	}

	@Override
	public Country removeOtherCurrencies(Currency ... value) {
		removeMultiReferenceValue(Arrays.asList(value), otherCurrencies);
		return this;
	}

	@Override
	public Country removeAllOtherCurrencies() {
		removeAllMultiReferenceValue(otherCurrencies);
		return this;
	}


    @Override
    public UdbCountry save(Transaction transaction, boolean strictChangeVerification) {
        save(transaction, table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbCountry saveTransactional(boolean strictChangeVerification) {
        save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbCountry save() {
        save(table);
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        delete(transaction, table);
    }

    @Override
    public void delete() {
        delete(table);
    }

	@Override
	public String toString() {
    	StringBuilder sb = new StringBuilder();
    	sb.append(table.getName()).append(": ").append(getId()).append("\n");
		for (ColumnIndex column : table.getColumnIndices()) {
			sb.append("\t").append(column.getName()).append(": ").append(column.getStringValue(getId()));
			if (isChanged(column)) {
				TransactionRecordValue changeValue = getChangeValue(column);
				sb.append(" -> ").append(changeValue.getValue());
			}
			sb.append("\n");
		}
		return sb.toString();
	}
}



