package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbManagedApplication extends AbstractUdbEntity<ManagedApplication> implements ManagedApplication {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static SingleReferenceIndex mainApplication;
	protected static SingleReferenceIndex organizationField;
	protected static TextIndex icon;
	protected static TextIndex titleKey;
	protected static TextIndex descriptionKey;
	protected static BooleanIndex singleApplication;
	protected static MultiReferenceIndex perspectives;
	protected static IntegerIndex listingPosition;
	protected static SingleReferenceIndex applicationGroup;
	protected static BooleanIndex hidden;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		mainApplication = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_MAIN_APPLICATION);
		organizationField = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ORGANIZATION_FIELD);
		icon = (TextIndex) tableIndex.getColumnIndex(FIELD_ICON);
		titleKey = (TextIndex) tableIndex.getColumnIndex(FIELD_TITLE_KEY);
		descriptionKey = (TextIndex) tableIndex.getColumnIndex(FIELD_DESCRIPTION_KEY);
		singleApplication = (BooleanIndex) tableIndex.getColumnIndex(FIELD_SINGLE_APPLICATION);
		perspectives = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_PERSPECTIVES);
		listingPosition = (IntegerIndex) tableIndex.getColumnIndex(FIELD_LISTING_POSITION);
		applicationGroup = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_APPLICATION_GROUP);
		hidden = (BooleanIndex) tableIndex.getColumnIndex(FIELD_HIDDEN);
    }

    public static List<ManagedApplication> getAll() {
        return new EntityBitSetList<>(ManagedApplication.getBuilder(), table.getRecordBitSet());
    }

    public static List<ManagedApplication> sort(List<ManagedApplication> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<ManagedApplication> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, ManagedApplication.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbManagedApplication() {
        super(table);
    }

    public UdbManagedApplication(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public ManagedApplication build() {
        return new UdbManagedApplication();
    }

    @Override
    public ManagedApplication build(int id) {
        return new UdbManagedApplication(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public ManagedApplication setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public ManagedApplication setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public ManagedApplication setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public ManagedApplication setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public ManagedApplication setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public ManagedApplication setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public ManagedApplication setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public ManagedApplication setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public ManagedApplication setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public ManagedApplication setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public ManagedApplication setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public ManagedApplication setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Application getMainApplication() {
		if (isChanged(mainApplication)) {
			return (Application) getReferenceChangeValue(mainApplication);
		} else {
			int id = mainApplication.getValue(getId());
			if (id > 0) {
				return Application.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public ManagedApplication setMainApplication(Application value) {
		setSingleReferenceValue(mainApplication, value, table);
		return this;
	}

	@Override
	public OrganizationField getOrganizationField() {
		if (isChanged(organizationField)) {
			return (OrganizationField) getReferenceChangeValue(organizationField);
		} else {
			int id = organizationField.getValue(getId());
			if (id > 0) {
				return OrganizationField.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public ManagedApplication setOrganizationField(OrganizationField value) {
		setSingleReferenceValue(organizationField, value, table);
		return this;
	}

	@Override
	public String getIcon() {
        return getTextValue(icon);
	}

	@Override
	public ManagedApplication setIcon(String value) {
	    setTextValue(value, this.icon);
		return this;
	}

	@Override
	public String getTitleKey() {
        return getTextValue(titleKey);
	}

	@Override
	public ManagedApplication setTitleKey(String value) {
	    setTextValue(value, this.titleKey);
		return this;
	}

	@Override
	public String getDescriptionKey() {
        return getTextValue(descriptionKey);
	}

	@Override
	public ManagedApplication setDescriptionKey(String value) {
	    setTextValue(value, this.descriptionKey);
		return this;
	}

	@Override
	public boolean getSingleApplication() {
	    return getBooleanValue(singleApplication);
	}

	@Override
	public ManagedApplication setSingleApplication(boolean value) {
	    setBooleanValue(value, this.singleApplication);
		return this;
	}

	@Override
	public List<ManagedApplicationPerspective> getPerspectives() {
	    return getMultiReferenceValue(perspectives, ManagedApplicationPerspective.getBuilder());
	}

	@Override
	public ManagedApplication setPerspectives(List<ManagedApplicationPerspective> value) {
		setMultiReferenceValue(value, perspectives);
		return this;
	}

	@Override
	public int getPerspectivesCount() {
	    return getMultiReferenceValueCount(perspectives, ManagedApplicationPerspective.getBuilder());
	}

	@Override
	public ManagedApplication setPerspectives(ManagedApplicationPerspective ... value) {
		setMultiReferenceValue(Arrays.asList(value), perspectives);
		return this;
	}

	@Override
	public BitSet getPerspectivesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(perspectives, ManagedApplicationPerspective.getBuilder());
	}

	@Override
	public ManagedApplication addPerspectives(List<ManagedApplicationPerspective> value) {
		addMultiReferenceValue(value, perspectives);
		return this;
	}

	@Override
	public ManagedApplication addPerspectives(ManagedApplicationPerspective ... value) {
		addMultiReferenceValue(Arrays.asList(value), perspectives);
		return this;
	}

	@Override
	public ManagedApplication removePerspectives(List<ManagedApplicationPerspective> value) {
		removeMultiReferenceValue(value, perspectives);
		return this;
	}

	@Override
	public ManagedApplication removePerspectives(ManagedApplicationPerspective ... value) {
		removeMultiReferenceValue(Arrays.asList(value), perspectives);
		return this;
	}

	@Override
	public ManagedApplication removeAllPerspectives() {
		removeAllMultiReferenceValue(perspectives);
		return this;
	}

	@Override
	public int getListingPosition() {
        return getIntValue(listingPosition);
	}

	@Override
	public ManagedApplication setListingPosition(int value) {
	    setIntValue(value, this.listingPosition);
		return this;
	}

	@Override
	public ManagedApplicationGroup getApplicationGroup() {
		if (isChanged(applicationGroup)) {
			return (ManagedApplicationGroup) getReferenceChangeValue(applicationGroup);
		} else {
			int id = applicationGroup.getValue(getId());
			if (id > 0) {
				return ManagedApplicationGroup.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public ManagedApplication setApplicationGroup(ManagedApplicationGroup value) {
		setSingleReferenceValue(applicationGroup, value, table);
		return this;
	}

	@Override
	public boolean getHidden() {
	    return getBooleanValue(hidden);
	}

	@Override
	public ManagedApplication setHidden(boolean value) {
	    setBooleanValue(value, this.hidden);
		return this;
	}


    @Override
    public UdbManagedApplication save(Transaction transaction, boolean strictChangeVerification) {
        save(transaction, table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbManagedApplication saveTransactional(boolean strictChangeVerification) {
        save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbManagedApplication save() {
        save(table);
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        delete(transaction, table);
    }

    @Override
    public void delete() {
        delete(table);
    }

	@Override
	public String toString() {
    	StringBuilder sb = new StringBuilder();
    	sb.append(table.getName()).append(": ").append(getId()).append("\n");
		for (ColumnIndex column : table.getColumnIndices()) {
			sb.append("\t").append(column.getName()).append(": ").append(column.getStringValue(getId()));
			if (isChanged(column)) {
				TransactionRecordValue changeValue = getChangeValue(column);
				sb.append(" -> ").append(changeValue.getValue());
			}
			sb.append("\n");
		}
		return sb.toString();
	}
}



