package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbRolePrivilegeAssignment extends AbstractUdbEntity<RolePrivilegeAssignment> implements RolePrivilegeAssignment {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static SingleReferenceIndex role;
	protected static SingleReferenceIndex application;
	protected static SingleReferenceIndex privilegeGroup;
	protected static MultiReferenceIndex privileges;
	protected static TextIndex privilegeObjects;
	protected static BooleanIndex privilegeObjectInheritance;
	protected static SingleReferenceIndex organizationFieldFilter;
	protected static SingleReferenceIndex fixedOrganizationRoot;
	protected static MultiReferenceIndex organizationUnitTypeFilter;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		role = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ROLE);
		application = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_APPLICATION);
		privilegeGroup = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_PRIVILEGE_GROUP);
		privileges = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_PRIVILEGES);
		privilegeObjects = (TextIndex) tableIndex.getColumnIndex(FIELD_PRIVILEGE_OBJECTS);
		privilegeObjectInheritance = (BooleanIndex) tableIndex.getColumnIndex(FIELD_PRIVILEGE_OBJECT_INHERITANCE);
		organizationFieldFilter = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ORGANIZATION_FIELD_FILTER);
		fixedOrganizationRoot = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_FIXED_ORGANIZATION_ROOT);
		organizationUnitTypeFilter = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_ORGANIZATION_UNIT_TYPE_FILTER);
    }

    public static List<RolePrivilegeAssignment> getAll() {
        return new EntityBitSetList<>(RolePrivilegeAssignment.getBuilder(), table.getRecordBitSet());
    }

    public static List<RolePrivilegeAssignment> sort(List<RolePrivilegeAssignment> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<RolePrivilegeAssignment> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, RolePrivilegeAssignment.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbRolePrivilegeAssignment() {
        super(table);
    }

    public UdbRolePrivilegeAssignment(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public RolePrivilegeAssignment build() {
        return new UdbRolePrivilegeAssignment();
    }

    @Override
    public RolePrivilegeAssignment build(int id) {
        return new UdbRolePrivilegeAssignment(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public RolePrivilegeAssignment setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public RolePrivilegeAssignment setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public RolePrivilegeAssignment setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public RolePrivilegeAssignment setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public RolePrivilegeAssignment setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public RolePrivilegeAssignment setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public RolePrivilegeAssignment setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public RolePrivilegeAssignment setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public RolePrivilegeAssignment setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public RolePrivilegeAssignment setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public RolePrivilegeAssignment setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public RolePrivilegeAssignment setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Role getRole() {
		if (isChanged(role)) {
			return (Role) getReferenceChangeValue(role);
		} else {
			int id = role.getValue(getId());
			if (id > 0) {
				return Role.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public RolePrivilegeAssignment setRole(Role value) {
		setSingleReferenceValue(role, value, table);
		return this;
	}

	@Override
	public Application getApplication() {
		if (isChanged(application)) {
			return (Application) getReferenceChangeValue(application);
		} else {
			int id = application.getValue(getId());
			if (id > 0) {
				return Application.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public RolePrivilegeAssignment setApplication(Application value) {
		setSingleReferenceValue(application, value, table);
		return this;
	}

	@Override
	public ApplicationPrivilegeGroup getPrivilegeGroup() {
		if (isChanged(privilegeGroup)) {
			return (ApplicationPrivilegeGroup) getReferenceChangeValue(privilegeGroup);
		} else {
			int id = privilegeGroup.getValue(getId());
			if (id > 0) {
				return ApplicationPrivilegeGroup.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public RolePrivilegeAssignment setPrivilegeGroup(ApplicationPrivilegeGroup value) {
		setSingleReferenceValue(privilegeGroup, value, table);
		return this;
	}

	@Override
	public List<ApplicationPrivilege> getPrivileges() {
	    return getMultiReferenceValue(privileges, ApplicationPrivilege.getBuilder());
	}

	@Override
	public RolePrivilegeAssignment setPrivileges(List<ApplicationPrivilege> value) {
		setMultiReferenceValue(value, privileges);
		return this;
	}

	@Override
	public int getPrivilegesCount() {
	    return getMultiReferenceValueCount(privileges, ApplicationPrivilege.getBuilder());
	}

	@Override
	public RolePrivilegeAssignment setPrivileges(ApplicationPrivilege ... value) {
		setMultiReferenceValue(Arrays.asList(value), privileges);
		return this;
	}

	@Override
	public BitSet getPrivilegesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(privileges, ApplicationPrivilege.getBuilder());
	}

	@Override
	public RolePrivilegeAssignment addPrivileges(List<ApplicationPrivilege> value) {
		addMultiReferenceValue(value, privileges);
		return this;
	}

	@Override
	public RolePrivilegeAssignment addPrivileges(ApplicationPrivilege ... value) {
		addMultiReferenceValue(Arrays.asList(value), privileges);
		return this;
	}

	@Override
	public RolePrivilegeAssignment removePrivileges(List<ApplicationPrivilege> value) {
		removeMultiReferenceValue(value, privileges);
		return this;
	}

	@Override
	public RolePrivilegeAssignment removePrivileges(ApplicationPrivilege ... value) {
		removeMultiReferenceValue(Arrays.asList(value), privileges);
		return this;
	}

	@Override
	public RolePrivilegeAssignment removeAllPrivileges() {
		removeAllMultiReferenceValue(privileges);
		return this;
	}

	@Override
	public String getPrivilegeObjects() {
        return getTextValue(privilegeObjects);
	}

	@Override
	public RolePrivilegeAssignment setPrivilegeObjects(String value) {
	    setTextValue(value, this.privilegeObjects);
		return this;
	}

	@Override
	public boolean getPrivilegeObjectInheritance() {
	    return getBooleanValue(privilegeObjectInheritance);
	}

	@Override
	public RolePrivilegeAssignment setPrivilegeObjectInheritance(boolean value) {
	    setBooleanValue(value, this.privilegeObjectInheritance);
		return this;
	}

	@Override
	public OrganizationField getOrganizationFieldFilter() {
		if (isChanged(organizationFieldFilter)) {
			return (OrganizationField) getReferenceChangeValue(organizationFieldFilter);
		} else {
			int id = organizationFieldFilter.getValue(getId());
			if (id > 0) {
				return OrganizationField.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public RolePrivilegeAssignment setOrganizationFieldFilter(OrganizationField value) {
		setSingleReferenceValue(organizationFieldFilter, value, table);
		return this;
	}

	@Override
	public OrganizationUnit getFixedOrganizationRoot() {
		if (isChanged(fixedOrganizationRoot)) {
			return (OrganizationUnit) getReferenceChangeValue(fixedOrganizationRoot);
		} else {
			int id = fixedOrganizationRoot.getValue(getId());
			if (id > 0) {
				return OrganizationUnit.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public RolePrivilegeAssignment setFixedOrganizationRoot(OrganizationUnit value) {
		setSingleReferenceValue(fixedOrganizationRoot, value, table);
		return this;
	}

	@Override
	public List<OrganizationUnitType> getOrganizationUnitTypeFilter() {
	    return getMultiReferenceValue(organizationUnitTypeFilter, OrganizationUnitType.getBuilder());
	}

	@Override
	public RolePrivilegeAssignment setOrganizationUnitTypeFilter(List<OrganizationUnitType> value) {
		setMultiReferenceValue(value, organizationUnitTypeFilter);
		return this;
	}

	@Override
	public int getOrganizationUnitTypeFilterCount() {
	    return getMultiReferenceValueCount(organizationUnitTypeFilter, OrganizationUnitType.getBuilder());
	}

	@Override
	public RolePrivilegeAssignment setOrganizationUnitTypeFilter(OrganizationUnitType ... value) {
		setMultiReferenceValue(Arrays.asList(value), organizationUnitTypeFilter);
		return this;
	}

	@Override
	public BitSet getOrganizationUnitTypeFilterAsBitSet() {
	    return getMultiReferenceValueAsBitSet(organizationUnitTypeFilter, OrganizationUnitType.getBuilder());
	}

	@Override
	public RolePrivilegeAssignment addOrganizationUnitTypeFilter(List<OrganizationUnitType> value) {
		addMultiReferenceValue(value, organizationUnitTypeFilter);
		return this;
	}

	@Override
	public RolePrivilegeAssignment addOrganizationUnitTypeFilter(OrganizationUnitType ... value) {
		addMultiReferenceValue(Arrays.asList(value), organizationUnitTypeFilter);
		return this;
	}

	@Override
	public RolePrivilegeAssignment removeOrganizationUnitTypeFilter(List<OrganizationUnitType> value) {
		removeMultiReferenceValue(value, organizationUnitTypeFilter);
		return this;
	}

	@Override
	public RolePrivilegeAssignment removeOrganizationUnitTypeFilter(OrganizationUnitType ... value) {
		removeMultiReferenceValue(Arrays.asList(value), organizationUnitTypeFilter);
		return this;
	}

	@Override
	public RolePrivilegeAssignment removeAllOrganizationUnitTypeFilter() {
		removeAllMultiReferenceValue(organizationUnitTypeFilter);
		return this;
	}


    @Override
    public UdbRolePrivilegeAssignment save(Transaction transaction, boolean strictChangeVerification) {
        save(transaction, table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbRolePrivilegeAssignment saveTransactional(boolean strictChangeVerification) {
        save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbRolePrivilegeAssignment save() {
        save(table);
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        delete(transaction, table);
    }

    @Override
    public void delete() {
        delete(table);
    }

	@Override
	public String toString() {
    	StringBuilder sb = new StringBuilder();
    	sb.append(table.getName()).append(": ").append(getId()).append("\n");
		for (ColumnIndex column : table.getColumnIndices()) {
			sb.append("\t").append(column.getName()).append(": ").append(column.getStringValue(getId()));
			if (isChanged(column)) {
				TransactionRecordValue changeValue = getChangeValue(column);
				sb.append(" -> ").append(changeValue.getValue());
			}
			sb.append("\n");
		}
		return sb.toString();
	}
}



