package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbSystemLog extends AbstractUdbEntity<SystemLog> implements SystemLog {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static SingleReferenceIndex managedApplication;
	protected static SingleReferenceIndex managedPerspective;
	protected static SingleReferenceIndex application;
	protected static SingleReferenceIndex applicationPerspective;
	protected static SingleReferenceIndex applicationVersion;
	protected static ShortIndex logLevel;
	protected static TextIndex thread;
	protected static TextIndex message;
	protected static TextIndex details;
	protected static TextIndex exceptionClass;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		managedApplication = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_MANAGED_APPLICATION);
		managedPerspective = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_MANAGED_PERSPECTIVE);
		application = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_APPLICATION);
		applicationPerspective = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_APPLICATION_PERSPECTIVE);
		applicationVersion = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_APPLICATION_VERSION);
		logLevel = (ShortIndex) tableIndex.getColumnIndex(FIELD_LOG_LEVEL);
		thread = (TextIndex) tableIndex.getColumnIndex(FIELD_THREAD);
		message = (TextIndex) tableIndex.getColumnIndex(FIELD_MESSAGE);
		details = (TextIndex) tableIndex.getColumnIndex(FIELD_DETAILS);
		exceptionClass = (TextIndex) tableIndex.getColumnIndex(FIELD_EXCEPTION_CLASS);
    }

    public static List<SystemLog> getAll() {
        return new EntityBitSetList<>(SystemLog.getBuilder(), table.getRecordBitSet());
    }

    public static List<SystemLog> sort(List<SystemLog> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<SystemLog> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, SystemLog.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbSystemLog() {
        super(table);
    }

    public UdbSystemLog(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public SystemLog build() {
        return new UdbSystemLog();
    }

    @Override
    public SystemLog build(int id) {
        return new UdbSystemLog(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public SystemLog setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public SystemLog setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public SystemLog setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public SystemLog setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public SystemLog setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public SystemLog setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public SystemLog setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public SystemLog setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public SystemLog setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public SystemLog setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public SystemLog setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public SystemLog setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public ManagedApplication getManagedApplication() {
		if (isChanged(managedApplication)) {
			return (ManagedApplication) getReferenceChangeValue(managedApplication);
		} else {
			int id = managedApplication.getValue(getId());
			if (id > 0) {
				return ManagedApplication.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public SystemLog setManagedApplication(ManagedApplication value) {
		setSingleReferenceValue(managedApplication, value, table);
		return this;
	}

	@Override
	public ManagedApplicationPerspective getManagedPerspective() {
		if (isChanged(managedPerspective)) {
			return (ManagedApplicationPerspective) getReferenceChangeValue(managedPerspective);
		} else {
			int id = managedPerspective.getValue(getId());
			if (id > 0) {
				return ManagedApplicationPerspective.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public SystemLog setManagedPerspective(ManagedApplicationPerspective value) {
		setSingleReferenceValue(managedPerspective, value, table);
		return this;
	}

	@Override
	public Application getApplication() {
		if (isChanged(application)) {
			return (Application) getReferenceChangeValue(application);
		} else {
			int id = application.getValue(getId());
			if (id > 0) {
				return Application.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public SystemLog setApplication(Application value) {
		setSingleReferenceValue(application, value, table);
		return this;
	}

	@Override
	public ApplicationPerspective getApplicationPerspective() {
		if (isChanged(applicationPerspective)) {
			return (ApplicationPerspective) getReferenceChangeValue(applicationPerspective);
		} else {
			int id = applicationPerspective.getValue(getId());
			if (id > 0) {
				return ApplicationPerspective.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public SystemLog setApplicationPerspective(ApplicationPerspective value) {
		setSingleReferenceValue(applicationPerspective, value, table);
		return this;
	}

	@Override
	public ApplicationVersion getApplicationVersion() {
		if (isChanged(applicationVersion)) {
			return (ApplicationVersion) getReferenceChangeValue(applicationVersion);
		} else {
			int id = applicationVersion.getValue(getId());
			if (id > 0) {
				return ApplicationVersion.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public SystemLog setApplicationVersion(ApplicationVersion value) {
		setSingleReferenceValue(applicationVersion, value, table);
		return this;
	}

	@Override
	public LogLevel getLogLevel() {
	    return getEnumValue(logLevel, LogLevel.values());
	}

	@Override
	public SystemLog setLogLevel(LogLevel value) {
    	setEnumValue(this.logLevel, value);
		return this;
	}

	@Override
	public String getThread() {
        return getTextValue(thread);
	}

	@Override
	public SystemLog setThread(String value) {
	    setTextValue(value, this.thread);
		return this;
	}

	@Override
	public String getMessage() {
        return getTextValue(message);
	}

	@Override
	public SystemLog setMessage(String value) {
	    setTextValue(value, this.message);
		return this;
	}

	@Override
	public String getDetails() {
        return getTextValue(details);
	}

	@Override
	public SystemLog setDetails(String value) {
	    setTextValue(value, this.details);
		return this;
	}

	@Override
	public String getExceptionClass() {
        return getTextValue(exceptionClass);
	}

	@Override
	public SystemLog setExceptionClass(String value) {
	    setTextValue(value, this.exceptionClass);
		return this;
	}


    @Override
    public UdbSystemLog save(Transaction transaction, boolean strictChangeVerification) {
        save(transaction, table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbSystemLog saveTransactional(boolean strictChangeVerification) {
        save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbSystemLog save() {
        save(table);
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        delete(transaction, table);
    }

    @Override
    public void delete() {
        delete(table);
    }

	@Override
	public String toString() {
    	StringBuilder sb = new StringBuilder();
    	sb.append(table.getName()).append(": ").append(getId()).append("\n");
		for (ColumnIndex column : table.getColumnIndices()) {
			sb.append("\t").append(column.getName()).append(": ").append(column.getStringValue(getId()));
			if (isChanged(column)) {
				TransactionRecordValue changeValue = getChangeValue(column);
				sb.append(" -> ").append(changeValue.getValue());
			}
			sb.append("\n");
		}
		return sb.toString();
	}
}



