package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbUserContainer extends AbstractUdbEntity<UserContainer> implements UserContainer {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static SingleReferenceIndex organizationUnit;
	protected static MultiReferenceIndex users;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		organizationUnit = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ORGANIZATION_UNIT);
		users = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_USERS);
    }

    public static List<UserContainer> getAll() {
        return new EntityBitSetList<>(UserContainer.getBuilder(), table.getRecordBitSet());
    }

    public static List<UserContainer> sort(List<UserContainer> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<UserContainer> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, UserContainer.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbUserContainer() {
        super(table);
    }

    public UdbUserContainer(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public UserContainer build() {
        return new UdbUserContainer();
    }

    @Override
    public UserContainer build(int id) {
        return new UdbUserContainer(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public UserContainer setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public UserContainer setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public UserContainer setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public UserContainer setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public UserContainer setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public UserContainer setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public UserContainer setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public UserContainer setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public UserContainer setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public UserContainer setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public UserContainer setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public UserContainer setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public OrganizationUnit getOrganizationUnit() {
		if (isChanged(organizationUnit)) {
			return (OrganizationUnit) getReferenceChangeValue(organizationUnit);
		} else {
			int id = organizationUnit.getValue(getId());
			if (id > 0) {
				return OrganizationUnit.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public UserContainer setOrganizationUnit(OrganizationUnit value) {
		setSingleReferenceValue(organizationUnit, value, table);
		return this;
	}

	@Override
	public List<User> getUsers() {
	    return getMultiReferenceValue(users, User.getBuilder());
	}

	@Override
	public UserContainer setUsers(List<User> value) {
		setMultiReferenceValue(value, users);
		return this;
	}

	@Override
	public int getUsersCount() {
	    return getMultiReferenceValueCount(users, User.getBuilder());
	}

	@Override
	public UserContainer setUsers(User ... value) {
		setMultiReferenceValue(Arrays.asList(value), users);
		return this;
	}

	@Override
	public BitSet getUsersAsBitSet() {
	    return getMultiReferenceValueAsBitSet(users, User.getBuilder());
	}

	@Override
	public UserContainer addUsers(List<User> value) {
		addMultiReferenceValue(value, users);
		return this;
	}

	@Override
	public UserContainer addUsers(User ... value) {
		addMultiReferenceValue(Arrays.asList(value), users);
		return this;
	}

	@Override
	public UserContainer removeUsers(List<User> value) {
		removeMultiReferenceValue(value, users);
		return this;
	}

	@Override
	public UserContainer removeUsers(User ... value) {
		removeMultiReferenceValue(Arrays.asList(value), users);
		return this;
	}

	@Override
	public UserContainer removeAllUsers() {
		removeAllMultiReferenceValue(users);
		return this;
	}


    @Override
    public UdbUserContainer save(Transaction transaction, boolean strictChangeVerification) {
        save(transaction, table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbUserContainer saveTransactional(boolean strictChangeVerification) {
        save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbUserContainer save() {
        save(table);
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        delete(transaction, table);
    }

    @Override
    public void delete() {
        delete(table);
    }

	@Override
	public String toString() {
    	StringBuilder sb = new StringBuilder();
    	sb.append(table.getName()).append(": ").append(getId()).append("\n");
		for (ColumnIndex column : table.getColumnIndices()) {
			sb.append("\t").append(column.getName()).append(": ").append(column.getStringValue(getId()));
			if (isChanged(column)) {
				TransactionRecordValue changeValue = getChangeValue(column);
				sb.append(" -> ").append(changeValue.getValue());
			}
			sb.append("\n");
		}
		return sb.toString();
	}
}



