/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.organization;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.ApplicationPerspective;
import org.teamapps.application.api.localization.Country;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.controlcenter.organization.OrganizationChartPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.organization.OrganizationFieldPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.organization.OrganizationPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.organization.OrganizationUnitTypePerspectiveBuilder;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.application.PerspectiveMenuPanel;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.server.ux.IconUtils;
import org.teamapps.application.server.ux.UiUtils;
import org.teamapps.application.server.ux.address.AddressForm;
import org.teamapps.application.server.ux.localize.TranslatableField;
import org.teamapps.application.server.ux.localize.TranslatableTextUtils;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.common.format.Color;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.databinding.MutableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.GeoLocationType;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.model.controlcenter.OrganizationUnitType;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.tree.Tree;

public class OrganizationPerspective
extends AbstractManagedApplicationPerspective {
    private final TwoWayBindableValue<OrganizationUnit> selectedUnit = TwoWayBindableValue.create();

    public OrganizationPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.createUi();
    }

    private void createUi() {
        OrganizationPerspectiveBuilder organizationPerspectiveBuilder = new OrganizationPerspectiveBuilder();
        PerspectiveMenuPanel menuPanel = PerspectiveMenuPanel.createMenuPanel(this.getApplicationInstanceData(), new OrganizationChartPerspectiveBuilder(), organizationPerspectiveBuilder, new OrganizationUnitTypePerspectiveBuilder(), new OrganizationFieldPerspectiveBuilder());
        menuPanel.addInstantiatedPerspective(organizationPerspectiveBuilder, (ApplicationPerspective)this);
        this.setPerspectiveMenuPanel(menuPanel.getComponent());
        View masterView = this.getPerspective().addView(View.createView((String)"center", (Icon)ApplicationIcons.ELEMENTS_HIERARCHY, (String)this.getLocalized("organization.organizationUnits"), null));
        View detailView = this.getPerspective().addView(View.createView((String)"right", (Icon)ApplicationIcons.ELEMENTS_HIERARCHY, (String)this.getLocalized("organization.organizationUnit"), null));
        detailView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        EntityModelBuilder orgUnitModelBuilder = new EntityModelBuilder(OrganizationUnit::filter, this.getApplicationInstanceData());
        orgUnitModelBuilder.attachViewCountHandler(masterView, () -> this.getLocalized("organization.organizationUnits"));
        orgUnitModelBuilder.attachSearchField(masterView);
        orgUnitModelBuilder.onSelectedRecordChanged.addListener(arg_0 -> this.selectedUnit.set(arg_0));
        Tree tree = orgUnitModelBuilder.createTree((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES, PropertyProviders.creatOrganizationUnitPropertyProvider(this.getApplicationInstanceData()), OrganizationUnit::getParent, unit -> OrganizationUtils.getLevel(unit) < 2);
        orgUnitModelBuilder.updateModels();
        masterView.setComponent((Component)tree);
        ToolbarButtonGroup buttonGroup = detailView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton addButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.ADD, (String)this.getLocalized("org.teamapps.dictionary.add"), (String)this.getLocalized("org.teamapps.dictionary.addRecord")));
        buttonGroup = detailView.addLocalButtonGroup(new ToolbarButtonGroup());
        ToolbarButton saveButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.FLOPPY_DISK, (String)this.getLocalized("org.teamapps.dictionary.saveChanges")));
        TemplateField<OrganizationUnit> parentUnitField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.creatOrganizationUnitPropertyProvider(this.getApplicationInstanceData()));
        TranslatableField translatableNameField = TranslatableTextUtils.createTranslatableField(this.getApplicationInstanceData());
        ComboBox<OrganizationUnitType> unitTypeComboBox = this.createOrgUnitTypeComboBox();
        ComboBox iconComboBox = ApplicationIcons.createIconComboBox();
        AddressForm addressForm = new AddressForm(this.getApplicationInstanceData());
        addressForm.setWithName(true);
        addressForm.setWithGeoCoordinates(true);
        ResponsiveForm form = new ResponsiveForm(120, 120, 0);
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(450);
        formLayout.addSection(ApplicationIcons.FOLDER, this.getLocalized(""));
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnit.parentUnit"), parentUnitField);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnit.unitName"), (AbstractField)translatableNameField);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnit.unitType"), unitTypeComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnit.icon"), (AbstractField)iconComboBox);
        addressForm.createAddressSection(formLayout);
        addressForm.addFields(formLayout);
        detailView.setComponent((Component)form);
        addButton.onClick.addListener(() -> {
            OrganizationUnit organizationUnit = (OrganizationUnit)this.selectedUnit.get();
            if (organizationUnit == null && OrganizationUnit.getCount() > 0) {
                UiUtils.showNotification(ApplicationIcons.ERROR, this.getLocalized("organizationUnit.errorNoOrgUnitSelected"));
                return;
            }
            this.selectedUnit.set((Object)OrganizationUnit.create().setParent(organizationUnit));
        });
        saveButton.onClick.addListener(() -> {
            OrganizationUnit unit = (OrganizationUnit)this.selectedUnit.get();
            if (unit == null) {
                UiUtils.showSaveNotification(false, this.getApplicationInstanceData());
                return;
            }
            OrganizationUnit parentUnit = unit.getParent();
            if (translatableNameField.getValue() != null && unitTypeComboBox.getValue() != null && addressForm.validateAddress() && (parentUnit != null || OrganizationUnit.getCount() == 0)) {
                unit.setParent(parentUnit).setName(translatableNameField.getValue()).setType((OrganizationUnitType)unitTypeComboBox.getValue()).setIcon(IconUtils.encodeNoStyle((Icon)iconComboBox.getValue())).setAddress(addressForm.getAddress()).save();
                UiUtils.showSaveNotification(true, this.getApplicationInstanceData());
                orgUnitModelBuilder.updateModels();
            } else {
                UiUtils.showSaveNotification(false, this.getApplicationInstanceData());
            }
        });
        this.selectedUnit.onChanged().addListener(unit -> {
            parentUnitField.setValue((Object)unit.getParent());
            translatableNameField.setValue(unit.getName());
            unitTypeComboBox.setValue((Object)unit.getType());
            iconComboBox.setValue(IconUtils.decodeIcon(unit.getIcon()));
            addressForm.setAddress(unit.getAddress());
            if (!unit.isStored()) {
                OrganizationUnit countryParent;
                if (unit.getParent() != null) {
                    unitTypeComboBox.setValue((Object)unit.getParent().getType().getDefaultChildType());
                }
                if (OrganizationUtils.getParentWithGeoType(unit, GeoLocationType.COUNTRY) != null && (countryParent = OrganizationUtils.getParentWithGeoType(unit, GeoLocationType.COUNTRY)).getAddress() != null) {
                    addressForm.getCountryComboBox().setValue((Object)Country.getCountryByIsoCode((String)countryParent.getAddress().getCountry()));
                }
            }
        });
        if (OrganizationUnit.getCount() == 0) {
            this.selectedUnit.set((Object)OrganizationUnit.create().setParent(null));
        }
    }

    private void printUnits(OrganizationUnit unit, int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append("\t");
        }
        String space = sb.toString();
        System.out.println(space + unit.getName().getText() + " (" + unit.getType().getName().getText() + ")");
        for (OrganizationUnit child : unit.getChildren()) {
            this.printUnits(child, level + 1);
        }
    }

    private ComboBox<OrganizationUnitType> createOrgUnitTypeComboBox() {
        ComboBox comboBox = new ComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        PropertyProvider<OrganizationUnitType> propertyProvider = PropertyProviders.creatOrganizationUnitTypePropertyProvider(this.getApplicationInstanceData());
        comboBox.setModel(query -> {
            List<OrganizationUnitType> allowedTypes;
            List<OrganizationUnitType> list = allowedTypes = this.selectedUnit.get() != null && ((OrganizationUnit)this.selectedUnit.get()).getParent() != null ? ((OrganizationUnit)this.selectedUnit.get()).getParent().getType().getPossibleChildrenTypes() : OrganizationUnitType.getAll();
            if (query == null || query.isBlank()) {
                return allowedTypes;
            }
            String q = query.toLowerCase();
            return allowedTypes.stream().filter(type -> ((String)propertyProvider.getValues(type, Collections.emptyList()).get("caption")).toLowerCase().contains(q)).collect(Collectors.toList());
        });
        comboBox.setPropertyProvider(propertyProvider);
        comboBox.setRecordToStringFunction(unitType -> (String)propertyProvider.getValues(unitType, Collections.emptyList()).get("caption"));
        return comboBox;
    }
}

