/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.application;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.AbstractPerspectiveBuilder;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.ApplicationPerspective;
import org.teamapps.application.api.privilege.ApplicationPrivilegeProvider;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.tree.Tree;
import org.teamapps.ux.model.ListTreeModel;
import org.teamapps.ux.model.TreeModel;

public class PerspectiveMenuPanel {
    private final ApplicationInstanceData applicationInstanceData;
    private final List<AbstractPerspectiveBuilder> perspectiveBuilders;
    private Tree<AbstractPerspectiveBuilder> tree;
    private Map<AbstractPerspectiveBuilder, ApplicationPerspective> perspectiveByBuilderMap;

    public static PerspectiveMenuPanel createMenuPanel(ApplicationInstanceData applicationInstanceData, AbstractPerspectiveBuilder ... perspectiveBuilders) {
        return PerspectiveMenuPanel.createMenuPanel(applicationInstanceData, Arrays.asList(perspectiveBuilders));
    }

    public static PerspectiveMenuPanel createMenuPanel(ApplicationInstanceData applicationInstanceData, List<AbstractPerspectiveBuilder> perspectiveBuilders) {
        return new PerspectiveMenuPanel(applicationInstanceData, perspectiveBuilders);
    }

    public PerspectiveMenuPanel(ApplicationInstanceData applicationInstanceData, List<AbstractPerspectiveBuilder> perspectiveBuilders) {
        this.applicationInstanceData = applicationInstanceData;
        this.perspectiveBuilders = perspectiveBuilders;
        this.init();
    }

    private void init() {
        this.perspectiveByBuilderMap = new HashMap<AbstractPerspectiveBuilder, ApplicationPerspective>();
        List allowedPerspectiveBuilders = this.perspectiveBuilders.stream().filter(p -> p.isPerspectiveAccessible((ApplicationPrivilegeProvider)this.applicationInstanceData)).collect(Collectors.toList());
        ListTreeModel treeModel = new ListTreeModel(allowedPerspectiveBuilders);
        this.tree = new Tree((TreeModel)treeModel);
        this.tree.setShowExpanders(false);
        this.tree.setEntryTemplate((Template)BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES);
        this.tree.setPropertyExtractor((builder, propertyName) -> switch (propertyName) {
            case "icon" -> builder.getIcon();
            case "caption" -> this.applicationInstanceData.getLocalized(builder.getTitleKey(), new Object[0]);
            case "description" -> this.applicationInstanceData.getLocalized(builder.getDescriptionKey(), new Object[0]);
            default -> null;
        });
        this.tree.onNodeSelected.addListener(builder -> this.openPerspective((AbstractPerspectiveBuilder)builder));
        if (!treeModel.getRecords().isEmpty()) {
            this.tree.setSelectedNode((Object)((AbstractPerspectiveBuilder)treeModel.getRecords().get(0)));
        }
    }

    public void openPerspective(AbstractPerspectiveBuilder builder) {
        ApplicationPerspective applicationPerspective = this.perspectiveByBuilderMap.get(builder);
        if (applicationPerspective == null) {
            applicationPerspective = builder.build(this.applicationInstanceData, null);
            this.perspectiveByBuilderMap.put(builder, applicationPerspective);
        }
        this.tree.setSelectedNode((Object)builder);
        this.applicationInstanceData.showPerspective(applicationPerspective.getPerspective());
    }

    public void addInstantiatedPerspective(AbstractPerspectiveBuilder builder, ApplicationPerspective perspective) {
        this.perspectiveByBuilderMap.put(builder, perspective);
        this.tree.setSelectedNode((Object)this.tree.getModel().getRecords().stream().filter(record -> record.equals(builder)).findAny().orElse(null));
    }

    public Component getComponent() {
        return this.tree;
    }
}

