/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.bootstrap;

import java.util.Collections;
import java.util.List;
import org.teamapps.application.api.application.ApplicationBuilder;
import org.teamapps.application.api.application.ApplicationPerspectiveBuilder;
import org.teamapps.application.api.application.PerspectiveBuilder;
import org.teamapps.application.server.system.localization.ApplicationScopeLocalizationProvider;
import org.teamapps.application.server.system.privilege.ApplicationScopePrivilegeProvider;
import org.teamapps.model.controlcenter.Application;

public class LoadedApplication {
    private final Application application;
    private final ApplicationBuilder applicationBuilder;
    private final ClassLoader applicationClassLoader;
    private final boolean unmanagedPerspectives;
    private ApplicationScopeLocalizationProvider applicationScopeLocalizationProvider;
    private ApplicationScopePrivilegeProvider applicationScopePrivilegeProvider;

    public LoadedApplication(Application application, ApplicationBuilder applicationBuilder, ClassLoader applicationClassLoader, boolean unmanagedPerspectives) {
        this.application = application;
        this.applicationBuilder = applicationBuilder;
        this.applicationClassLoader = applicationClassLoader;
        this.unmanagedPerspectives = unmanagedPerspectives;
    }

    public List<PerspectiveBuilder> getPerspectiveBuilders() {
        if (this.unmanagedPerspectives) {
            return Collections.emptyList();
        }
        ApplicationPerspectiveBuilder applicationPerspectiveBuilder = (ApplicationPerspectiveBuilder)this.applicationBuilder;
        return applicationPerspectiveBuilder.getPerspectiveBuilders();
    }

    public PerspectiveBuilder getPerspectiveBuilder(String name) {
        return this.getPerspectiveBuilders().stream().filter(perspective -> perspective.getName().equals(name)).findFirst().orElse(null);
    }

    public ApplicationScopeLocalizationProvider getApplicationLocalizationProvider() {
        return this.applicationScopeLocalizationProvider;
    }

    public void setApplicationLocalizationProvider(ApplicationScopeLocalizationProvider applicationScopeLocalizationProvider) {
        this.applicationScopeLocalizationProvider = applicationScopeLocalizationProvider;
    }

    public ApplicationScopePrivilegeProvider getAppPrivilegeProvider() {
        return this.applicationScopePrivilegeProvider;
    }

    public void setAppPrivilegeProvider(ApplicationScopePrivilegeProvider applicationScopePrivilegeProvider) {
        this.applicationScopePrivilegeProvider = applicationScopePrivilegeProvider;
    }

    public Application getApplication() {
        return this.application;
    }

    public ApplicationBuilder getApplicationBuilder() {
        return this.applicationBuilder;
    }

    public ClassLoader getApplicationClassLoader() {
        return this.applicationClassLoader;
    }

    public ClassLoader getApplicationClassLoaderOrDefault() {
        return this.applicationClassLoader != null ? this.applicationClassLoader : this.getClass().getClassLoader();
    }

    public boolean isUnmanagedPerspectives() {
        return this.unmanagedPerspectives;
    }
}

