/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.bootstrap.installer;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.teamapps.application.api.application.ApplicationBuilder;
import org.teamapps.application.api.application.ApplicationPerspectiveBuilder;
import org.teamapps.application.server.system.bootstrap.ApplicationInfo;
import org.teamapps.application.server.system.bootstrap.installer.ApplicationInstallationPhase;
import org.teamapps.universaldb.index.file.FileUtil;

public class ApplicationJarInstallationPhase
implements ApplicationInstallationPhase {
    @Override
    public void checkApplication(ApplicationInfo applicationInfo) {
        try {
            if (applicationInfo.getApplicationJar() == null) {
                return;
            }
            boolean unmanagedApplication = false;
            Object applicationBuilder = null;
            String fileHash = FileUtil.createFileHash((File)applicationInfo.getApplicationJar());
            URLClassLoader classLoader = new URLClassLoader(new URL[]{applicationInfo.getApplicationJar().toURI().toURL()});
            ClassInfoList classInfos = new ClassGraph().overrideClassLoaders(new ClassLoader[]{classLoader}).enableAllInfo().scan().getClassesImplementing(ApplicationPerspectiveBuilder.class.getName()).getStandardClasses();
            if (classInfos.size() == 0) {
                classInfos = new ClassGraph().overrideClassLoaders(new ClassLoader[]{classLoader}).enableAllInfo().scan().getClassesImplementing(ApplicationBuilder.class.getName()).getStandardClasses();
                unmanagedApplication = true;
            }
            if (classInfos.isEmpty()) {
                applicationInfo.addError("Could not find application in jar file");
                return;
            }
            if (classInfos.size() > 1) {
                applicationInfo.addError("Too many application classes in jar file");
                return;
            }
            Class builder = ((ClassInfo)classInfos.get(0)).loadClass();
            applicationBuilder = unmanagedApplication ? (ApplicationPerspectiveBuilder)builder.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : (ApplicationBuilder)builder.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            applicationInfo.setApplicationBuilder((ApplicationBuilder)applicationBuilder);
            applicationInfo.setUnmanagedPerspectives(unmanagedApplication);
            applicationInfo.setBinaryHash(fileHash);
            applicationInfo.setApplicationClassLoader(classLoader);
        }
        catch (Exception e) {
            e.printStackTrace();
            applicationInfo.addError("Error checking jar file:" + e.getMessage());
        }
    }

    @Override
    public void installApplication(ApplicationInfo applicationInfo) {
    }

    @Override
    public void loadApplication(ApplicationInfo applicationInfo) {
    }
}

