/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.launcher;

import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.server.system.bootstrap.LoadedApplication;
import org.teamapps.application.server.system.launcher.MobileApplicationNavigation;
import org.teamapps.application.server.system.session.ManagedApplicationSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.ux.IconUtils;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ManagedApplication;

public class ApplicationData {
    private final ManagedApplication managedApplication;
    private LoadedApplication loadedApplication;
    private ManagedApplicationSessionData applicationSessionData;
    private final Icon icon;
    private final String title;
    private final String description;
    private final int applicationPosition;

    public ApplicationData(ManagedApplication managedApplication, LoadedApplication loadedApplication, ManagedApplicationSessionData applicationSessionData) {
        this.managedApplication = managedApplication;
        this.loadedApplication = loadedApplication;
        this.applicationSessionData = applicationSessionData;
        this.icon = managedApplication.getIcon() != null ? IconUtils.decodeIcon(managedApplication.getIcon()) : loadedApplication.getApplicationBuilder().getApplicationIcon();
        ApplicationLocalizationProvider localizationProvider = applicationSessionData.getMainApplicationLocalizationProvider();
        this.title = managedApplication.getTitleKey() != null ? localizationProvider.getLocalized(managedApplication.getTitleKey(), new Object[0]) : localizationProvider.getLocalized(loadedApplication.getApplicationBuilder().getApplicationTitleKey(), new Object[0]);
        this.description = managedApplication.getDescriptionKey() != null ? localizationProvider.getLocalized(managedApplication.getDescriptionKey(), new Object[0]) : localizationProvider.getLocalized(loadedApplication.getApplicationBuilder().getApplicationDescriptionKey(), new Object[0]);
        this.applicationPosition = managedApplication.getListingPosition();
    }

    public void reloadApplicationData(UserSessionData userSessionData) {
        Application application = this.managedApplication.getMainApplication();
        this.loadedApplication = userSessionData.getRegistry().getLoadedApplication(application);
        this.applicationSessionData = userSessionData.createManageApplicationSessionData(this.managedApplication, new MobileApplicationNavigation());
    }

    public ManagedApplication getManagedApplication() {
        return this.managedApplication;
    }

    public LoadedApplication getLoadedApplication() {
        return this.loadedApplication;
    }

    public ManagedApplicationSessionData getApplicationSessionData() {
        return this.applicationSessionData;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getApplicationPosition() {
        return this.applicationPosition;
    }
}

