/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.server;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.teamapps.application.server.system.server.ByteArrayResourceProvider;
import org.teamapps.ux.resource.ByteArrayResource;
import org.teamapps.ux.resource.Resource;

public class SecureLinkBuilder {
    private final String linkPrefix;
    private final String fileSuffix;
    private final ByteArrayResourceProvider byteArrayResourceProvider;
    private final Map<String, Integer> idByKey = new ConcurrentHashMap<String, Integer>();
    private final Map<Integer, String> keyById = new ConcurrentHashMap<Integer, String>();

    public SecureLinkBuilder(String linkPrefix, String fileSuffix, ByteArrayResourceProvider byteArrayResourceProvider) {
        this.linkPrefix = linkPrefix;
        this.fileSuffix = fileSuffix;
        this.byteArrayResourceProvider = byteArrayResourceProvider;
    }

    public String createLink(int id) {
        String key = this.keyById.get(id);
        if (key != null) {
            return this.linkPrefix + "/" + key;
        }
        if (this.byteArrayResourceProvider.getResource(id) == null) {
            return null;
        }
        String uuid = UUID.randomUUID().toString();
        this.idByKey.put(uuid, id);
        this.keyById.put(id, uuid);
        return this.linkPrefix + "/" + uuid;
    }

    public Resource getResource(String key) {
        Integer id = this.idByKey.get(key);
        return id != null ? new ByteArrayResource(this.byteArrayResourceProvider.getResource(id), key + "." + this.fileSuffix) : null;
    }
}

