/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.session;

import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.PerspectiveBuilder;
import org.teamapps.application.api.desktop.ApplicationDesktop;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.privilege.ApplicationPrivilegeProvider;
import org.teamapps.application.api.privilege.CustomObjectPrivilegeGroup;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.privilege.SimpleCustomObjectPrivilege;
import org.teamapps.application.api.privilege.SimpleOrganizationalPrivilege;
import org.teamapps.application.api.privilege.SimplePrivilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.application.api.user.SessionUser;
import org.teamapps.application.server.system.session.ManagedApplicationSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.ux.IconUtils;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.LogLevel;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.ManagedApplicationPerspective;
import org.teamapps.model.controlcenter.OrganizationFieldView;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.model.controlcenter.SystemLog;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.component.progress.MultiProgressDisplay;

public class PerspectiveSessionData
implements ApplicationInstanceData {
    private final ManagedApplicationSessionData managedApplicationSessionData;
    private final ManagedApplication managedApplication;
    private final ManagedApplicationPerspective managedApplicationPerspective;
    private final PerspectiveBuilder perspectiveBuilder;
    private final ApplicationPrivilegeProvider privilegeProvider;
    private final ApplicationLocalizationProvider localizationProvider;
    private final Supplier<DocumentConverter> documentConverterSupplier;
    private final UserSessionData userSessionData;

    public PerspectiveSessionData(ManagedApplicationSessionData managedApplicationSessionData, ManagedApplication managedApplication, ManagedApplicationPerspective managedApplicationPerspective, PerspectiveBuilder perspectiveBuilder, ApplicationPrivilegeProvider privilegeProvider, ApplicationLocalizationProvider localizationProvider, Supplier<DocumentConverter> documentConverterSupplier) {
        this.managedApplicationSessionData = managedApplicationSessionData;
        this.managedApplication = managedApplication;
        this.managedApplicationPerspective = managedApplicationPerspective;
        this.perspectiveBuilder = perspectiveBuilder;
        this.privilegeProvider = privilegeProvider;
        this.localizationProvider = localizationProvider;
        this.documentConverterSupplier = documentConverterSupplier;
        this.userSessionData = managedApplicationSessionData.getUserSessionData();
    }

    public Icon getIcon() {
        if (this.managedApplicationPerspective.getIconOverride() != null) {
            return IconUtils.decodeIcon(this.managedApplicationPerspective.getIconOverride());
        }
        return this.perspectiveBuilder.getIcon();
    }

    public String getTitle() {
        if (this.managedApplicationPerspective.getTitleKeyOverride() != null) {
            return this.userSessionData.getDictionary().getLocalized(this.managedApplicationPerspective.getTitleKeyOverride(), new Object[0]);
        }
        return this.localizationProvider.getLocalized(this.perspectiveBuilder.getTitleKey(), new Object[0]);
    }

    public String getDescription() {
        if (this.managedApplicationPerspective.getDescriptionKeyOverride() != null) {
            return this.userSessionData.getDictionary().getLocalized(this.managedApplicationPerspective.getDescriptionKeyOverride(), new Object[0]);
        }
        return this.localizationProvider.getLocalized(this.perspectiveBuilder.getDescriptionKey(), new Object[0]);
    }

    public ManagedApplicationPerspective getManagedApplicationPerspective() {
        return this.managedApplicationPerspective;
    }

    public ManagedApplicationSessionData getManagedApplicationSessionData() {
        return this.managedApplicationSessionData;
    }

    public PerspectiveBuilder getPerspectiveBuilder() {
        return this.perspectiveBuilder;
    }

    public SessionUser getUser() {
        return this.managedApplicationSessionData.getUserSessionData().getSessionUser();
    }

    public OrganizationFieldView getOrganizationField() {
        return this.managedApplicationSessionData.getOrganizationFieldView();
    }

    public int getManagedApplicationId() {
        return this.managedApplication.getId();
    }

    public DocumentConverter getDocumentConverter() {
        if (this.documentConverterSupplier == null) {
            return null;
        }
        return this.documentConverterSupplier.get();
    }

    public MultiProgressDisplay getMultiProgressDisplay() {
        return this.managedApplicationSessionData.getResponsiveApplication().getMultiProgressDisplay();
    }

    public void showPerspective(Perspective perspective) {
        this.managedApplicationSessionData.getResponsiveApplication().showPerspective(perspective);
    }

    public ApplicationDesktop createApplicationDesktop(Icon icon, String title, boolean select, boolean closable) {
        return null;
    }

    public void writeActivityLog(String title, String data) {
        SystemLog.create().setManagedApplication(this.managedApplication).setManagedPerspective(this.managedApplicationPerspective).setApplication(this.managedApplicationPerspective.getApplicationPerspective().getApplication()).setLogLevel(LogLevel.INFO).setMessage(title).setDetails(data).save();
    }

    public void writeExceptionLog(String title, Throwable throwable) {
        SystemLog.create().setManagedApplication(this.managedApplication).setManagedPerspective(this.managedApplicationPerspective).setApplication(this.managedApplicationPerspective.getApplicationPerspective().getApplication()).setLogLevel(LogLevel.ERROR).setMessage(title).setDetails(ExceptionUtils.getStackTrace((Throwable)throwable)).save();
    }

    public String getLocalized(String s, Object ... objects) {
        return this.localizationProvider.getLocalized(s, objects);
    }

    public String getLocalized(TranslatableText translatableText) {
        return this.localizationProvider.getLocalized(translatableText);
    }

    public boolean isAllowed(SimplePrivilege simplePrivilege) {
        return this.privilegeProvider.isAllowed(simplePrivilege);
    }

    public boolean isAllowed(SimpleOrganizationalPrivilege simpleOrganizationalPrivilege, OrganizationUnitView organizationUnitView) {
        return this.privilegeProvider.isAllowed(simpleOrganizationalPrivilege, organizationUnitView);
    }

    public boolean isAllowed(SimpleCustomObjectPrivilege simpleCustomObjectPrivilege, PrivilegeObject privilegeObject) {
        return this.privilegeProvider.isAllowed(simpleCustomObjectPrivilege, privilegeObject);
    }

    public boolean isAllowed(StandardPrivilegeGroup standardPrivilegeGroup, Privilege privilege) {
        return this.privilegeProvider.isAllowed(standardPrivilegeGroup, privilege);
    }

    public boolean isAllowed(OrganizationalPrivilegeGroup organizationalPrivilegeGroup, Privilege privilege, OrganizationUnitView organizationUnitView) {
        return this.privilegeProvider.isAllowed(organizationalPrivilegeGroup, privilege, organizationUnitView);
    }

    public boolean isAllowed(CustomObjectPrivilegeGroup customObjectPrivilegeGroup, Privilege privilege, PrivilegeObject privilegeObject) {
        return this.privilegeProvider.isAllowed(customObjectPrivilegeGroup, privilege, privilegeObject);
    }

    public List<OrganizationUnitView> getAllowedUnits(SimpleOrganizationalPrivilege simpleOrganizationalPrivilege) {
        return this.privilegeProvider.getAllowedUnits(simpleOrganizationalPrivilege);
    }

    public List<OrganizationUnitView> getAllowedUnits(OrganizationalPrivilegeGroup organizationalPrivilegeGroup, Privilege privilege) {
        return this.privilegeProvider.getAllowedUnits(organizationalPrivilegeGroup, privilege);
    }

    public List<PrivilegeObject> getAllowedPrivilegeObjects(SimpleCustomObjectPrivilege simpleCustomObjectPrivilege) {
        return this.privilegeProvider.getAllowedPrivilegeObjects(simpleCustomObjectPrivilege);
    }

    public List<PrivilegeObject> getAllowedPrivilegeObjects(CustomObjectPrivilegeGroup customObjectPrivilegeGroup, Privilege privilege) {
        return this.privilegeProvider.getAllowedPrivilegeObjects(customObjectPrivilegeGroup, privilege);
    }
}

